/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class SetMap<K, V>
extends CollectionMap<K, V, Set<V>> {
    private static final long serialVersionUID = 1L;
    private final ESetFactory setFactory;

    public SetMap() {
        this(ESetFactory.HASHSET);
    }

    public SetMap(ESetFactory setFactory) {
        this.setFactory = setFactory;
    }

    @SafeVarargs
    public SetMap(SetMap<K, V> ... otherMaps) {
        this(SetMap.determineFactory(otherMaps));
        for (SetMap<K, V> otherMap : otherMaps) {
            this.addAll(otherMap);
        }
    }

    public SetMap(Map<K, Set<V>> other) {
        this();
        this.addAll(other);
    }

    private static <K, V> ESetFactory determineFactory(SetMap<K, V>[] otherMaps) {
        if (otherMaps.length > 0) {
            return otherMaps[0].setFactory;
        }
        return ESetFactory.HASHSET;
    }

    @SafeVarargs
    public SetMap(Map<K, Set<V>> ... otherMaps) {
        this();
        for (Map<K, Set<V>> otherMap : otherMaps) {
            this.addAll(otherMap);
        }
    }

    @Override
    protected Set<V> createNewCollection() {
        return switch (this.setFactory.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new HashSet();
            case 1 -> new IdentityHashSet();
        };
    }

    public SetMap<V, K> invert() {
        SetMap invertedMap = new SetMap();
        for (Object nowValue : this.getKeys()) {
            for (Object nowKey : (Set)this.getCollectionOrEmpty(nowValue)) {
                invertedMap.add(nowKey, nowValue);
            }
        }
        return invertedMap;
    }

    public <K2> SetMap<K2, V> mapKeys(Function<? super K, K2> mapper) {
        CCSMAssert.isNotNull(mapper, () -> String.format("Expected \"%s\" to be not null", "mapper"));
        SetMap<K2, V> result = new SetMap<K2, V>(this.setFactory);
        for (Map.Entry entry : this) {
            K2 key = mapper.apply(entry.getKey());
            result.addAll(key, (Collection)entry.getValue());
        }
        return result;
    }

    public <V2> SetMap<K, V2> mapValues(Function<? super V, V2> mapper) {
        CCSMAssert.isNotNull(mapper, () -> String.format("Expected \"%s\" to be not null", "mapper"));
        SetMap result = new SetMap(this.setFactory);
        for (Map.Entry entry : this) {
            Object key = entry.getKey();
            for (Object value : (Set)entry.getValue()) {
                result.add(key, mapper.apply(value));
            }
        }
        return result;
    }

    public static <K, V> SetMap<K, V> of(K key, V ... values) {
        SetMap<K, V> result = new SetMap<K, V>();
        result.addAll(key, Arrays.asList(values));
        return result;
    }

    @IndexValueClass(containedInBackup=true)
    public static enum ESetFactory {
        HASHSET,
        IDENTITY_HASHSET;

    }
}

