/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.InputStream;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;

public class ChunkInputStream
extends InputStream {
    private final List<byte[]> chunks;
    private int nextChunkIndex;
    private int remaining;
    private byte[] currentChunk;
    private int currentOffset;

    public ChunkInputStream(List<byte[]> chunks) {
        this(chunks, ChunkInputStream.getLastChunkSize(chunks));
    }

    private static int getLastChunkSize(List<byte[]> chunks) {
        CCSMAssert.isNotNull(chunks);
        if (chunks.isEmpty()) {
            return 0;
        }
        return CollectionUtils.getLast(chunks).length;
    }

    public ChunkInputStream(List<byte[]> chunks, int lastChunkSize) {
        CCSMAssert.isNotNull(chunks);
        this.chunks = chunks;
        this.currentChunk = null;
        for (byte[] chunk : this.chunks) {
            this.remaining += chunk.length;
        }
        if (!this.chunks.isEmpty()) {
            this.currentChunk = this.chunks.get(0);
            byte[] lastChunk = CollectionUtils.getLast(this.chunks);
            CCSMAssert.isTrue(lastChunkSize > 0 && lastChunkSize <= lastChunk.length, "lastChunkSize must be in range ]0,lastChunk.length]");
            this.remaining -= lastChunk.length - lastChunkSize;
        }
        this.nextChunkIndex = 1;
        this.currentOffset = 0;
    }

    @Override
    public int read() {
        this.updateChunk();
        if (this.remaining <= 0) {
            return -1;
        }
        --this.remaining;
        return ByteArrayUtils.unsignedByte(this.currentChunk[this.currentOffset++]);
    }

    @Override
    public int read(byte[] b, int offset, int length) {
        CCSMAssert.isNotNull(b);
        CCSMAssert.isFalse(offset < 0 || length < 0 || length > b.length - offset, "invalid offset/length");
        if (length == 0) {
            return 0;
        }
        if (this.remaining <= 0) {
            return -1;
        }
        int alreadyRead = 0;
        while (this.remaining > 0 && alreadyRead < length) {
            this.updateChunk();
            int readNow = Math.min(this.currentChunk.length - this.currentOffset, length - alreadyRead);
            System.arraycopy(this.currentChunk, this.currentOffset, b, offset + alreadyRead, readNow);
            this.currentOffset += readNow;
            alreadyRead += readNow;
            this.remaining -= readNow;
        }
        return alreadyRead;
    }

    @Override
    public int available() {
        return this.remaining;
    }

    @Override
    public void close() {
    }

    private void updateChunk() {
        if (this.currentChunk != null && this.currentOffset == this.currentChunk.length) {
            if (this.nextChunkIndex < this.chunks.size()) {
                this.currentChunk = this.chunks.get(this.nextChunkIndex++);
                this.currentOffset = 0;
            } else {
                this.currentChunk = null;
            }
        }
    }
}

