/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedProxyClass;
import org.conqat.lib.commons.serialization.objects.SerializedArrayObject;
import org.conqat.lib.commons.serialization.objects.SerializedClassObject;
import org.conqat.lib.commons.serialization.objects.SerializedEnumLiteral;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;

public class SerializedEntityParser {
    private final DataInputStream din;
    private final SerializedEntityPool pool = new SerializedEntityPool();

    private SerializedEntityParser(DataInputStream din) {
        CCSMAssert.isTrue(din.markSupported(), "Our parser requires an input stream that supports marking! However, all calling methods should ensure this.");
        this.din = din;
    }

    private SerializedEntityPool parse() throws IOException {
        short magic = this.din.readShort();
        if (magic != -21267) {
            throw new IOException("Magic header not found!");
        }
        short version = this.din.readShort();
        if (version != 5) {
            throw new IOException("Unexpected stream version!");
        }
        try {
            while (true) {
                this.pool.registerRootHandle(this.parseContent());
            }
        }
        catch (EOFException eOFException) {
            return this.pool;
        }
    }

    public int parseContent() throws IOException {
        byte next = this.din.readByte();
        return switch (next) {
            case 115 -> this.parseObject();
            case 118 -> this.parseClass();
            case 117 -> this.parseArray();
            case 116 -> this.parseString(false);
            case 124 -> this.parseString(true);
            case 126 -> this.parseEnum();
            case 114 -> this.parsePlainClassDesc();
            case 125 -> this.parseProxyClassDesc();
            case 113 -> this.readHandle();
            case 112 -> 0;
            case 123 -> throw new IOException("Top-level exceptions are not supported!");
            case 121 -> {
                this.pool.reset();
                yield 0;
            }
            case 119, 122 -> throw new IOException("Unexpected block data at top-level!");
            default -> throw new IOException("Unexpected value for next: " + next);
        };
    }

    private int parseClass() throws IOException {
        return new SerializedClassObject(this.pool, this.parseClassDesc()).getHandle();
    }

    private int parseString(boolean longString) throws IOException {
        return new SerializedStringObject(this.din, this.pool, longString).getHandle();
    }

    private int parseObject() throws IOException {
        return new SerializedObject(this.din, this.pool, this, this.parseClassDesc()).getHandle();
    }

    private int parseArray() throws IOException {
        return new SerializedArrayObject(this.din, this.pool, this, this.parseClassDesc()).getHandle();
    }

    private int parseEnum() throws IOException {
        return new SerializedEnumLiteral(this.pool, this, this.parseClassDesc()).getHandle();
    }

    public int parseClassDesc() throws IOException {
        byte next = this.din.readByte();
        return switch (next) {
            case 114 -> this.parsePlainClassDesc();
            case 125 -> this.parseProxyClassDesc();
            case 112 -> 0;
            case 113 -> this.readHandle();
            default -> throw new IOException("Unexpected value for next: " + next);
        };
    }

    private int parsePlainClassDesc() throws IOException {
        return new SerializedClass(this.din, this.pool, this).getHandle();
    }

    private int parseProxyClassDesc() throws IOException {
        return new SerializedProxyClass(this.din, this.pool, this).getHandle();
    }

    private int readHandle() throws IOException {
        int handle = this.din.readInt();
        if (!this.pool.containsHandle(handle)) {
            throw new IOException("Handle to unknown object: " + handle);
        }
        return handle;
    }

    public SerializedStringObject parseStringObject() throws IOException {
        return this.pool.getEntity(this.parseContent(), SerializedStringObject.class);
    }

    public static SerializedEntityPool parse(DataInputStream din) throws IOException {
        return new SerializedEntityParser(din).parse();
    }

    public static SerializedEntityPool parse(InputStream in) throws IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        return SerializedEntityParser.parse(new DataInputStream(in));
    }

    public static SerializedEntityPool parse(byte[] data) throws IOException {
        return SerializedEntityParser.parse(new ByteArrayInputStream(data));
    }

    public static boolean isSerializedObjectStream(byte[] data) throws IOException {
        if (data.length < 2) {
            return false;
        }
        try (DataInputStream din = new DataInputStream(new ByteArrayInputStream(data));){
            boolean bl = din.readShort() == -21267;
            return bl;
        }
    }
}

