/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.google.common.base.Preconditions;
import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.user.User;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public abstract class SsoAuthenticationServiceBase
extends ApiBase {
    protected Response buildSsoResponse(@NonNull User user, @Nullable String redirectionTarget) throws StorageException {
        if (StringUtils.isEmpty((String)redirectionTarget)) {
            redirectionTarget = "/dashboard/show";
        }
        Preconditions.checkNotNull((Object)user);
        if (AuthenticationManager.isDenyAll((User)user)) {
            throw new NotAuthorizedException((Object)("User " + user.getUsername() + " has been blocked from logging in. Please contact your administrator."), new Object[0]);
        }
        Response.ResponseBuilder responseBuilder = this.createRedirectResponseBuilder(redirectionTarget);
        SessionIndex sessionIndex = this.openGlobalIndex(SessionIndex.class);
        AuditLogs.userAuthentication((String)user.getUsername());
        return this.serviceInfo.getAuthenticationRequestHandler().setSessionCookieHeader(user, responseBuilder, this.serviceInfo.getRequestBaseUri(), sessionIndex, false).build();
    }

    protected URI buildErrorURI(String uri) {
        return this.createRedirectUri("/login?error=" + uri);
    }
}

