/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.badge.velocity;

import com.teamscale.service.badge.velocity.Segment;
import java.util.ArrayList;
import java.util.List;

public class BadgeData {
    protected final List<Segment> segments = new ArrayList<Segment>();

    public void appendTitle(String text, String tooltip) {
        this.segments.add(new Segment(text, tooltip, "#555", this.getFullWidth()));
    }

    public void appendSegment(String text, String tooltip, String color) {
        this.segments.add(new Segment(text, tooltip, color, this.getFullWidth()));
    }

    public void appendSegmentWithCustomWidth(double segmentWidth, String tooltip, String color) {
        if (segmentWidth > 0.0) {
            this.segments.add(new Segment(tooltip, color, this.getFullWidth(), segmentWidth * 100.0));
        }
    }

    public void appendSegment(String text, String color) {
        this.segments.add(new Segment(text, "", color, this.getFullWidth()));
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public double getFullWidth() {
        return this.segments.stream().mapToDouble(Segment::getSegmentWidth).sum();
    }
}

