/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.commits.RepositoryLogFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class RepositoryChurnServiceUtils {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static List<ExtendedRepositoryLogEntry> getRepositoryLogEntriesForCommits(RepositoryLogFilter filter, List<? extends CommitDescriptor> relevantCommits, CommitResolvingStorageSystem projectStorageSystem, LogEntryResolver logEntryResolver, Logger logger) throws StorageException {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((CommitResolvingStorageSystem)projectStorageSystem).getStorageSystemId();
        supplierArray[1] = () -> relevantCommits.stream().map(CommitDescriptor::toString).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", "));
        logger.traceEntry("Storage system ID: {}, Relevant commits: {}", supplierArray);
        RepositoryLogIndex index = (RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        ArrayList<@NonNull RepositoryLogEntry> repositoryLogEntries = new ArrayList<RepositoryLogEntry>();
        @Nullable List entries = index.getEntries(relevantCommits);
        for (int i = 0; i < entries.size(); ++i) {
            RepositoryLogEntryAggregate entry = (RepositoryLogEntryAggregate)entries.get(i);
            if (entry == null) {
                logger.warn("Repository log entry not found for relevant commit '{}'.", (Object)relevantCommits.get(i));
                continue;
            }
            repositoryLogEntries.add(entry.toAggregateLogEntryWithPrimaryRepository());
        }
        List<ExtendedRepositoryLogEntry> logEntries = logEntryResolver.resolveExtendedRepositoryLogEntry(repositoryLogEntries, null);
        List<ExtendedRepositoryLogEntry> filteredLogEntries = filter.filter(logEntries);
        Collections.sort(filteredLogEntries);
        return (List)logger.traceExit(filteredLogEntries);
    }

    private RepositoryChurnServiceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

