/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.cache.etag.CombiningContributor;
import com.teamscale.service.framework.cache.etag.IndexLastChangeContributorBase;
import com.teamscale.service.issues.IssueIndexBaseLastUpdatedContributor;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public class IssueContributor
extends CombiningContributor {
    public IssueContributor() {
        super(List.of(new IssuesLastUpdatedContributor(), new IssueQueriesLastUpdatedContributor()));
    }

    public static class IssuesLastUpdatedContributor
    extends IssueIndexBaseLastUpdatedContributor<IssueIndex> {
        public IssuesLastUpdatedContributor() {
            super(IssueIndex.class);
        }

        @Override
        protected @NonNull List<HistoryAccessOption> getHistoryAccessOptions(ITeamscaleServiceInfo serviceInfo) {
            return Collections.singletonList(null);
        }
    }

    public static class IssueQueriesLastUpdatedContributor
    extends IndexLastChangeContributorBase {
        protected IChangeTrackingIndex openIndex(ITeamscaleServiceInfo serviceInfo, ContainerRequestContext requestContext) throws Exception {
            return StoredQueryIndex.openIndex((ProjectStorageSystem)serviceInfo.getProjectStorageSystem(), (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.ISSUE);
        }
    }
}

