/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.user.User;
import com.teamscale.index.issues.model.IssueUserResolution;
import com.teamscale.index.requirements_tracing.model.SpecItemUserResolution;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TeamscaleUserAliasResolver {
    private final UserAliasLookup userAliasLookup;

    public TeamscaleUserAliasResolver(UserAliasLookup userAliasLookup) {
        this.userAliasLookup = userAliasLookup;
    }

    public IssueUserResolution resolveIssue(TeamscaleIssue issue) {
        return new IssueUserResolution(this.resolveUser(issue.getAssignee()), this.resolveUser(issue.getAuthor()));
    }

    public List<IssueUserResolution> resolveIssues(List<? extends TeamscaleIssue> issues) {
        return issues.stream().map(issue -> {
            if (issue == null) {
                return null;
            }
            return this.resolveIssue((TeamscaleIssue)issue);
        }).collect(Collectors.toList());
    }

    public SpecItemUserResolution resolveSpecItem(SpecItem specItem) {
        return new SpecItemUserResolution(this.resolveUsers(specItem.getAdditionalAssignees()));
    }

    public List<SpecItemUserResolution> resolveSpecItems(List<? extends SpecItem> specItems) {
        return specItems.stream().map(specItem -> {
            if (specItem == null) {
                return null;
            }
            return this.resolveSpecItem((SpecItem)specItem);
        }).collect(Collectors.toList());
    }

    private @Nullable User resolveUser(String alias) {
        return this.userAliasLookup.resolveUser(alias).orElse(null);
    }

    private @NonNull List<@NonNull User> resolveUsers(List<String> aliases) {
        return aliases.stream().map(arg_0 -> ((UserAliasLookup)this.userAliasLookup).resolveUser(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
    }
}

