/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.license;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.EUserActivityPeriods;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.index.usage_data.UserActivity;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/committer-activity-history")
public class CommitterLastActivityService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_USER_STATISTICS})
    @Operation(summary="Returns committer activity statistics.", tags={"License"}, description="Returns the number of committers who have been contributing during different time durations.")
    public List<UserActivity> calculateCommitterStatistics() throws StorageException {
        return List.of(this.getUserActivity(EUserActivityPeriods.LAST_DAY), this.getUserActivity(EUserActivityPeriods.LAST_WEEK), this.getUserActivity(EUserActivityPeriods.LAST_MONTH), this.getUserActivity(EUserActivityPeriods.LAST_90DAYS), this.getUserActivity(EUserActivityPeriods.LAST_180DAYS), this.getUserActivity(EUserActivityPeriods.LAST_YEAR));
    }

    private UserActivity getUserActivity(EUserActivityPeriods activityPeriod) throws StorageException {
        UserLastActivityIndex lastActivityIndex = this.openGlobalIndex(UserLastActivityIndex.class);
        int numberOfCommitters = lastActivityIndex.getNumberOfCommitters(activityPeriod);
        return new UserActivity(activityPeriod.getName(), numberOfCommitters);
    }
}

