/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.table;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;

public record RootedList<N>(@Nullable N root, List<N> metaChildren, List<N> children) {
    public Stream<N> streamRootAndChildren() {
        return Streams.stream(this.asIterableWithRootAndChildren());
    }

    private Iterable<N> asIterableWithRootAndChildren() {
        return Iterables.concat(Collections.singletonList(this.root), this.metaChildren, this.children);
    }

    public <D, E extends Exception> RootedData<N, D> map(FunctionWithException<N, D, E> mapper) throws E {
        return new RootedData(this, mapper.apply(this.root), CollectionUtils.mapWithException(this.metaChildren, mapper), CollectionUtils.mapWithException(this.children, mapper));
    }

    public <D, E extends Exception> RootedData<N, D> bulkMap(FunctionWithException<Iterable<N>, Iterable<D>, E> mapper) throws E {
        Iterator mapped = ((Iterable)mapper.apply(this.asIterableWithRootAndChildren())).iterator();
        Object rootData = mapped.next();
        ArrayList metaChildrenData = new ArrayList();
        Iterator<N> metaIt = this.metaChildren.iterator();
        while (metaIt.hasNext()) {
            metaChildrenData.add(mapped.next());
            metaIt.next();
        }
        return new RootedData(this, rootData, metaChildrenData, Lists.newArrayList(mapped));
    }

    public record RootedData<N, D>(RootedList<N> tree, D rootData, List<D> metaChildData, List<D> childData) {
        public Stream<Map.Entry<N, D>> childEntries() {
            return Streams.zip(this.tree.children.stream(), this.childData.stream(), Map::entry);
        }

        public Stream<Map.Entry<N, D>> metaChildEntries() {
            return Streams.zip(this.tree.metaChildren.stream(), this.metaChildData.stream(), Map::entry);
        }

        public @Nullable Map.Entry<N, D> rootEntry() {
            if (this.tree.root() == null) {
                return null;
            }
            return Map.entry(this.tree.root(), this.rootData());
        }

        public Stream<Map.Entry<N, D>> rootAndChildEntries() {
            if (this.tree.root == null) {
                return Stream.empty();
            }
            return Streams.concat((Stream[])new Stream[]{Stream.of(this.rootEntry()), Streams.zip(this.tree.metaChildren.stream(), this.metaChildData.stream(), Map::entry), Streams.zip(this.tree.children.stream(), this.childData.stream(), Map::entry)});
        }
    }
}

