/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroupDifference;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileEditVersionComparison;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileHistoryVersionComparison;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicatorDifference;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.AnalysisProfileValidationResult;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.EAnalysisProfileVersion;
import com.teamscale.index.configuration.ProjectValidationUtils;
import com.teamscale.index.configuration.service.AnalysisProfileUsageInfoWithProjects;
import com.teamscale.service.base.ElementListServiceBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.project.analysis_profile.AnalysisProfileInfoService;
import com.teamscale.service.project.analysis_profile.AnalysisProfileMetadata;
import com.teamscale.service.rules.RulesService;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/analysis-profiles")
public class AnalysisProfileService
extends ElementListServiceBase<AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory> {
    @GET
    @Operation(summary="Get all analysis profile names", description="Retrieves the names of all analysis profiles visible to the current user.", tags={"Analysis profiles"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return names of analysis profiles visible to current user.")
    public List<String> getAnalysisProfileNames() throws StorageException {
        return this.listElementNames();
    }

    @GET
    @Path(value="{analysisProfileName}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    @Operation(summary="Get analysis profile", description="Retrieves the analysis profile identified by given name.", tags={"Analysis profiles"}, responses={@ApiResponse(responseCode="404", description="Analysis profile with given name does not exist.")})
    public AnalysisProfile getAnalysisProfile(@PathParam(value="analysisProfileName") String analysisProfile) throws StorageException {
        return ((AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory)this.getElementWithExistsCheck(analysisProfile)).getProfile(this.getGlobalStorageSystem());
    }

    @GET
    @Path(value="{analysisProfileName}/metadata")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    @Operation(summary="Get analysis profile metadata", description="Retrieves the analysis profile identified by given name and returns its description, languages and tools.", tags={"Analysis profiles"}, responses={@ApiResponse(responseCode="404", description="Analysis profile with given name does not exist.")})
    public AnalysisProfileMetadata getAnalysisProfileMetadata(@PathParam(value="analysisProfileName") String analysisProfileName) throws StorageException {
        AnalysisProfile analysisProfile = ((AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory)this.getElementWithExistsCheck(analysisProfileName)).getProfile(this.getGlobalStorageSystem());
        return new AnalysisProfileMetadata(analysisProfile.getName(), analysisProfile.getDescription(), (Set<ELanguage>)analysisProfile.getLanguages(), (Set<EAnalysisTool>)analysisProfile.getTools());
    }

    @GET
    @Path(value="{analysisProfileName}/export")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    @Operation(summary="Exports the analysis profile", description="Retrieves the analysis profile identified by given name.", tags={"Analysis profiles"})
    @ApiResponse(responseCode="404", description="Analysis profile with given name does not exist.")
    public Response exportAnalysisProfile(@PathParam(value="analysisProfileName") String analysisProfileName) throws StorageException {
        AnalysisProfile analysisProfile = ((AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory)this.getElementWithExistsCheck(analysisProfileName)).getProfile(this.getGlobalStorageSystem());
        return ResponseUtils.toFileDownload((Object)analysisProfile, (Enum)EAnalysisProfileVersion.CURRENT_VERSION, (String)(analysisProfileName.replace("+", "plus").replace("#", "sharp") + ".tsanalysisprofile"));
    }

    @DELETE
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.DELETE}, entityPathParameter="analysisProfileName")
    @Operation(summary="Delete analysis profile", description="Deletes the analysis profile identified by the given name from the system", tags={"Analysis profiles"}, responses={@ApiResponse(responseCode="404", description="Analysis profile identified by the given name does not exist."), @ApiResponse(responseCode="400", description="Can not delete analysis profile because existing project(s) still reference the profile (you might not be be able to see the project(s) due to lacking permissions).")})
    @Path(value="{analysisProfileName}")
    public void deleteAnalysisProfile(@Parameter(description="Name of the analysis profile to delete") @PathParam(value="analysisProfileName") String analysisProfileName) throws StorageException {
        AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory profileVersionHistory = (AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory)this.getElementWithExistsCheck(analysisProfileName);
        AnalysisProfile analysisProfile = profileVersionHistory.getProfile(this.getGlobalStorageSystem());
        this.checkAnalysisProfileUnused(analysisProfile.getName());
        this.deleteElementAndPermissions(profileVersionHistory);
        AnalysisProfileIndex analysisProfileVersionIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        if (analysisProfileVersionIndex.getProfile(analysisProfileName) != null) {
            analysisProfileVersionIndex.deleteAfterHistoryHasBeenDeleted(analysisProfileName);
        }
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    @Operation(summary="Create analysis profile", description="Creates a new analysis profile.", tags={"Analysis profiles"}, responses={@ApiResponse(responseCode="400", description="Provided analysis profile not consistent.")})
    public void createAnalysisProfile(@RequestBody(required=true) AnalysisProfile newProfile) throws StorageException {
        this.validateAnalysisProfiles(List.of(newProfile), true);
        AnalysisProfileVersionedIndex analysisProfileVersionIndex = this.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfileUtils.addNewAnalysisProfileVersion((AnalysisProfileVersionedIndex)analysisProfileVersionIndex, (AnalysisProfileIndex)analysisProfileIndex, (AnalysisProfile)newProfile, (String)this.getUser().toString(), (String)"Analysis Profile created", (GlobalStorageSystem)this.getGlobalStorageSystem());
        this.createPermissions(analysisProfileVersionIndex.getAnalysisProfileVersionHistory(newProfile.getName()));
    }

    private @Nullable AnalysisProfileValidationResult validateAnalysisProfiles(List<AnalysisProfile> analysisProfiles, boolean validateTools) throws StorageException {
        return ProjectValidationUtils.validateAnalysisProfiles(analysisProfiles, (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem(), (boolean)validateTools);
    }

    @POST
    @Path(value="languages")
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    @Operation(summary="Create analysis profile for languages", description="Creates a new analysis profile only based on the given languages, checks will fallback to default for each language.", tags={"Analysis profiles"})
    public void createAnalysisProfileForLanguages(@QueryParam(value="name") String name, @QueryParam(value="languages") Set<ELanguage> languages) throws StorageException {
        ConfigurationTemplate template = RulesService.createTemplate(EnumSet.copyOf(languages), EnumSet.of(EAnalysisTool.TEAMSCALE), this.getGlobalStorageSystem());
        AnalysisProfile newProfile = new AnalysisProfile(name, languages, EnumSet.of(EAnalysisTool.TEAMSCALE));
        AnalysisProfileUtils.createQualityIndicators((AnalysisProfile)newProfile, (ConfigurationTemplate)template);
        this.createAnalysisProfile(newProfile);
    }

    @POST
    @Path(value="import")
    @Consumes(value={"multipart/form-data"})
    @RequiresNoPermission(description="Requires Create Analysis Profiles or the permission to edit analysis profiles when a profile with the same name already exists.")
    @Operation(summary="Import analysis profile", description="Imports an analysis profile.", tags={"Analysis profiles"})
    @ApiResponse(responseCode="400", description="Provided analysis profile not consistent or could not be migrated.")
    public void importAnalysisProfile(@Parameter(required=true, array=@ArraySchema(schema=@Schema(type="string", format="binary"))) @FormDataParam(value="analysis-profile") List<FormDataBodyPart> profiles) throws StorageException, MigrationException {
        for (FormDataBodyPart data : profiles) {
            AnalysisProfile analysisProfile = AnalysisProfileUtils.deserializeAnalysisProfile((byte[])((byte[])data.getEntityAs(byte[].class)), (GlobalStorageSystem)this.getGlobalStorageSystem());
            String analysisProfileName = analysisProfile.getName();
            AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory existingAnalysisProfile = this.getElement(analysisProfileName);
            AnalysisProfileVersionedIndex analysisProfileVersionedIndex = this.openGlobalIndex(AnalysisProfileVersionedIndex.class);
            AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
            if (existingAnalysisProfile == null) {
                this.getPermissions().checkGlobalPermission(EGlobalPermission.CREATE_ANALYSIS_PROFILES);
            } else {
                this.checkEditPermission(analysisProfileName);
            }
            AnalysisProfileUtils.addNewAnalysisProfileVersion((AnalysisProfileVersionedIndex)analysisProfileVersionedIndex, (AnalysisProfileIndex)analysisProfileIndex, (AnalysisProfile)analysisProfile, (String)this.getUser().toString(), (String)"Analysis Profile imported", (GlobalStorageSystem)this.getGlobalStorageSystem());
            if (existingAnalysisProfile != null) continue;
            this.createPermissions(analysisProfileVersionedIndex.getAnalysisProfileVersionHistory(analysisProfileName));
        }
    }

    private boolean hasViewPermission(String analysisProfileName) {
        return this.getPermissions().hasBasicPermission(EBasicPermissionScope.ANALYSIS_PROFILES, analysisProfileName, EBasicPermission.VIEW);
    }

    private void checkEditPermission(String analysisProfileName) {
        this.getPermissions().checkBasicPermission(EBasicPermissionScope.ANALYSIS_PROFILES, analysisProfileName, EBasicPermission.EDIT);
    }

    @PUT
    @RequiresNoPermission(description="Requires the edit permission on the respective analysis profile.")
    @Operation(summary="Update analysis profile", description="Updates the analysis profile identified by the given name with the value in the request body.", tags={"Analysis profiles"})
    public void updateAnalysisProfile(@Parameter(description="A comment similar to git commit messages associated with the changes made in the analysis profile") @QueryParam(value="analysisProfileEditComment") String analysisProfileEditComment, @RequestBody(required=true) AnalysisProfile newProfile) throws StorageException {
        this.validateAnalysisProfiles(List.of(newProfile), true);
        String analysisProfileName = newProfile.getName();
        this.checkEditPermission(analysisProfileName);
        GlobalStorageSystem globalStorageSystem = this.serviceInfo.getIndexLayer().openGlobalStorageSystem();
        AnalysisProfileVersionedIndex analysisProfileVersionedIndex = (AnalysisProfileVersionedIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileIndex analysisProfileIndex = (AnalysisProfileIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileIndex.class);
        this.createNewCheckUpdateLogEntry(newProfile, analysisProfileName, analysisProfileVersionedIndex, analysisProfileIndex);
        AnalysisProfileUtils.addNewAnalysisProfileVersion((AnalysisProfileVersionedIndex)analysisProfileVersionedIndex, (AnalysisProfileIndex)analysisProfileIndex, (AnalysisProfile)newProfile, (String)this.getUser().toString(), (String)analysisProfileEditComment, (GlobalStorageSystem)globalStorageSystem);
    }

    @POST
    @Path(value="validate")
    @RequiresNoPermission(description="Requires the edit permission on the respective analysis profile.")
    @ApiResponse(responseCode="204", description="Analysis profile successfully validated without errors or warnings.")
    @Operation(summary="Validate analysis profile", description="Validates the analysis profile provided in the request body.", tags={"Analysis profiles"})
    public @Nullable AnalysisProfileValidationResult validateAnalysisProfile(@RequestBody(required=true) AnalysisProfile analysisProfile) throws StorageException {
        this.checkEditPermission(analysisProfile.getName());
        try {
            AnalysisProfileValidationResult analysisProfileValidationResult;
            this.validateAnalysisProfiles(List.of(analysisProfile), true);
            List<AnalysisProfile> profilesToValidate = Stream.concat(Stream.of(analysisProfile), this.getProfilesFromCommonCodeScopes(analysisProfile).stream()).toList();
            if (profilesToValidate.size() > 1 && (analysisProfileValidationResult = this.validateAnalysisProfiles(profilesToValidate, false)) != null) {
                return analysisProfileValidationResult;
            }
        }
        catch (StorageException e) {
            return AnalysisProfileValidationResult.from((Exception)((Object)e));
        }
        return null;
    }

    private @NonNull Collection<AnalysisProfile> getProfilesFromCommonCodeScopes(AnalysisProfile newProfile) throws StorageException {
        AnalysisProfileUsageInfoWithProjects usageInfoForProfile = this.getUsageInfoForProfile(newProfile.getName());
        if (usageInfoForProfile == null) {
            return new ArrayList<AnalysisProfile>();
        }
        ArrayList referencedProjects = new ArrayList(usageInfoForProfile.getCodeScopesByReferencedProjectIds().getKeys());
        List projectConfigurations = ProjectConfigurationUtils.getProjectConfigurations(referencedProjects, (IndexLayer)this.getIndexLayer());
        HashMap relatedProfilesFromCodeScopes = new HashMap();
        for (ProjectConfiguration projectConfiguration : projectConfigurations) {
            List<String> relatedAnalysisProfileNames = projectConfiguration.getAnalysisProfileNames().stream().filter(name -> !name.equals(newProfile.getName())).toList();
            List relatedAnalysisProfiles = ((AnalysisProfileIndex)this.getIndexLayer().openGlobalIndex(AnalysisProfileIndex.class)).getProfiles(relatedAnalysisProfileNames, true);
            relatedAnalysisProfiles.forEach(profile -> relatedProfilesFromCodeScopes.put(profile.getName(), profile));
        }
        return relatedProfilesFromCodeScopes.values();
    }

    private void createNewCheckUpdateLogEntry(AnalysisProfile newProfile, String analysisProfileName, AnalysisProfileVersionedIndex analysisProfileVersionedIndex, AnalysisProfileIndex analysisProfileIndex) throws StorageException {
        AnalysisProfile currentProfile = analysisProfileIndex.getProfile(analysisProfileName);
        if (currentProfile == null) {
            return;
        }
        AnalysisProfileHistoryVersionComparison difference = AnalysisProfileEditVersionComparison.getAnalysisProfileComparison((AnalysisProfile)currentProfile, (AnalysisProfile)newProfile);
        for (QualityIndicatorDifference indicatorDifference : difference.profileDifference().qualityIndicatorDifference()) {
            for (AnalysisGroupDifference analysisGroupDifference : indicatorDifference.analysisGroupDifferences()) {
                String qualityIndicatorName = indicatorDifference.name();
                if (indicatorDifference.oldName() != null) {
                    qualityIndicatorName = indicatorDifference.oldName();
                }
                AnalysisGroup currentGroup = AnalysisProfileUtils.getAnalysisGroupByName((AnalysisProfile)currentProfile, (String)qualityIndicatorName, (String)analysisGroupDifference.name());
                for (String[] addedCheck : analysisGroupDifference.addedChecks()) {
                    currentGroup.setOptionValue(addedCheck[0], addedCheck[1]);
                }
            }
        }
        AnalysisProfileUtils.addNewAnalysisProfileVersion((AnalysisProfileVersionedIndex)analysisProfileVersionedIndex, (AnalysisProfileIndex)analysisProfileIndex, (AnalysisProfile)currentProfile, (String)"[System]", (String)"Profile updated by System (Newly available checks added)", (GlobalStorageSystem)this.getGlobalStorageSystem());
    }

    private List<String> listElementNames() throws StorageException {
        return this.openGlobalIndex(AnalysisProfileIndex.class).getAllProfiles().stream().map(NamedConfigurableObjectBase::getName).filter(this::hasViewPermission).toList();
    }

    private static String getElementKey(AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory element) {
        return element.analysisProfileName();
    }

    private void checkAnalysisProfileUnused(String analysisProfileName) throws StorageException {
        AnalysisProfileUsageInfoWithProjects usageInfo = this.getUsageInfoForProfile(analysisProfileName);
        if (usageInfo == null) {
            return;
        }
        if (!usageInfo.getCodeScopesByReferencedProjectIds().isEmpty()) {
            throw new BadRequestException("Can not delete profile because the following projects still reference the profile: " + StringUtils.concat((Iterable)usageInfo.getCodeScopesByReferencedProjectIds().getKeys(), (String)","));
        }
        if (usageInfo.areProjectsMissingBecauseOfPermissions()) {
            throw new BadRequestException("Can not delete profile because there are projects referencing the profile, which you are not able to see because of your permissions. Please contact your administrator to resolve this situation.");
        }
    }

    @Override
    protected void createPermissions(AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory newElement) throws StorageException {
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.ANALYSIS_PROFILES, newElement.analysisProfileName());
    }

    @Override
    protected void deleteElement(AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory elementToDelete) throws StorageException {
        this.getIndex().removeAnalysisProfileVersionHistory(AnalysisProfileService.getElementKey(elementToDelete));
    }

    @Override
    protected void deletePermissions(AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory deletedElement) throws StorageException {
        this.getPermissions().createPermissionModifier().removeBasicRoleInstanceAssignments(EBasicPermissionScope.ANALYSIS_PROFILES, deletedElement.analysisProfileName());
    }

    @Override
    protected AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory getElement(String elementName) throws StorageException {
        return this.getIndex().getAnalysisProfileVersionHistory(elementName);
    }

    @Override
    protected void updateElement(AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory oldElement, AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory newElement) throws StorageException {
        this.getIndex().setAnalysisProfileVersionHistory(AnalysisProfileService.getElementKey(newElement), newElement);
    }

    @Override
    protected void createElement(AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory newElement) throws StorageException {
        this.getIndex().setAnalysisProfileVersionHistory(AnalysisProfileService.getElementKey(newElement), newElement);
    }

    private AnalysisProfileVersionedIndex getIndex() throws StorageException {
        return this.openGlobalIndex(AnalysisProfileVersionedIndex.class);
    }

    private @Nullable AnalysisProfileUsageInfoWithProjects getUsageInfoForProfile(String analysisProfileName) throws StorageException {
        Map<String, AnalysisProfileUsageInfoWithProjects> projectsByProfile = AnalysisProfileInfoService.getProjectsByProfile(this.openGlobalIndex(ProjectIndex.class), this.getPermissions(), true, this.serviceInfo.getIndexLayer());
        return projectsByProfile.get(analysisProfileName);
    }
}

