/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.user.User;
import com.teamscale.index.baseline.BaselineIndex;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.MetricTrendChartSlide;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.metrics.history.MetricHistoryService;
import com.teamscale.service.metrics.history.MetricTrendEntry;
import com.teamscale.service.reports.ReportSlideWithRenderData;
import com.teamscale.service.reports.slides.ReportUtils;
import com.teamscale.service.reports.slides.SlideRenderContext;
import com.teamscale.service.reports.slides.SlideRendererBase;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.baseline.BaselineInfo;
import org.conqat.engine.index.baseline.FrequencyData;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class TrendChartSlideRendererBase<Parameters extends SlideParametersBase>
extends SlideRendererBase<Parameters> {
    protected TrendChartSlideRendererBase(SlideRenderContext<Parameters> slideRenderContext) {
        super(slideRenderContext);
    }

    public MetricTrendChartSlide.TrendChartSlideResult createSlideResult(@Nullable ReportSlideWithRenderData existingSlide) throws StorageException {
        IStorageInfo projectAwareStorageInfo = this.renderContext.resolveProjectAndReturnLocalStorageInfo(this.getProjectBranchPath());
        UniformPath uniformPath = this.getProjectBranchPath().getPath();
        MetricDirectorySchema metricSchema = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)projectAwareStorageInfo.getProjectStorageSystem(), (GlobalStorageSystem)projectAwareStorageInfo.getGlobalStorageSystem(), (User)this.renderContext.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory(projectAwareStorageInfo.getProjectStorageSystem())).getMetricDirectorySchema();
        List<Integer> relevantMetricIndices = TrendChartSlideRendererBase.loadAndAssertRelevantMetricIndices(metricSchema, this.getMetricNames());
        String branch = ReportUtils.determineBranch(projectAwareStorageInfo, this.getProjectBranchPath());
        CommitDescriptor startCommit = TrendChartSlideRendererBase.getCommitForTimestamp(branch, this.getReportProfile().getBaselineWithType().getTimestamp());
        CommitDescriptor endCommit = TrendChartSlideRendererBase.getCommitForTimestamp(branch, this.getReportProfile().getEndWithType().getTimestamp());
        List<MetricTrendEntry> history = MetricHistoryService.calculateMetricHistoryResult(uniformPath, startCommit, endCommit, projectAwareStorageInfo.getProjectStorageSystem(), projectAwareStorageInfo.getGlobalStorageSystem(), this.renderContext.getUser(), null);
        BaselineIndex baselineIndex = (BaselineIndex)projectAwareStorageInfo.getProjectStorageSystem().openProjectIndex(BaselineIndex.class, null);
        List<BaselineInfo> baselines = TrendChartSlideRendererBase.getAllBaselinesInTimeframe(startCommit.getTimestamp(), endCommit.getTimestamp(), baselineIndex.getAllBaselines());
        return this.collectResult(history, relevantMetricIndices, metricSchema, baselines);
    }

    private static List<BaselineInfo> getAllBaselinesInTimeframe(long startTimestamp, long endTimestamp, List<BaselineInfo> baselines) {
        return baselines.stream().filter(baselineInfo -> baselineInfo.getTimestamp() >= startTimestamp && baselineInfo.getTimestamp() <= endTimestamp).toList();
    }

    private MetricTrendChartSlide.TrendChartSlideResult collectResult(List<MetricTrendEntry> history, List<Integer> relevantMetricIndices, MetricDirectorySchema metricSchema, List<BaselineInfo> baselines) throws StorageException {
        ArrayList<MetricTrendChartSlide.SingleTrendResult> results = new ArrayList<MetricTrendChartSlide.SingleTrendResult>();
        for (Integer index : relevantMetricIndices) {
            ArrayList<Long> timestampList = new ArrayList<Long>();
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (MetricTrendEntry entry : history) {
                timestampList.add(entry.getTimestamp());
                valueList.add(entry.getValue()[index]);
            }
            String metricName = metricSchema.getEntry(index.intValue()).getName();
            ArrayList<FrequencyData> percentages = new ArrayList<FrequencyData>(valueList.size());
            if (metricSchema.getEntry(index.intValue()).getValueType() == EMetricValueType.ASSESSMENT) {
                for (Object e : valueList) {
                    Assessment value = (Assessment)e;
                    FrequencyData colorFrequencies = new FrequencyData(value.getRelativeColorFrequency(ETrafficLightColor.GREEN), value.getRelativeColorFrequency(ETrafficLightColor.YELLOW), value.getRelativeColorFrequency(ETrafficLightColor.RED));
                    percentages.add(colorFrequencies);
                }
            }
            results.add(new MetricTrendChartSlide.SingleTrendResult(metricName, timestampList, valueList, this.getMetricColor(metricName), percentages, baselines));
        }
        return new MetricTrendChartSlide.TrendChartSlideResult(results, this.getSlideCommentRenderData(this.getProjectBranchPath(), this.getComments()));
    }

    private static List<Integer> loadAndAssertRelevantMetricIndices(MetricDirectorySchema schema, List<String> metricNames) {
        ArrayList<Integer> metricIndices = new ArrayList<Integer>();
        for (String metricName : metricNames) {
            int index = schema.getValuePosition(metricName);
            if (index < 0) continue;
            metricIndices.add(index);
        }
        CCSMAssert.isTrue((metricNames.size() == metricIndices.size() ? 1 : 0) != 0, (String)ReportUtils.getMetricSchemaAssertionErrorMessage(schema, metricNames));
        return metricIndices;
    }

    private static CommitDescriptor getCommitForTimestamp(String branchName, long timestamp) {
        return new CommitDescriptor(branchName, timestamp);
    }

    protected abstract List<ISlideComment> getComments();

    protected abstract ProjectBranchPath getProjectBranchPath();

    protected abstract List<String> getMetricNames();

    protected abstract String getMetricColor(String var1);
}

