/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.sap.abapsystem.AbapProjectUtils;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.resource.AdtUrlAnnotator;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.net.URI;
import java.util.EnumSet;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/external-link/{uniformPath}")
public class TokenElementAbapExternalLinkService
extends ApiBase {
    private static final EnumSet<ELanguage> SUPPORTED_LANGUAGES = EnumSet.of(ELanguage.ABAP, ELanguage.ABAP_DDIC, ELanguage.ABAP_CDS);

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get ABAP external link", description="Allows obtaining an external link for a file, e.g. for opening it in an IDE. This only works for ABAP files imported from an SAP system.", tags={"Source Code", "SAP"}, responses={@ApiResponse(responseCode="404", description="The given uniform path does not exist"), @ApiResponse(responseCode="204", description="The file has no content or the SAP system ID is not set.")})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public @Nullable String getExternalLink(@PathParam(value="project") PublicProjectId projectId, @PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws ConQATException {
        ELanguage language = ELanguage.fromPath((String)uniformPath.toString());
        if (!SUPPORTED_LANGUAGES.contains(language)) {
            return null;
        }
        return this.getLinkForAbap(projectId, uniformPath, this.determineHistoryOption(commit)).map(URI::toString).orElse(null);
    }

    private Optional<URI> getLinkForAbap(PublicProjectId projectId, UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws ConQATException {
        IndexLayer indexLayer = this.getIndexLayer();
        String systemId = AbapProjectUtils.getSapSystemIdFromConnector((ProjectInfo)indexLayer.resolveProject((IProjectId)projectId), (IndexLayer)indexLayer).orElse(null);
        if (systemId == null) {
            return Optional.empty();
        }
        TokenElementInfo tokenElementInfo = this.getTokenElementInfo(uniformPath, historyAccessOption);
        if (tokenElementInfo == null) {
            throw new NotFoundException("No content found for " + String.valueOf(uniformPath));
        }
        String content = tokenElementInfo.getText();
        if (StringUtils.isEmpty((String)content)) {
            return Optional.empty();
        }
        return Optional.of(AdtUrlAnnotator.getAdtResourceUrl(tokenElementInfo, systemId));
    }

    private @Nullable TokenElementInfo getTokenElementInfo(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        TokenElementIndex contentIndex = ResourceServiceUtils.openContentIndex((UniformPath)uniformPath, (HistoryAccessOption)historyAccessOption, (ProjectStorageSystem)this.getProjectStorageSystem());
        return contentIndex.getTokenElementByPath(uniformPath);
    }
}

