/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.trigger.debug;

import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompiler;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.graph.EGraphvizOutputFormat;
import org.conqat.lib.commons.graph.GraphvizException;
import org.conqat.lib.commons.graph.GraphvizGenerator;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/triggers/debug/graph")
public class TriggerGraphService
extends ApiBase {
    @GET
    @Path(value="dot")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get trigger graph as dot", description="Returns a plain text GraphViz DOT description of the trigger graph", tags={"Debugging"})
    public String getTriggerGraphDot(@Parameter(description="Whether read/written indexes are included as nodes in the graph.") @QueryParam(value="include-indexes") boolean includeIndexes) throws TriggerCompilationException, StorageException {
        return this.createTriggerGraph(includeIndexes);
    }

    @GET
    @Path(value="image")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get trigger graph as image", description="Returns a rendered image of the trigger graph. GraphViz must be installed on the server.", tags={"Debugging"})
    public Response getTriggerGraphImage(@Parameter(description="Whether read/written indexes are included as nodes in the graph.") @QueryParam(value="include-indexes") boolean indexes) throws TriggerCompilationException, StorageException {
        String triggerGraph = this.createTriggerGraph(indexes);
        try {
            BufferedImage image = new GraphvizGenerator().generateImage(triggerGraph);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, EGraphvizOutputFormat.PNG.getFileExtension(), output);
            output.close();
            byte[] entity = output.toByteArray();
            return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.IMAGE_PNG_TYPE, (String)"graph.png");
        }
        catch (IOException | GraphvizException e) {
            throw new InternalServerErrorException("Could not create image. Most likely, GraphViz is not installed on the server. You can also get the plain DOT graph by omitting the image parameter. Error message: " + e.getMessage(), e);
        }
    }

    private String createTriggerGraph(boolean includeIndexes) throws StorageException, TriggerCompilationException {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph {" + StringUtils.LINE_SEPARATOR);
        PairList rawTriggers = this.openProjectIndex(TriggerIndex.class, null).getAllTriggers();
        List triggers = new TriggerCompiler(this.getProjectStorageSystem().getSchema(), this.getGlobalStorageSystem().getSchema()).compile(rawTriggers);
        builder.append("subgraph cluster_triggers { label=\"Triggers\";" + StringUtils.LINE_SEPARATOR);
        TriggerGraphService.addTriggerNodes(triggers, builder);
        builder.append("}" + StringUtils.LINE_SEPARATOR);
        TriggerGraphService.addTriggerDeltaEdges(triggers, builder);
        if (includeIndexes) {
            this.addTriggerGraphIndexes(builder);
            TriggerGraphService.addTriggerToIndexEdges(triggers, builder);
        }
        builder.append("}" + StringUtils.LINE_SEPARATOR);
        return builder.toString();
    }

    private void addTriggerGraphIndexes(StringBuilder builder) {
        IndexSchema schema = this.getProjectStorageSystem().getSchema();
        for (String indexName : schema.getEntryNames()) {
            SchemaEntry schemaEntry = schema.getEntry(indexName);
            String indexClass = StringUtils.getLastPart((String)schemaEntry.getIndexClass(), (char)'.');
            builder.append("  \"" + indexName + "\"[shape=box, label=\"" + indexName + "\\n" + indexClass + "\"];" + StringUtils.LINE_SEPARATOR);
        }
    }

    public static void addTriggerNodes(List<AnalysisTrigger> triggers, StringBuilder builder) {
        if (triggers.isEmpty()) {
            return;
        }
        triggers.sort(Comparator.comparing(AnalysisTrigger::getExecutionOrderIndex).thenComparing(AnalysisTrigger::getName));
        int currentExecutionOrder = triggers.get(0).getExecutionOrderIndex();
        builder.append("subgraph cluster_ex" + currentExecutionOrder + " { label=\"Execution Order (Priority) " + currentExecutionOrder + "\";" + StringUtils.LINE_SEPARATOR);
        for (AnalysisTrigger trigger : triggers) {
            if (trigger.getExecutionOrderIndex() > currentExecutionOrder) {
                currentExecutionOrder = trigger.getExecutionOrderIndex();
                builder.append("  }" + StringUtils.LINE_SEPARATOR + "  subgraph cluster_ex" + currentExecutionOrder + " { label=\"Execution Order (Priority) " + currentExecutionOrder + "\";" + StringUtils.LINE_SEPARATOR);
            }
            builder.append("  \"" + trigger.getName() + "\"[shape=ellipse,label=\"" + trigger.getName());
            builder.append("\\nConcurrency: " + trigger.getConcurrency().name().toLowerCase());
            if (trigger.isPeriodic()) {
                builder.append("\\nperiod: " + trigger.getPeriodSeconds(Integer.MAX_VALUE));
            }
            String color = ColorUtils.toHtmlString((Color)TriggerGraphService.determineColor(trigger.getConcurrency()));
            builder.append("\",fillcolor=\"" + color + "\",style=filled];" + StringUtils.LINE_SEPARATOR);
        }
        builder.append("  }" + StringUtils.LINE_SEPARATOR);
    }

    static Color determineColor(ETriggerConcurrency concurrency) {
        switch (concurrency) {
            case ISOLATED: {
                return Color.ORANGE;
            }
            case OUTPUT_ISOLATED: {
                return Color.YELLOW;
            }
            case PARALLEL: {
                return Color.GREEN;
            }
        }
        throw new AssertionError((Object)("Unknown concurrency value: " + String.valueOf(concurrency)));
    }

    static void addTriggerToIndexEdges(List<AnalysisTrigger> triggers, StringBuilder builder) {
        for (AnalysisTrigger trigger : triggers) {
            for (String store : CollectionUtils.sort((Collection)trigger.getReadOnlyStores())) {
                builder.append("\"" + store + "\"->\"" + trigger.getName() + "\"[color=black];" + StringUtils.LINE_SEPARATOR);
            }
            for (String store : CollectionUtils.sort((Collection)trigger.getReadBranchingLayerStores())) {
                builder.append("\"" + store + "\"->\"" + trigger.getName() + "\"[color=grey25];" + StringUtils.LINE_SEPARATOR);
            }
            for (String store : CollectionUtils.sort((Collection)trigger.getWriteStores())) {
                builder.append("\"" + trigger.getName() + "\"->\"" + store + "\"[color=red];" + StringUtils.LINE_SEPARATOR);
            }
        }
    }

    private static void addTriggerDeltaEdges(List<AnalysisTrigger> triggers, StringBuilder builder) {
        ListMap writers = new ListMap();
        for (AnalysisTrigger trigger : triggers) {
            for (String store : trigger.getWriteStores()) {
                writers.add((Object)store, (Object)trigger.getName());
            }
        }
        for (AnalysisTrigger trigger : triggers) {
            for (String store : trigger.getExpectedDeltaStoreNames()) {
                List writingTriggers = (List)writers.getCollection((Object)store);
                if (CollectionUtils.isNullOrEmpty((Collection)writingTriggers)) continue;
                for (String writingTrigger : CollectionUtils.sort((Collection)writingTriggers)) {
                    builder.append("\"" + writingTrigger + "\"->\"" + trigger.getName() + "\"[color=blue, label=\"" + store + "\"];" + StringUtils.LINE_SEPARATOR);
                }
            }
        }
    }
}

