/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.google.common.collect.ImmutableSet;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.user.User;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.ImpactedTestsIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.testimpact.TestLinksIndex;
import com.teamscale.index.testimpact.TiaTestFilterQueryParams;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.index.tests.TestHistoryIndex;
import com.teamscale.index.tests.TestImplementationPathToExecutionPathIndex;
import com.teamscale.service.testimpact.ImpactedTestUtils;
import com.teamscale.service.testimpact.TestPrioritizationData;
import com.teamscale.service.testimpact.TiaDataRetrieverOptions;
import com.teamscale.service.testimpact.prioritization.ETestSelectionReason;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.QueryEngine;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.TestWithClusterId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class PrioritizableTestsRetriever {
    private static final String NEW_TESTS_PARTITION = "new_tests_partition";
    private final TiaDataRetrieverOptions requestOptions;
    private final TestImplementationIndex testImplementationIndex;
    private final TestExecutionIndex testExecutionIndex;
    private final TestLinksIndex testLinksIndex;
    private final StoredQueryIndex testQueryIndex;
    private final TestImplementationPathToExecutionPathIndex testImplementationPathToExecutionPathIndex;
    private final CoverageUnitToMethodsMapIndex testsToMethodsMapIndex;
    private final ImpactedTestsIndex impactedTestsIndex;
    private final Map<String, TestWithClusterId> testsAvailableForExecution;
    private final TestHistoryIndex testHistoryIndex;
    private final CommitResolvingStorageSystem projectStorageSystem;
    private final GlobalStorageSystem globalStorageSystem;
    private final User user;

    public PrioritizableTestsRetriever(TiaDataRetrieverOptions requestOptions, GlobalStorageSystem globalStorageSystem, CommitResolvingStorageSystem projectStorageSystem, User user) throws StorageException {
        this(requestOptions, null, globalStorageSystem, projectStorageSystem, user);
    }

    public PrioritizableTestsRetriever(TiaDataRetrieverOptions requestOptions, List<TestWithClusterId> availableTests, GlobalStorageSystem globalStorageSystem, CommitResolvingStorageSystem projectStorageSystem, User user) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)requestOptions.getEndCommit());
        this.requestOptions = requestOptions;
        this.projectStorageSystem = projectStorageSystem;
        this.globalStorageSystem = globalStorageSystem;
        this.user = user;
        this.testImplementationIndex = (TestImplementationIndex)projectStorageSystem.openProjectIndex(TestImplementationIndex.class, historyAccessOption);
        this.testExecutionIndex = (TestExecutionIndex)projectStorageSystem.openProjectIndex(TestExecutionIndex.class, historyAccessOption);
        this.testLinksIndex = (TestLinksIndex)projectStorageSystem.openProjectIndex(TestLinksIndex.class, historyAccessOption);
        this.testImplementationPathToExecutionPathIndex = (TestImplementationPathToExecutionPathIndex)projectStorageSystem.openProjectIndex(TestImplementationPathToExecutionPathIndex.class, historyAccessOption);
        this.testsToMethodsMapIndex = (CoverageUnitToMethodsMapIndex)projectStorageSystem.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        this.impactedTestsIndex = (ImpactedTestsIndex)projectStorageSystem.openProjectIndex(ImpactedTestsIndex.class, historyAccessOption);
        this.testsAvailableForExecution = PrioritizableTestsRetriever.getTestsAvailableForExecution(availableTests);
        this.testHistoryIndex = (TestHistoryIndex)projectStorageSystem.openProjectIndex(TestHistoryIndex.class, historyAccessOption);
        this.testQueryIndex = StoredQueryIndex.openIndex((ProjectStorageSystem)projectStorageSystem, (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.TEST);
    }

    private static Map<String, TestWithClusterId> getTestsAvailableForExecution(List<TestWithClusterId> testWithClusterIds) {
        if (testWithClusterIds == null) {
            return null;
        }
        return testWithClusterIds.stream().collect(Collectors.toMap(TestWithClusterId::getUniformPath, test -> test));
    }

    private Collection<PrioritizableTest> getAddedOrModifiedTests() throws StorageException {
        if (this.testsAvailableForExecution != null) {
            return this.getAddedAndModifiedTestsFromList(this.testsAvailableForExecution);
        }
        return this.getAddedOrModifiedTestsFromTestImplementationIndex();
    }

    private Set<PrioritizableTest> getAddedOrModifiedTestsFromTestImplementationIndex() throws StorageException {
        Map allTestImplementations = this.testImplementationIndex.getAllTestImplementations();
        List<String> changedTestImplementations = this.getChangedTestImplementationsSinceBaseline(allTestImplementations);
        PairList<PartitionAndPath, Long> testExecutionAndLastChangeTimestamp = this.getTestPartitionAndPathsForImplementations(allTestImplementations, changedTestImplementations);
        return this.determineTestsWithoutExecutionSinceLastChange(testExecutionAndLastChangeTimestamp);
    }

    private Set<PrioritizableTest> determineTestsWithoutExecutionSinceLastChange(PairList<PartitionAndPath, Long> testExecutionAndLastChangeTimestamp) throws StorageException {
        HashSet<PrioritizableTest> result = new HashSet<PrioritizableTest>();
        List relevantTestExecutions = this.testExecutionIndex.getTestExecutionsForPartitionAndPaths((List)testExecutionAndLastChangeTimestamp.getFirstList());
        CollectionUtils.forEach((Iterable)relevantTestExecutions, (Iterable)testExecutionAndLastChangeTimestamp.getSecondList(), (testExecution, lastChanged) -> PrioritizableTestsRetriever.getPrioritizableTest(testExecution, lastChanged).ifPresent(result::add));
        return result;
    }

    private static Optional<PrioritizableTest> getPrioritizableTest(TestExecutionWithPartition testExecution, Long testImplementationLastChanged) {
        if (testExecution == null || testImplementationLastChanged <= testExecution.getCommit().getTimestamp()) {
            return Optional.empty();
        }
        if (testExecution.getTestExecution().getExecutionUnit() != null) {
            return Optional.of(PrioritizableTest.createForAddedOrModifiedTest((String)testExecution.getPartition(), (UniformPath)UniformPathCompatibilityUtil.convert((String)testExecution.getTestExecution().getExecutionUnit())));
        }
        return Optional.of(PrioritizableTest.createForAddedOrModifiedTest((String)testExecution.getPartition(), (UniformPath)testExecution.getTestExecution().toUniformPath()));
    }

    private @NonNull PairList<PartitionAndPath, Long> getTestPartitionAndPathsForImplementations(Map<UniformPath, TestImplementation> allTestImplementations, List<String> allChangedTests) throws StorageException {
        ArrayList executionPathsForImplementationPaths = new ArrayList(this.testImplementationPathToExecutionPathIndex.getExecutionPathsForImplementationPathsFlat(allChangedTests));
        List testLinks = this.testLinksIndex.getTestLinks(executionPathsForImplementationPaths);
        PairList testExecutionAndLastChangeTimestamp = new PairList();
        CollectionUtils.forEach(executionPathsForImplementationPaths, (Iterable)testLinks, (executionPath, testLink) -> {
            UniformPath implementationPath = UniformPathCompatibilityUtil.convert((String)testLink.getTestImplementation());
            TestImplementation testImplementation = (TestImplementation)allTestImplementations.get(implementationPath);
            for (String partition : testLink.getPartitions()) {
                if (!this.requestOptions.getPartitions().contains(partition)) continue;
                testExecutionAndLastChangeTimestamp.add((Object)new PartitionAndPath(partition, executionPath), (Object)testImplementation.getLastImplementationHashChangedTimestamp());
            }
        });
        return testExecutionAndLastChangeTimestamp;
    }

    private @NonNull List<String> getChangedTestImplementationsSinceBaseline(Map<UniformPath, TestImplementation> allTestImplementations) {
        ArrayList<String> allChangedTests = new ArrayList<String>();
        allTestImplementations.forEach((test, details) -> {
            if (details.getLastImplementationHashChangedTimestamp() > this.requestOptions.getResolvedBaselineTimestamp()) {
                allChangedTests.add(test.toString());
            }
        });
        return allChangedTests;
    }

    private Set<PrioritizableTest> getAddedAndModifiedTestsFromList(Map<String, TestWithClusterId> testPathsAvailableForExecution) throws StorageException {
        List testsAvailableForExecution = CollectionUtils.map(testPathsAvailableForExecution.values(), c -> new PartitionAndPath(c.getPartition(), c.getUniformPath()));
        List alreadyKnownTestExecutions = this.testExecutionIndex.getTestExecutionsForPartitionAndPaths(testsAvailableForExecution);
        HashSet<PrioritizableTest> result = new HashSet<PrioritizableTest>();
        CollectionUtils.forEach((Iterable)testsAvailableForExecution, (Iterable)alreadyKnownTestExecutions, (testUniformPathForExecution, existingTestExecution) -> {
            TestWithClusterId testFromRequest = (TestWithClusterId)testPathsAvailableForExecution.get(testUniformPathForExecution.getUniformPath());
            if (this.isAddedOrChanged((TestExecutionWithPartition)existingTestExecution, testFromRequest)) {
                result.add(PrioritizableTest.createForAddedOrModifiedTest((String)NEW_TESTS_PARTITION, (UniformPath)testFromRequest.toUniformPath()));
            }
        });
        return result;
    }

    private boolean isAddedOrChanged(TestExecutionWithPartition existingTestExecution, TestWithClusterId testWithClusterId) {
        boolean isAdded = existingTestExecution == null;
        return isAdded && this.requestOptions.tiaRequestOptions().getTestFilterOptions().isIncludeAddedTests() || !isAdded && PrioritizableTestsRetriever.isChangedTest(existingTestExecution, testWithClusterId);
    }

    private static boolean isChangedTest(TestExecutionWithPartition existingTest, TestWithClusterId testFromRequest) {
        return !Objects.equals(testFromRequest.getHash(), existingTest.getTestExecution().getHash());
    }

    private Collection<PrioritizableTest> getNonImpactedTests(Set<PrioritizableTest> impactedTests) throws StorageException {
        Set<PrioritizableTest> nonImpactedTests = PrioritizableTestsRetriever.retrieveTestForPrioritization(this.getAllCoveringTests(), ETestSelectionReason.COVERS_OTHER);
        nonImpactedTests.removeAll(impactedTests);
        return nonImpactedTests;
    }

    private List<PartitionAndPath> getAllCoveringTests() throws StorageException {
        List allTests = this.testsToMethodsMapIndex.getAllTests(this.requestOptions.getPartitions());
        if (this.testsAvailableForExecution != null) {
            allTests.removeIf(test -> !this.testsAvailableForExecution.containsKey(test.getUniformPath()));
        }
        return allTests;
    }

    private List<PartitionAndPath> getCoveringTestsByQuery(String query, Set<String> partitions) throws StorageException, QueryParsingException, QueryCompilationException {
        if (StringUtils.isEmpty((String)query)) {
            return this.getAllCoveringTests();
        }
        long timestamp = Math.min(System.currentTimeMillis(), this.requestOptions.getEndCommit().getTimestamp());
        QueryableEntityUtils.QueryContext queryContext = new QueryableEntityUtils.QueryContext((ProjectStorageSystem)this.projectStorageSystem, this.globalStorageSystem, this.user, this.testQueryIndex, timestamp, timestamp, this.requestOptions.getEndCommit().getBranchName(), false);
        ImmutableSet matchingTestPaths = ImmutableSet.copyOf((Collection)QueryEngine.selectIds((IKeyedObjectIndex)this.testHistoryIndex, (String)query, (QueryEngine.IQueryContext)queryContext));
        return this.testsToMethodsMapIndex.resolveTestsWithCoverage((Set)matchingTestPaths, partitions);
    }

    private static Set<PrioritizableTest> retrieveTestForPrioritization(List<PartitionAndPath> testUniformPaths, ETestSelectionReason testSelectionReason) {
        return CollectionUtils.mapToSet(testUniformPaths, test -> PrioritizableTestsRetriever.retrieveTestForPrioritization(test, testSelectionReason));
    }

    private static PrioritizableTest retrieveTestForPrioritization(PartitionAndPath test, ETestSelectionReason testSelectionReason) {
        return new PrioritizableTest(test.toUniformPath(), testSelectionReason, test.getPartition());
    }

    private static PrioritizableTest retrieveTestForPrioritization(PartitionAndPath test, Set<MethodId> changedMethodLocations) {
        ETestSelectionReason selectionReason = changedMethodLocations.isEmpty() ? ETestSelectionReason.COVERS_DELETED : ETestSelectionReason.COVERS_CHANGES;
        return new PrioritizableTest(test.toUniformPath(), selectionReason, test.getPartition(), changedMethodLocations);
    }

    private Set<PrioritizableTest> getImpactedTestsAndCollectMethodsToTest(Set<MethodId> methodsToTest) throws StorageException {
        HashSet<PrioritizableTest> impactedTests = new HashSet<PrioritizableTest>();
        Map allImpactedTests = this.impactedTestsIndex.getAllImpactedTestsOnPartitions(new ArrayList<String>(this.requestOptions.getPartitions()));
        allImpactedTests.forEach((test, impactReason) -> {
            if (impactReason.isFailReason() && this.requestOptions.tiaRequestOptions().getTestFilterOptions().isIncludeFailedAndSkippedTests()) {
                impactedTests.add(PrioritizableTestsRetriever.retrieveTestForPrioritization(test, ETestSelectionReason.PREVIOUSLY_FAILED));
            } else if (impactReason.isSkipReason() && this.requestOptions.tiaRequestOptions().getTestFilterOptions().isIncludeFailedAndSkippedTests()) {
                impactedTests.add(PrioritizableTestsRetriever.retrieveTestForPrioritization(test, ETestSelectionReason.PREVIOUSLY_SKIPPED));
            } else if (impactReason.isCodeChangeReasonAfter(this.requestOptions.getResolvedBaselineTimestamp())) {
                Set changedMethodLocations = impactReason.getChangedMethodLocations(this.requestOptions.getResolvedBaselineTimestamp());
                impactedTests.add(PrioritizableTestsRetriever.retrieveTestForPrioritization(test, changedMethodLocations));
                methodsToTest.addAll(changedMethodLocations);
            }
        });
        impactedTests.addAll(this.getAddedOrModifiedTests());
        impactedTests.removeIf(this::testNoLongerExists);
        return impactedTests;
    }

    private boolean testNoLongerExists(PrioritizableTest detailsForPrioritization) {
        return this.testsAvailableForExecution != null && !this.testsAvailableForExecution.containsKey(detailsForPrioritization.getUniformPathString());
    }

    TestPrioritizationData getTestPrioritizationData() throws StorageException {
        TiaTestFilterQueryParams testFilterOptions = this.requestOptions.tiaRequestOptions().getTestFilterOptions();
        Set<MethodId> methodsToTest = new HashSet<MethodId>();
        Set<PrioritizableTest> impactedTests = this.getImpactedTestsAndCollectMethodsToTest(methodsToTest);
        if (testFilterOptions.isIncludeNonImpactedTests()) {
            impactedTests.addAll(this.getNonImpactedTests(impactedTests));
        }
        methodsToTest = ImpactedTestUtils.filterMethodsContainedInPath(this.requestOptions, this.projectStorageSystem, methodsToTest);
        return new TestPrioritizationData(impactedTests, methodsToTest, this.testsAvailableForExecution);
    }

    TestPrioritizationData getTestPrioritizationDataForMinimization(String query, Set<String> partitions) throws StorageException, QueryCompilationException, QueryParsingException {
        Set<PrioritizableTest> queriedTests = PrioritizableTestsRetriever.retrieveTestForPrioritization(this.getCoveringTestsByQuery(query, partitions), ETestSelectionReason.COVERS_CHANGES);
        Set methodIds = this.testsToMethodsMapIndex.getAllMethodIds();
        return new TestPrioritizationData(queriedTests, methodIds, this.testsAvailableForExecution);
    }

    TestPrioritizationData getTestPrioritizationDataForMinimization(Set<PartitionAndPath> tests) throws StorageException {
        Set<PrioritizableTest> queriedTests = PrioritizableTestsRetriever.retrieveTestForPrioritization(tests.stream().toList(), ETestSelectionReason.COVERS_CHANGES);
        Set methodIds = this.testsToMethodsMapIndex.getAllMethodIds();
        return new TestPrioritizationData(queriedTests, methodIds, this.testsAvailableForExecution);
    }
}

