/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.IServiceProfiler;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.profiler.StorageProfiler;

class ServiceProfilingSupport
implements IServiceProfiler {
    private static final String HEADER_PREFIX = "x-conqat-service-profiling-";
    private static final String ENABLEMENT_HEADER = "x-conqat-service-profiling-enabled";
    private static final String START_TIME_HEADER = "x-conqat-service-profiling-start-time";
    private static final String OVERALL_TIME_HEADER = "x-conqat-service-profiling-overall-time";
    private static final String STORAGE_TIME_HEADER = "x-conqat-service-profiling-storage-time";
    private static final String STORAGE_CALLS_HEADER = "x-conqat-service-profiling-storage-calls";
    private final boolean enabled;
    private final StorageProfiler storageProfiler;
    private final long startTimeMillis = System.currentTimeMillis();

    public ServiceProfilingSupport(ContainerRequestContext requestContext) {
        String enablementValue = requestContext.getHeaderString(ENABLEMENT_HEADER);
        this.enabled = Boolean.parseBoolean(enablementValue);
        this.storageProfiler = this.enabled ? new StorageProfiler() : null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public IStorageSystemProvider decorate(IStorageSystemProvider mainStorageSystemProvider) {
        if (this.isEnabled()) {
            return this.storageProfiler.decorate(mainStorageSystemProvider);
        }
        return mainStorageSystemProvider;
    }

    public void finishProfilingAndAppendResults(ContainerResponseContext responseContext) {
        if (!this.isEnabled()) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)START_TIME_HEADER, (Object)Long.toString(this.startTimeMillis));
        long overallTime = System.currentTimeMillis() - this.startTimeMillis;
        responseContext.getHeaders().putSingle((Object)OVERALL_TIME_HEADER, (Object)Long.toString(overallTime));
        responseContext.getHeaders().putSingle((Object)STORAGE_TIME_HEADER, (Object)Long.toString(this.storageProfiler.getTimeMillis()));
        responseContext.getHeaders().putSingle((Object)STORAGE_CALLS_HEADER, (Object)Long.toString(this.storageProfiler.getNumberOfCalls()));
    }
}

