/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.util;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;

public final class ForwardedHeaderUtils {
    private static final String FORWARDED_VALUE = "\"?([^;,\"]+)\"?";
    private static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("(?i:host)=\"?([^;,\"]+)\"?");
    private static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("(?i:proto)=\"?([^;,\"]+)\"?");
    private static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String HEADER_FORWARDED = "Forwarded";
    private static final String HEADER_X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    private static final String HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String HEADER_X_FORWARDED_PORT = "X-Forwarded-Port";
    private static final String HEADER_X_FORWARDED_SSL = "X-Forwarded-Ssl";

    public static URI getBaseUri(ContainerRequestContext containerRequestContext) {
        return ForwardedHeaderUtils.adaptFromForwardedHeaders(containerRequestContext.getUriInfo().getBaseUri(), (MultivaluedMap<String, String>)containerRequestContext.getHeaders());
    }

    @VisibleForTesting
    static URI adaptFromForwardedHeaders(URI uri, MultivaluedMap<String, String> headers) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
        String forwardedHeader = (String)headers.getFirst((Object)HEADER_FORWARDED);
        if (!StringUtils.isEmpty((String)forwardedHeader)) {
            ForwardedHeaderUtils.adaptForForwardedHeader(headers, forwardedHeader, uriBuilder);
        } else {
            ForwardedHeaderUtils.adaptForXForwardedHeaders(headers, uriBuilder);
        }
        String forwardedPrefix = (String)headers.getFirst((Object)HEADER_X_FORWARDED_PREFIX);
        if (!StringUtils.isEmpty((String)forwardedPrefix)) {
            uriBuilder.replacePath(StringUtils.ensureEndsWith((String)forwardedPrefix, (String)"/"));
        }
        return ForwardedHeaderUtils.ensurePathEndsWithSlash(ForwardedHeaderUtils.resetDefaultPort(uriBuilder.build(new Object[0])));
    }

    private static void adaptForXForwardedHeaders(MultivaluedMap<String, String> headers, UriBuilder uriBuilder) {
        String portHeader;
        String protocolHeader = (String)headers.getFirst((Object)HEADER_X_FORWARDED_PROTO);
        if (!StringUtils.isEmpty((String)protocolHeader)) {
            uriBuilder.scheme(protocolHeader.split(",")[0]);
            uriBuilder.port(-1);
        } else if (ForwardedHeaderUtils.isForwardedSslOn(headers)) {
            uriBuilder.scheme("https");
            uriBuilder.port(-1);
        }
        String hostHeader = (String)headers.getFirst((Object)HEADER_X_FORWARDED_HOST);
        if (!StringUtils.isEmpty((String)hostHeader)) {
            ForwardedHeaderUtils.adaptForwardedHost(uriBuilder, hostHeader.split(",")[0], headers);
        }
        if (!StringUtils.isEmpty((String)(portHeader = (String)headers.getFirst((Object)HEADER_X_FORWARDED_PORT)))) {
            uriBuilder.port(ForwardedHeaderUtils.parsePort(portHeader.split(",")[0], headers));
        }
    }

    private static void adaptForForwardedHeader(MultivaluedMap<String, String> headers, String forwardedHeader, UriBuilder uriBuilder) {
        Matcher matcher = FORWARDED_PROTO_PATTERN.matcher(forwardedHeader);
        if (matcher.find()) {
            uriBuilder.scheme(matcher.group(1).trim());
            uriBuilder.port(-1);
        } else if (ForwardedHeaderUtils.isForwardedSslOn(headers)) {
            uriBuilder.scheme("https");
            uriBuilder.port(-1);
        }
        matcher = FORWARDED_HOST_PATTERN.matcher(forwardedHeader);
        if (matcher.find()) {
            ForwardedHeaderUtils.adaptForwardedHost(uriBuilder, matcher.group(1).trim(), headers);
        }
    }

    private static URI ensurePathEndsWithSlash(URI uri) {
        if (!uri.getPath().endsWith("/")) {
            return UriBuilder.fromUri((URI)uri).replacePath(uri.getPath() + "/").build(new Object[0]);
        }
        return uri;
    }

    private static int parsePort(String portString, MultivaluedMap<String, String> headers) {
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException ex) {
            throw new BadRequestException("Failed to parse a port from \"forwarded\"-type headers. Request headers: " + String.valueOf(headers));
        }
    }

    private static URI resetDefaultPort(URI uri) {
        if ("http".equals(uri.getScheme()) && uri.getPort() == 80 || "https".equals(uri.getScheme()) && uri.getPort() == 443) {
            return UriBuilder.fromUri((URI)uri).port(-1).build(new Object[0]);
        }
        return uri;
    }

    private static boolean isForwardedSslOn(MultivaluedMap<String, String> headers) {
        String forwardedSsl = (String)headers.getFirst((Object)HEADER_X_FORWARDED_SSL);
        return !StringUtils.isEmpty((String)forwardedSsl) && forwardedSsl.equalsIgnoreCase("on");
    }

    private static void adaptForwardedHost(UriBuilder uriComponentsBuilder, String rawValue, MultivaluedMap<String, String> headers) {
        int squareBracketIdx;
        int portSeparatorIdx = rawValue.lastIndexOf(58);
        if (portSeparatorIdx > (squareBracketIdx = rawValue.lastIndexOf(93))) {
            if (squareBracketIdx == -1 && rawValue.indexOf(58) != portSeparatorIdx) {
                throw new IllegalArgumentException("Invalid IPv4 address: " + rawValue);
            }
            uriComponentsBuilder.host(rawValue.substring(0, portSeparatorIdx));
            uriComponentsBuilder.port(ForwardedHeaderUtils.parsePort(rawValue.substring(portSeparatorIdx + 1), headers));
        } else {
            uriComponentsBuilder.host(rawValue);
            uriComponentsBuilder.port(-1);
        }
    }

    private ForwardedHeaderUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

