/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.stream;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import org.conqat.engine.core.stream.IStreamSource;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.error.ExceptionUtils;

class ConcatenatedStreamSource<T, E extends Exception>
implements IStreamSource<T, E> {
    private final Queue<IStreamSource<T, E>> sources;
    private final Class<E> exceptionType;

    public ConcatenatedStreamSource(Collection<IStreamSource<T, E>> sources, Class<E> exceptionType) {
        CCSMAssert.isNotNull(sources, () -> String.format("Expected \"%s\" to be not null", "sources"));
        CCSMAssert.isNotNull(exceptionType, () -> String.format("Expected \"%s\" to be not null", "exceptionType"));
        sources.forEach(source -> CCSMAssert.isNotNull((Object)source, () -> String.format("Expected \"%s\" to not contain null values", "sources")));
        this.sources = new LinkedList<IStreamSource<T, IStreamSource<T, E>>>(sources);
        this.exceptionType = exceptionType;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) throws E {
        while (!this.sources.isEmpty()) {
            if (this.sources.element().tryAdvance(action)) {
                return true;
            }
            this.sources.remove().close();
        }
        return false;
    }

    @Override
    public void close() throws E {
        Throwable thrown = null;
        while (!this.sources.isEmpty()) {
            try {
                this.sources.remove().close();
            }
            catch (Throwable e) {
                if (thrown == null) {
                    thrown = e;
                    continue;
                }
                thrown.addSuppressed(e);
            }
        }
        if (thrown != null) {
            this.rethrow(thrown);
        }
    }

    private void rethrow(Throwable throwable) throws E {
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        if (this.exceptionType().isInstance(throwable)) {
            throw (Exception)this.exceptionType().cast(throwable);
        }
        throw (ClassCastException)ExceptionUtils.withSuppressed((Throwable)new ClassCastException("Checked Exception of type %s is different from the excepted Exception type %s".formatted(throwable.getClass(), this.exceptionType())), (Throwable)throwable);
    }

    @Override
    public Class<E> exceptionType() {
        return this.exceptionType;
    }
}

