/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.findings.location;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.TeamscaleIssueFieldLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ManualTestCaseTextRegionLocation.class)
@IndexValueClass(containedInBackup=true)
public class ManualTestCaseTextRegionLocation
extends TeamscaleIssueFieldLocation {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="startTestStepIdentifier")
    private final @NonNull TestStepCellIdentifier startTestStepIdentifier;
    @JsonProperty(value="endTestStepIdentifier")
    private final @NonNull TestStepCellIdentifier endTestStepIdentifier;
    @JsonProperty(value="gapLocations")
    private final @NonNull UnmodifiableList<GapLocation> gapLocations;

    public ManualTestCaseTextRegionLocation(TeamscaleIssueFieldLocation fieldLocation, int startStepIndex, boolean startStepAction, int endStepIndex, boolean endStepAction, @Nullable List<GapLocation> gapLocations) {
        super(fieldLocation);
        CCSMAssert.isTrue((startStepIndex >= 0 && endStepIndex >= 0 ? 1 : 0) != 0, () -> String.format("Test steps cannot be negative (start=%d, end=%d).", startStepIndex, endStepIndex));
        CCSMAssert.isTrue((startStepIndex <= endStepIndex ? 1 : 0) != 0, () -> String.format("Start step (%d) cannot be greater than end step (%d).", startStepIndex, endStepIndex));
        if (startStepIndex == endStepIndex) {
            CCSMAssert.isTrue((startStepAction == endStepAction || startStepAction ? 1 : 0) != 0, (String)"Single step locations cannot start in 'check' and end in 'action'.");
        }
        this.startTestStepIdentifier = new TestStepCellIdentifier(startStepIndex, startStepAction);
        this.endTestStepIdentifier = new TestStepCellIdentifier(endStepIndex, endStepAction);
        this.gapLocations = gapLocations == null ? CollectionUtils.emptyList() : CollectionUtils.asUnmodifiable(new ArrayList<GapLocation>(gapLocations));
    }

    public ManualTestCaseTextRegionLocation(String uniformPath, String issueId, TeamscaleIssueFieldLocation.RawAndFieldSpecific startOffset, TeamscaleIssueFieldLocation.RawAndFieldSpecific endOffset, TeamscaleIssueFieldLocation.RawAndFieldSpecific startLine, TeamscaleIssueFieldLocation.RawAndFieldSpecific endLine, int startStepIndex, boolean startStepAction, int endStepIndex, boolean endStepAction, String testStepsFieldName, @Nullable List<GapLocation> gapLocations) {
        this(new TeamscaleIssueFieldLocation(uniformPath, issueId, startOffset, endOffset, startLine, endLine, testStepsFieldName), startStepIndex, startStepAction, endStepIndex, endStepAction, gapLocations);
    }

    public int getStartStepIndex() {
        return this.startTestStepIdentifier.index;
    }

    public int getEndStepIndex() {
        return this.endTestStepIdentifier.index;
    }

    public boolean startsInStepAction() {
        return this.startTestStepIdentifier.isAction;
    }

    public boolean endsInStepAction() {
        return this.endTestStepIdentifier.isAction;
    }

    public boolean isSingleCellLocation() {
        return this.isSingleStepLocation() && this.startTestStepIdentifier.isAction == this.endTestStepIdentifier.isAction;
    }

    public boolean isSingleStepLocation() {
        return this.startTestStepIdentifier.index == this.endTestStepIdentifier.index;
    }

    public @NonNull UnmodifiableList<GapLocation> getGapLocations() {
        return this.gapLocations;
    }

    @Override
    public String toLocationString() {
        String fieldPath = String.join((CharSequence)":", this.getUniformPath(), this.getAffectedField());
        String startStep = String.valueOf(this.getStartStepIndex() + 1);
        String startColumn = StringUtils.alternativeOnCondition((boolean)this.startsInStepAction(), (String)"action", (String)"check");
        if (this.isSingleCellLocation()) {
            return String.join((CharSequence)":", fieldPath, startStep, startColumn, this.getFieldStartLine() + "-" + this.getFieldEndLine());
        }
        if (this.isSingleStepLocation()) {
            String endColumn = StringUtils.alternativeOnCondition((boolean)this.endsInStepAction(), (String)"action", (String)"check");
            return String.join((CharSequence)":", fieldPath, startStep, startColumn + "@" + this.getFieldStartLine() + "-" + endColumn + "@" + this.getFieldEndLine());
        }
        String endColumn = StringUtils.alternativeOnCondition((boolean)this.endsInStepAction(), (String)"action", (String)"check");
        String endStep = String.valueOf(this.getEndStepIndex() + 1);
        return String.join((CharSequence)":", fieldPath, startStep + "|" + startColumn + "@" + this.getFieldStartLine() + "-" + endStep + "|" + endColumn + "@" + this.getFieldEndLine());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ManualTestCaseTextRegionLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManualTestCaseTextRegionLocation)) {
            return false;
        }
        ManualTestCaseTextRegionLocation that = (ManualTestCaseTextRegionLocation)o;
        return that.canEqual(this) && Objects.equals(this.startTestStepIdentifier, that.startTestStepIdentifier) && Objects.equals(this.endTestStepIdentifier, that.endTestStepIdentifier) && Objects.equals(this.gapLocations, that.gapLocations) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startTestStepIdentifier, this.endTestStepIdentifier, this.gapLocations);
    }

    @IndexValueClass(containedInBackup=true)
    public static final class TestStepCellIdentifier
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="index")
        public final int index;
        @JsonProperty(value="isAction")
        public final boolean isAction;

        public TestStepCellIdentifier(int index, boolean isAction) {
            this.index = index;
            this.isAction = isAction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestStepCellIdentifier)) {
                return false;
            }
            TestStepCellIdentifier that = (TestStepCellIdentifier)o;
            return this.index == that.index && this.isAction == that.isAction;
        }

        public int hashCode() {
            return Objects.hash(this.index, this.isAction);
        }

        public String toString() {
            return this.index + "/" + StringUtils.alternativeOnCondition((boolean)this.isAction, (String)"action", (String)"check");
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static final class GapLocation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="startCell")
        public final TestStepCellIdentifier startCell;
        @JsonProperty(value="endCell")
        public final TestStepCellIdentifier endCell;
        @JsonProperty(value="fieldStartOffset")
        public final int startOffset;
        @JsonProperty(value="fieldEndOffset")
        public final int endOffset;

        public GapLocation(TestStepCellIdentifier startCell, TestStepCellIdentifier endCell, int startOffset, int endOffset) {
            this.startCell = startCell;
            this.endCell = endCell;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GapLocation)) {
                return false;
            }
            GapLocation that = (GapLocation)o;
            return Objects.equals(this.startCell, that.startCell) && Objects.equals(this.endCell, that.endCell) && this.startOffset == that.startOffset && this.endOffset == that.endOffset;
        }

        public int hashCode() {
            return Objects.hash(this.startCell, this.endCell, this.startOffset, this.endOffset);
        }

        public String toString() {
            return "GapLocation[" + String.valueOf(this.startCell) + "@" + this.startOffset + "-" + String.valueOf(this.endCell) + "@" + this.endOffset + "]";
        }
    }
}

