This check finds `for` loops that can be simplified to `while` loops.

`for` loops that do not contain an initialization and an update statement should be simplified to `while` loops. 

# Why is This a Problem?

If there is no need for separate initialization and update steps during loop iterations, using a `while` loop is
more comprehensible and more concise than using a `for` loop.

# How Can I Resolve This?

A `for` loop without initialization and without update statements can be trivially re-written as an equivalent `while`
statement that uses the original `for` loop's test expression.

## Examples

### Before (Java)
```java
void foobar(int a) {
    for (; a < 10;) {
        foo(a--);
    }
}
```

### After (Java)
```java
void foobar(int a) {
    while (a < 10) {  // simplified while statement
        foo(a--);
    }
}
```
