This check detects ABAP CDS view definitions that are missing the `@VDM.viewType` annotation.

# Why is This a Problem?
Using the `@VDM.viewType` annotation helps to improve the readability 
and maintainability of the ABAP CDS view definition, as it makes it clear what type of view is being defined.

You can configure alternative VDM view type annotation option in the analysis profile to use your custom annotation.

# How Can I Resolve This?

To fix this issue, add the `@VDM.viewType` annotation to the CDS view definition with the appropriate view type value.

If an alternative annotation is configured in the analysis profile, you can add that instead of `@VDM.viewType`.

## Example (Before)

```
define view entity EXAMPLE {
    ...
}
```

## Example (After)

```
@VDM.viewType: #BASIC
define view entity EXAMPLE {
    ...
}
```

# Where Can I Learn More?

## References

- [VDM Annotations](https://help.sap.com/docs/SAP_NETWEAVER_750/cc0c305d2fab47bd808adcad3ca7ee9d/efe9c80fc6ba4db692e08340c9151a17.html?version=7.5.9)
- [VDM Layers and View Types](https://help.sap.com/docs/SAP_S4HANA_ON-PREMISE/8308e6d301d54584a33cd04a9861bc52/0a875bc7a005465aad92c08becc11776.html#layers-of-the-vdm)
- [SAP Blog: ABAP Core Data Services – Part 3(Virtual Data model types)](https://blogs.sap.com/2017/10/09/abap-core-data-services-part-2virtual-data-model-types/#VDM)