import{_ as o,h as t,ak as a,g as s}from"./chunks/framework.B7a_7emw.js";const r="/assets/tfs_hook_1.eRcULmGQ.png",i="/assets/tfs_hook_2.C_pw1tw2.png",n="/assets/tfs_alert_commit_1.D6d6E-e5.png",c="/assets/tfs_alert_commit_2.DpaEusre.png",v=JSON.parse('{"title":"Configuring Post-Commit Hooks","description":"","frontmatter":{"title":"Configuring Post-Commit Hooks"},"headers":[],"relativePath":"howto/configuring-post-commit-hooks/index.md","filePath":"howto/configuring-post-commit-hooks/index.md"}'),l={name:"howto/configuring-post-commit-hooks/index.md"};function h(m,e,p,d,u,f){return s(),t("div",null,[...e[0]||(e[0]=[a('<h1 id="how-to-configure-teamscale-to-use-post-commit-hooks" tabindex="-1">How to Configure Teamscale to use Post-Commit Hooks <a class="header-anchor" href="#how-to-configure-teamscale-to-use-post-commit-hooks" aria-label="Permalink to &quot;How to Configure Teamscale to use Post-Commit Hooks&quot;">​</a></h1><p>By default, Teamscale uses a poll mechanism to regularly check for new revisions on the server. Depending on the polling interval you configured, this can lead to a large delay between the actual commit and the update of the data in Teamscale, or to a very high load on your version control system server (especially with many projects).</p><p>One solution to this problem are post-commit hooks, which are supported by many version control systems.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>If you want to connect to a code collaboration platform like GitHub or Azure DevOps, you can use the dedicated code connector for that platform. This will automatically setup the post-commit hooks for you. Moreover, you can get even tighter integration by allowing Teamscale to vote and comment on merge requests.</p></div><nav class="table-of-contents"><ul><li><a href="#post-commit-hooks-for-subversion">Post-Commit Hooks for Subversion</a></li><li><a href="#post-commit-hooks-for-azure-devops-team-foundation-server">Post-Commit Hooks for Azure DevOps / Team Foundation Server</a><ul><li><a href="#azure-devops-service-hooks">Azure DevOps Service Hooks</a></li><li><a href="#legacy-team-foundation-server-alerts">Legacy Team Foundation Server Alerts</a></li></ul></li><li><a href="#code-collaboration-platforms">Code Collaboration Platforms</a><ul><li><a href="#disable-automatic-webhook-creation">Disable Automatic Webhook Creation</a></li><li><a href="#decrease-polling-interval-for-merge-request-changes">Decrease Polling Interval for Merge Request Changes</a></li></ul></li></ul></nav><p>In general, you configure the Teamscale project with a large polling interval. Polling will still happen from time to time as a fallback if the post-commit hook failed for some reason. Then you have to configure your version control system to call the following URL after each commit:</p><p><code>http://teamscale.company.com/api/post-commit-hook?repository=REPOSITORY</code></p><p>Here the part <code>http://teamscale.company.com/</code> is the URL of your teamscale server. Authentication happens via <a href="https://en.wikipedia.org/wiki/Basic_access_authentication" target="_blank" rel="noreferrer">HTTP Basic Authentication</a> and requires a <em>user name</em> and the user&#39;s <a href="./../../glossary/#access-key"><em>access key</em></a> (<strong>not</strong> the password). The REPOSITORY is the URL of the repository as configured in Teamscale. For example, if you have a project reading from the Subversion repository <code>http://svn.company.com/project1/trunk/foo</code> , the URL may be <code>http://svn.company.com/project1/trunk/foo</code> or any prefix, such as <code>http://svn.company.com/project1/</code> or even <code>http://svn.company.com/</code> . Note that all projects for which the prefix matches will be checked for updates, so a more specific prefix can help to reduce the server load. However, being too specific does not work. If you pass <code>http://svn.company.com/project1/trunk/foo/some/file</code> as repository parameter, the prefix match will fail and no update is triggered.</p><p>You can use <code>POST</code> requests to call the URL.</p><h2 id="post-commit-hooks-for-subversion" tabindex="-1">Post-Commit Hooks for Subversion <a class="header-anchor" href="#post-commit-hooks-for-subversion" aria-label="Permalink to &quot;Post-Commit Hooks for Subversion&quot;">​</a></h2><p>Subversion supports the execution of arbitrary (shell) scripts for various hooks. The hook that should be used is called <em>post-commit</em>. To access the URL you can use the tools <em>wget</em> or <em>curl</em>. See the SVN book for more details on configuration of commit hooks.</p><h2 id="post-commit-hooks-for-azure-devops-team-foundation-server" tabindex="-1">Post-Commit Hooks for Azure DevOps / Team Foundation Server <a class="header-anchor" href="#post-commit-hooks-for-azure-devops-team-foundation-server" aria-label="Permalink to &quot;Post-Commit Hooks for Azure DevOps / Team Foundation Server&quot;">​</a></h2><p>In Azure DevOps users can configure commit hooks with custom alerts and service hooks (version 2015+). Both are available via the admin settings for a team project (gear icon in the top loft corner).</p><p>For both methods the <code>REPOSITORY</code> parameter of the URL to the Teamscale commit hook service (as described above) is <code>TFS_URL/TEAM_COLLECTION/FOLDER_PATH</code> , e.g.<br><code>http://yourcompany.com/tfs/DefaultCollection/$</code></p><p><code>/MyProject/Dev/Source</code> .</p><h3 id="azure-devops-service-hooks" tabindex="-1">Azure DevOps Service Hooks <a class="header-anchor" href="#azure-devops-service-hooks" aria-label="Permalink to &quot;Azure DevOps Service Hooks&quot;">​</a></h3><p><em>Service Hooks</em> are the successor of <em>Alerts</em> and available in Visual Studio Team Services and Team Foundation Server 2015 onwards. They are easier to set-up and provide debug information if a request fails.</p><p>Switch to the <em>Service Hooks</em> tab, create a new subscription and select <em>Web Hooks</em> as type of service. Change the trigger type to <em>Code checked in</em> and enter the TFS repository path you want to monitor for changes:</p><p><img src="'+r+'" alt="Create a trigger that listens on code changes." width="1234" height="950" data-zoom="true"></p><p>If you are hosting a Git repository via Team Foundation Server you have to select <em>Code pushed</em> as event type and simply select the repository you want to monitor for changes. Optionally you can restrict the event to only be fired if a specific branch is pushed.</p><p>After clicking <em>Next</em> you have to enter the URL of the commit hook:</p><p><img src="'+i+'" alt="Configure the service hook action." width="1208" height="947" data-zoom="true"></p><p>All other fields can be left empty and it is not required to send any further data to teamscale at all.</p><p>The user who creates the subscription needs to have the TFS permission <em>Edit subscriptions and View subscriptions</em>. See <a href="https://docs.microsoft.com/en-us/azure/devops/service-hooks/overview?view=azure-devops" target="_blank" rel="noreferrer">https://docs.microsoft.com/en-us/azure/devops/service-hooks/overview?view=azure-devops</a> for further information.</p><h3 id="legacy-team-foundation-server-alerts" tabindex="-1">Legacy Team Foundation Server Alerts <a class="header-anchor" href="#legacy-team-foundation-server-alerts" aria-label="Permalink to &quot;Legacy Team Foundation Server Alerts&quot;">​</a></h3><div class="warning custom-block"><p class="custom-block-title">Deprecation</p><p>Service Hooks (available since Azure DevOps version 2015 onwards) are the successor of Alerts and should be used if possible..</p></div><p>Switch to the <em>alerts</em> tab and create a new alert of type <em>A file is checked in under a specified path</em>:</p><p><img src="'+n+'" alt="Create a new TFS commit alert." width="1100" height="650" data-zoom="true"></p><p>Then alter the following fields as shown here:</p><ul><li><p><em>Name</em>: Alter the name to something that reminds you this is the commit hook for Teamscale.</p></li><li><p><em>Send To</em>: The commit hook url.</p></li><li><p><em>Format</em>: Change to SOAP.</p></li><li><p><em>Filter Value</em>: Change from <code>$/</code> to the folder path used in the commit hook, e.g.<code>$/MyProject/Dev/Source</code> .</p></li></ul><p>If you are hosting a Git repository via Team Foundation Server you have to select the alert type <em>Push &gt; A commit is pushed to a specified repository</em>. The <em>Send To</em> and <em>Format</em> fields have to specified in the same way as described above.</p><p><img src="'+c+`" alt="Configure the TFS commit alert." width="1380" height="521" data-zoom="true"></p><p>If you receive an error on save saying that the user needs the right <em>Create a SOAP subscription</em>, an administrator has to issue the following command (e.g., from VisualStudio Command Prompt):</p><div class="language-powershell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">powershell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">tfssecurity.exe</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> /</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">a</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">+</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> EventSubscription $</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">SUBSCRIPTION:</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">CREATE_SOAP_SUBSCRIPTION n:DOMAIN\\USERNAME ALLOW</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">/</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">collection:TFS_URL</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">/</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">TEAM_COLLECTION</span></span></code></pre></div><p>Ensure to substitute <code>DOMAIN</code> and <code>USERNAME</code> with the login of the account you want to create the alert for and <code>TFS_URL/TEAM_COLLECTION</code> with the url to your TFS Team Collection.</p><h2 id="code-collaboration-platforms" tabindex="-1">Code Collaboration Platforms <a class="header-anchor" href="#code-collaboration-platforms" aria-label="Permalink to &quot;Code Collaboration Platforms&quot;">​</a></h2><p>Connectors to code collaboration platforms create hooks automatically upon creation of a project in Teamscale. The hooks are used to determine whenever new code has been pushed or merge requests have been created or changed. However, this only works if:</p><ul><li>The Teamscale server is reachable from the code collaboration platform</li><li>The user account Teamscale uses to access the code collaboration platform has sufficient privileges to create hooks</li></ul><h3 id="disable-automatic-webhook-creation" tabindex="-1">Disable Automatic Webhook Creation <a class="header-anchor" href="#disable-automatic-webhook-creation" aria-label="Permalink to &quot;Disable Automatic Webhook Creation&quot;">​</a></h3><p>If any of the above conditions do not meet, you should disable the automatic creation of webhooks. This can be done by setting the corresponding expert option in the repository connector.</p><p>You may also adjust the default value for this option globally for your instance by passing the following <a href="./../../reference/administration-ts-installation/#jvm-arguments">JVM argument</a> on the start of Teamscale:</p><p><code>-Dcom.teamscale.mergerequest.disable-automatic-webhook-creation-default=true</code></p><div class="warning custom-block"><p class="custom-block-title">WARNING</p><p>This value can be overridden by project-specific settings.</p></div><p>In case of missing privileges, you can manually create the needed webhooks instead. Please refer to the documentation of the specific code collaboration platform connector for the concrete URL and which events need to be processed.</p><p>Otherwise, you should decrease the <em>Polling interval</em> of the code connector to e.g. 600 or 60 seconds.</p><h3 id="decrease-polling-interval-for-merge-request-changes" tabindex="-1">Decrease Polling Interval for Merge Request Changes <a class="header-anchor" href="#decrease-polling-interval-for-merge-request-changes" aria-label="Permalink to &quot;Decrease Polling Interval for Merge Request Changes&quot;">​</a></h3><p>Besides polling for code changes, Teamscale also polls the code collaboration platform for changes regarding merge requests, e.g., whether a merge request has been newly created, merged or deleted. This polling mechanism only acts as a safety net when a webhook from the code collaboration platform is missed. Hence, it is only executed once a day.</p><p>If the code collaboration platform cannot reach Teamscale via a web hook at all, you should decrease the polling interval. This can be done by passing the following <a href="./../../reference/administration-ts-installation/#jvm-arguments">JVM argument</a> on the start of Teamscale:</p><p><code>-Dcom.teamscale.mergerequest.polling_interval_seconds=600</code></p><div class="warning custom-block"><p class="custom-block-title">WARNING</p><p>After you have changed this value, Teamscale projects using a connector to a code collaboration platforms need to be reanalyzed in order for the setting to take effect.</p></div>`,50)])])}const k=o(l,[["render",h]]);export{v as __pageData,k as default};
