import{_ as d,h as u,ak as r,O as i,z as a,L as l,g as h,j as e,x as t}from"./chunks/framework.B7a_7emw.js";const c="/assets/admin-azure-auth.DTqYVpRE.png",A=JSON.parse('{"title":"Importing Users & Groups","description":"","frontmatter":{"title":"Importing Users & Groups"},"headers":[],"relativePath":"howto/importing-users/index.md","filePath":"howto/importing-users/index.md"}'),p={name:"howto/importing-users/index.md"};function m(g,o,f,y,b,v){const n=l("PluginTabsTab"),s=l("PluginTabs");return h(),u("div",null,[o[4]||(o[4]=r('<h1 id="how-to-import-users-groups-ldap-saml-openid-connect-tfs" tabindex="-1">How to Import Users &amp; Groups (LDAP, SAML, OpenID Connect, TFS) <a class="header-anchor" href="#how-to-import-users-groups-ldap-saml-openid-connect-tfs" aria-label="Permalink to &quot;How to Import Users &amp; Groups (LDAP, SAML, OpenID Connect, TFS)&quot;">​</a></h1><p>Teamscale comes with a built-in user management system. In many scenarios, however, it makes more sense to connect to an existing user management system like LDAP instead.</p><nav class="table-of-contents"><ul><li><a href="#importing-users-groups-from-ldap-server">Importing Users &amp; Groups from LDAP Server</a><ul><li><a href="#global-ldap-catalog">Global LDAP Catalog</a></li><li><a href="#fallback-ldap-servers">Fallback LDAP Servers</a></li></ul></li><li><a href="#using-azure-devops-authorization-formerly-tfs-authorization-server">Using Azure DevOps Authorization (formerly: TFS Authorization Server)</a></li><li><a href="#single-sign-on-using-saml-2-0-or-openid-connect">Single sign-on using SAML 2.0 or OpenID Connect</a><ul><li><a href="#first-step-setup-identity-provider-outside-teamscale">First Step: Setup Identity Provider (outside Teamscale)</a></li><li><a href="#second-step-setup-connection-in-teamscale">Second Step: Setup connection in Teamscale</a></li><li><a href="#optional-automatic-user-creation">Optional: Automatic user creation</a></li><li><a href="#optional-group-synchronization">Optional: Group Synchronization</a></li><li><a href="#optional-automatic-redirection-to-the-single-sign-on-login-page">Optional: Automatic redirection to the Single sign-on login page</a></li></ul></li><li><a href="#single-sign-on-using-an-authentication-proxy-and-bearer-token">Single sign-on using an Authentication Proxy and Bearer Token</a></li></ul></nav><h2 id="importing-users-groups-from-ldap-server" tabindex="-1">Importing Users &amp; Groups from LDAP Server <a class="header-anchor" href="#importing-users-groups-from-ldap-server" aria-label="Permalink to &quot;Importing Users &amp; Groups from LDAP Server&quot;">​</a></h2><p>Teamscale provides LDAP integration to synchronize your LDAP users and groups with the teamscale server. Teamscale can import groups or individual users from a configured LDAP server.</p><p>To configure LDAP</p><ul><li>Go to the Admin perspective.</li><li>Navigate to <em>Settings</em> &gt; <em>Authentication</em>.</li><li>Press <em>Add</em> under the <em>LDAP Server</em> section.</li><li>Enter a name for the server.</li></ul><p>The options are:</p><h4 id="ldap-server-options" tabindex="-1">LDAP Server Options <a class="header-anchor" href="#ldap-server-options" aria-label="Permalink to &quot;LDAP Server Options&quot;">​</a></h4><table><tbody><tr><th>Option</th><th>Description</th></tr><tr><td>Hostname</td><td>The server’s hostname (URL).</td></tr><tr><td>Port</td><td>The server’s port.</td></tr><tr><td>SSL</td><td>Select this checkbox if the server is using SSL for connections.</td></tr><tr><td>Base DN for users</td><td>The DN under which the users are stored on the LDAP tree. For example: ou=users,dc=example,dc=com.</td></tr><tr><td>Base DN for groups</td><td>The DN under which the groups are stored on the LDAP tree. For example: ou=groups,dc=example,dc=com.</td></tr><tr><td>Group attribute</td><td>The attribute groups are saved with. For example: cn, if the group DN looks like: cn=GROUPNAME,ou=groups,dc=example,dc=com.</td></tr><tr><td>DN for the initial bind</td><td>Full DN of the user used for the connection. This user should have read access to all users and groups. For example: uid=readadmin,ou=users, dc=example,dc=com.</td></tr><tr><td>Password for initial bind</td><td>The password used by the bind user.</td></tr><tr><td>Login attribute</td><td>The attribute users are saved with. For example: uid, if the user DN looks like: uid=USERNAME,ou=users,dc=example,dc=com.</td></tr><tr><td>Group member attribute</td><td>The attribute under which each group stores its members.</td></tr><tr><td>First name attribute</td><td>The attribute used to store the first name of users.</td></tr><tr><td>Last name attribute</td><td>The attribute used to store the last name of users.</td></tr><tr><td>Email attribute</td><td>The attribute used to store the user’s email address.</td></tr><tr><td>Allow Login with LDAP</td><td>Select this checkbox if you want to use LDAP for login.</td></tr></tbody></table><p>Add the server by pressing the <code>Add</code> button.</p><p>You can now import <strong>entire groups</strong> of users using the <code>Import</code> button in <em>Admin</em> &gt; <em>Groups</em>. If you wish to import <strong>single users</strong>, use the <code>Import</code> button in <em>Admin</em> &gt; <em>Users</em>.</p><p>If you want to <em>update</em> users or groups, use the synchronize buttons found in both views. Synchronization of groups will also synchronize existing users and import recently added users of each group.</p><p>Automatic synchronization of users and groups can be enabled by entering a crontab expression via <em>Admin</em> &gt; <em>Settings</em> &gt; <em>Authentication</em> &gt; <em>Automatic server synchronization schedule</em>, e.g., <code>@midnight</code>.</p><h4 id="typical-settings-for-active-directory" tabindex="-1">Typical Settings for Active Directory <a class="header-anchor" href="#typical-settings-for-active-directory" aria-label="Permalink to &quot;Typical Settings for Active Directory&quot;">​</a></h4><p>When configuring an Active Directory server, typically, the following values can be used for the general settings:</p><table><tbody><tr><th>Option</th><th>Description</th></tr><tr><td>Group attribute</td><td>cn</td></tr><tr><td>Login attribute</td><td>sAMAccountName</td></tr><tr><td>Group member attribute</td><td>member (in some cases memberOf)</td></tr><tr><td>First name attribute</td><td>givenName</td></tr><tr><td>Last name attribute</td><td>sn</td></tr><tr><td>Email attribute</td><td>mail</td></tr></tbody></table><h4 id="typical-settings-for-open-ldap" tabindex="-1">Typical Settings for Open LDAP <a class="header-anchor" href="#typical-settings-for-open-ldap" aria-label="Permalink to &quot;Typical Settings for Open LDAP&quot;">​</a></h4><p>The following table shows typical settings for configuring an Open LDAP server:</p><table><tbody><tr><th>Option</th><th>Description</th></tr><tr><td>Group attribute</td><td>cn</td></tr><tr><td>Login attribute</td><td>uid</td></tr><tr><td>Group member attribute</td><td>memberUid</td></tr><tr><td>First name attribute</td><td>givenName</td></tr><tr><td>Last name attribute</td><td>sn</td></tr><tr><td>Email attribute</td><td>mail</td></tr></tbody></table><h4 id="recognition-of-ldap-user-and-group-entities" tabindex="-1">Recognition of LDAP user and group entities <a class="header-anchor" href="#recognition-of-ldap-user-and-group-entities" aria-label="Permalink to &quot;Recognition of LDAP user and group entities&quot;">​</a></h4><p>Teamscale prevents you from importing unknown LDAP object entities as users or groups. It checks whether a found LDAP entity has a well-known user or group object class. Valid object classes for users are <code>user</code>, <code>inetorgperson</code> and valid classes for groups are <code>group</code>, <code>groupOfNames</code> and <code>posixgroup</code>. You can add additional object classes by passing a comma-separated list on the start of Teamscale using the <code>-Dcom.teamscale.authenticate.ldap.user-object-classes=&quot;myusers,myotherusers&quot;</code> or <code>-Dcom.teamscale.authenticate.ldap.group-object-classes=&quot;mygroups,myothergroups&quot;</code><a href="./../../reference/administration-ts-installation/#jvm-arguments">JVM arguments</a>.</p><h3 id="global-ldap-catalog" tabindex="-1">Global LDAP Catalog <a class="header-anchor" href="#global-ldap-catalog" aria-label="Permalink to &quot;Global LDAP Catalog&quot;">​</a></h3><p>If users are stored in different domains and are thus not available from a single LDAP server, it is recommended to query the global catalog of one of the directory servers using port 3268 (or 3269 with SSL). The global catalog offers read-only access to most data of the whole domain tree and thus reduces the overhead to follow LDAP redirects to other servers. Not using the global catalog and following referrals will create a new connection for each LDAP request which may lead to refused connection errors.</p><h3 id="fallback-ldap-servers" tabindex="-1">Fallback LDAP Servers <a class="header-anchor" href="#fallback-ldap-servers" aria-label="Permalink to &quot;Fallback LDAP Servers&quot;">​</a></h3><p>If the LDAP server has fallback servers which are listed in the DNS record, it is recommended to configure the server host using the domain name instead of a single IP address. Teamscale will then use the fallback servers if the primary server is not available.</p><h2 id="using-azure-devops-authorization-formerly-tfs-authorization-server" tabindex="-1">Using Azure DevOps Authorization (formerly: TFS Authorization Server) <a class="header-anchor" href="#using-azure-devops-authorization-formerly-tfs-authorization-server" aria-label="Permalink to &quot;Using Azure DevOps Authorization (formerly: TFS Authorization Server)&quot;">​</a></h2><p>Teamscale can import groups from teams or groups of an on-premise TFS or Azure DevOps server. This will only synchronize group membership information (authorization); actual authentication and user import has to be delegated to another provider, e.g., LDAP.</p><p>Before starting configuration, ensure you have added external accounts for your TFS/Azure DevOps server. This is usually the case if you already configured code analysis for a project on that server.</p><p>To configure Azure DevOps Authorization, go to the Admin perspective and open <strong>Authentication</strong> in the <strong>Settings</strong> page. Press Add under the TFS Authorization Server section and enter a name for the server.</p><p><img src="'+c+'" alt="Azure DevOps Authorization Server Settings" width="1679" height="1161" data-zoom="true"></p><p>The image shows the configuration options for Azure DevOps Authorization. The different options are:</p><h4 id="tfs-authorization-server-options" tabindex="-1">TFS Authorization Server Options <a class="header-anchor" href="#tfs-authorization-server-options" aria-label="Permalink to &quot;TFS Authorization Server Options&quot;">​</a></h4><table><tbody><tr><th>Option</th><th>Description</th></tr><tr><td>The Azure Dev Ops Server account</td><td>The external account identifier of the Azure DevOps server. This must be configured first in External Accounts.</td></tr><tr><td>The property for the user login</td><td>The name of the user property that the delegated authenticator is queried for when importing users. This can be left empty in most cases. This means that for users in Azure DevOps Server who login with their Windows account, the DN (distinguished name) is used, and for all other users the E-Mail is used. If a value is specified, that specific property of the user in Azure DevOps Server will be extracted and used for further queries. Users that do not have that property specified or have an empty property will be ignored.</td></tr><tr><td>Retrieve users from the following servers</td><td>Mandatory for this connector. The identifier of the authentication provider that should be queried for users. Should be specified in the form of <code>&lt;type&gt;:&lt;name&gt;</code>, e.g., <code>ldap:local-ad</code>.</td></tr></tbody></table><h2 id="single-sign-on-using-saml-2-0-or-openid-connect" tabindex="-1">Single sign-on using SAML 2.0 or OpenID Connect <a class="header-anchor" href="#single-sign-on-using-saml-2-0-or-openid-connect" aria-label="Permalink to &quot;Single sign-on using SAML 2.0 or OpenID Connect&quot;">​</a></h2><p>This option can be used, if you already have a SAML 2.0 or OpenID Connect compatible Identity Provider. Note that OpenID Connect can only be used for authentication, which means that your groups and permissions still need to be managed in Teamscale or by connecting Teamscale to your LDAP server and importing corresponding users and groups. For SAML you can expose groups as a multi-valued SAML attribute, in which case Teamscale will synchronize the group information during user login.</p><h3 id="first-step-setup-identity-provider-outside-teamscale" tabindex="-1">First Step: Setup Identity Provider (outside Teamscale) <a class="header-anchor" href="#first-step-setup-identity-provider-outside-teamscale" aria-label="Permalink to &quot;First Step: Setup Identity Provider (outside Teamscale)&quot;">​</a></h3><p>As a first step, you must configure your identity provider (e.g. Azure DevOps or Google Cloud) to allow requests from Teamscale.</p>',38)),i(s,{sharedStateKey:"id_provider"},{default:a(()=>[i(n,{label:"SAML"},{default:a(()=>[...o[0]||(o[0]=[e("p",null,[t("For SAML, you need to configure at least the entity ID of the Teamscale service provider, which you can choose freely, and the assertion consumer. The latter is the Teamscale service called "),e("code",null,"api/auth/saml/authenticate"),t(". So if your Teamscale server is configured to serve "),e("code",null,"https://ts.company.com/"),t(", then the assertion consumer URL would be "),e("code",null,"https://ts.company.com/api/auth/saml/authenticate"),t(".")],-1),e("p",null,[t("The configuration details of your identity provider depend on the product used and are beyond the scope of this guide. After configuring your identity provider for SAML 2.0, you should obtain its entity ID and a metadata XML description of the identity provider in the form of a "),e("em",null,"SAML 2.0 entity descriptor"),t(" (an XML document that starts with a "),e("code",null,"<md:EntityDescriptor>"),t(" tag). This XML file must also contain the identity provider’s public key as an X.509 certificate.")],-1),e("div",{class:"tip custom-block"},[e("p",{class:"custom-block-title"},"Obtaining SAML Metadata XML from Teamscale."),e("p",null,[t("You can also download a SAML metadata XML from Teamscale, which also contains a certificate that can be used for encrypted assertions. To obtain this, configure a SAML provider as outlined in the second step, but leave out the Metadata XML from the identity provider. Click on the button "),e("em",null,"SAML Metadata"),t(" at the top right of the configuration section to obtain the metadata itself or a URL that you can paste into your identity provider's configuration.")]),e("p",null,`Note: The generated certificate is valid for 3 years. After this time, a new certificate has to be generated and Teamscale's Metadata XML in the identity provider updated. You can generate a new certificate using the "Regenerate Certificate" button. You can also let Teamscale automatically generate a new certificate before the current one expires, by enabling the "Automatically renew SP certificate" option. However, this is only recommended if the identity provider automatically updates the Metadata XML using the URL.`)],-1)])]),_:1}),i(n,{label:"OpenID Connect"},{default:a(()=>[...o[1]||(o[1]=[e("p",null,"For OpenID Connect, you have to add Teamscale as a new application or client. Depending on the identity provider, you might be able to set the following properties:",-1),e("table",null,[e("tbody",null,[e("tr",null,[e("th",null,"Property"),e("th",null,"Expected value")]),e("tr",null,[e("td",null,"Token endpoint authentication method"),e("td",null,[e("code",null,"POST")])]),e("tr",null,[e("td",null,"Allowed/authorized callback/redirect URIs"),e("td",null,[e("code",null,"<your-teamscale-url>/api/auth/openid/authenticate/<server-id>"),e("br"),e("br"),t("This must reference the Teamscale service called "),e("code",null,"api/auth/openid/authenticate"),t(". E.g. if your Teamscale server is configured to serve "),e("code",null,"https://ts.company.com/"),t(", then the redirect URI must be set to "),e("code",null,"https://ts.company.com/api/auth/openid/authenticate"),t(". If you have multiple OpenID Connect configurations set up in Teamscale, you also have to add the unique ID of the configuration to the path, e.g. "),e("code",null,"https://ts.company.com/api/auth/openid/authenticate/Google"),t(".")])]),e("tr",null,[e("td",null,"JSON Web Token (JWT) Algorithm"),e("td",null,[e("code",null,"RS256")])]),e("tr",null,[e("td",null,"Grants"),e("td",null,[e("code",null,"Authorization code")])]),e("tr",null,[e("td",null,"Supported scopes"),e("td",null,[e("code",null,"openid, profile, email")])]),e("tr",null,[e("td",null,"Back channel logout URI"),e("td",null,[e("code",null,"<your-teamscale-url>/api/auth/openid/logout"),e("br"),e("br"),t("Your identity provider might have the feature to log into multiple services, and send a back channel logout request to all of them if you log out from any of them. For that you must reference the Teamscale service called "),e("code",null,"api/auth/openid/logout"),t(". E.g. if your Teamscale server is configured to serve "),e("code",null,"https://ts.company.com/"),t(", then the back channel logout URI must be set to "),e("code",null,"https://ts.company.com/api/auth/openid/logout"),t(".")])]),e("tr",null,[e("td",null,"Valid post logout redirect URIs"),e("td",null,[e("code",null,"<your-teamscale-url>/login"),e("br"),e("br"),t("When logging out from Teamscale, you will be redirected to your identity provider for actual logout, which then should redirect you to the Teamscale login page. Depending on your identity provider, you will have to enable the Teamscale login page as valid target for this post logout redirect.")])])])],-1),e("p",null,'Note that the "expected values" are currently supported by Teamscale. Other configuration details of your identity provider depend on the product used and are beyond the scope of this guide.',-1),e("p",null,"After configuring your identity provider for OpenID Connect, you should obtain a Client ID and a Client Secret.",-1)])]),_:1})]),_:1}),o[5]||(o[5]=r('<h3 id="second-step-setup-connection-in-teamscale" tabindex="-1">Second Step: Setup connection in Teamscale <a class="header-anchor" href="#second-step-setup-connection-in-teamscale" aria-label="Permalink to &quot;Second Step: Setup connection in Teamscale&quot;">​</a></h3><ol><li>In Teamscale, in the <strong>Admin</strong> perspective navigate to <strong>Settings</strong>.</li><li>Ensure that your <code>Teamscale instance base URL</code> is set correctly.</li><li>Navigate to <code>Authentication</code>.</li><li>Add a new connection with a meaningful name and fill the fields:</li></ol>',2)),i(s,{sharedStateKey:"id_provider"},{default:a(()=>[i(n,{label:"SAML"},{default:a(()=>[...o[2]||(o[2]=[e("p",null,"Add a new SAML 2.0 Identity Provider:",-1),e("table",null,[e("tbody",null,[e("tr",null,[e("th",null,"Option"),e("th",null,"Description")]),e("tr",null,[e("td",null,"Display name"),e("td",null,[t("An arbitrary string that is displayed on the button on the Teamscale login screen. Example: "),e("code",null,"Corporate Login")])]),e("tr",null,[e("td",null,"Service Provider ID"),e("td",null,"ID of the service provider, i.e. the Teamscale instance. This must match what you configured in your identity provider for Teamscale.")]),e("tr",null,[e("td",null,"Metadata XML"),e("td",null,"The entity descriptor metadata XML. This must also contain the identity provider’s public key as an X.509 certificate. Alternatively, you can provide a URL to download the metadata from and let Teamscale do the download.")])])],-1),e("p",null,"Most of the required information is parsed from the metadata you provide there.",-1)])]),_:1}),i(n,{label:"OpenID Connect"},{default:a(()=>[...o[3]||(o[3]=[e("p",null,"Add a new OpenID Connect connection:",-1),e("table",null,[e("tbody",null,[e("tr",null,[e("th",null,"Option"),e("th",null,"Description")]),e("tr",null,[e("td",null,"Display name for the login button"),e("td",null,[t("An arbitrary string that is displayed on the button on the Teamscale login screen. Example: "),e("code",null,"Login via Google Cloud")])]),e("tr",null,[e("td",null,"URL to the OpenID Connect provider"),e("td",null,[t("URL of the identity provider, for example "),e("code",null,"https://accounts.google.com"),t(". As a subpath of this URL, "),e("code",null,".well-known/openid-configuration"),t(" is expected to be available to be able to retrieve the endpoints. If the openid-configuration is not defined or not available, the endpoints can still be added manually.")])]),e("tr",null,[e("td",null,"URI of the authorization endpoint"),e("td",null,[t("Authorization endpoint of your identity provider. In most cases it can be extracted from the "),e("code",null,".well-known/openid-configuration"),t(' of the identity provider. If the configuration file is set up and is available for Teamscale, it can be automatically retrieved by clicking on the "Retrieve endpoints" button.')])]),e("tr",null,[e("td",null,"URI of the token endpoint"),e("td",null,[t("Token endpoint of your identity provider. In most cases it can be extracted from the "),e("code",null,".well-known/openid-configuration"),t(' of the identity provider. If the configuration file is set up and is available for Teamscale, it can be automatically retrieved by clicking on the "Retrieve endpoints" button.')])]),e("tr",null,[e("td",null,"Use end session endpoint for logout"),e("td",null,"This endpoint ensures that you log out not only from Teamscale but also from the OpenID Connect identity provider (including all services where you used it for authentication). It is not supported by all OpenID Connect identity providers, but sometimes they implement their own logout services which can be used from Teamscale as redirection target.")]),e("tr",null,[e("td",null,"URI of the end session endpoint for logout"),e("td",null,[t("End session endpoint of your identity provider. In most cases (if it is supported by the identity provider) it can be extracted from the "),e("code",null,".well-known/openid-configuration"),t('. If the configuration file is set up and is available for Teamscale, it can be automatically retrieved by clicking on the "Retrieve endpoints" button.')])]),e("tr",null,[e("td",null,"Redirect URI"),e("td",null,"This must match the URI that was configured as allowed/authorized callback/redirect URI in your identity provider for Teamscale.")]),e("tr",null,[e("td",null,"Client ID"),e("td",null,"ID of the application or client, i.e. the Teamscale instance. This must match what was generated in your identity provider for Teamscale.")]),e("tr",null,[e("td",null,"Client secret"),e("td",null,"Client secret of the service provider, i.e. the Teamscale instance. This must match what was generated in your identity provider for Teamscale.")]),e("tr",null,[e("td",null,"Username field"),e("td",null,[t("After authentication the identity provider replies with an ID token that contains information about the authenticated user. Defaults to "),e("code",null,"sub"),t(".")])])])],-1)])]),_:1})]),_:1}),o[6]||(o[6]=r(`<ol start="5"><li>For testing, you should log out. On the login screen you should see a button that allows you to sign in using the configured identity provider.</li></ol><h3 id="optional-automatic-user-creation" tabindex="-1">Optional: Automatic user creation <a class="header-anchor" href="#optional-automatic-user-creation" aria-label="Permalink to &quot;Optional: Automatic user creation&quot;">​</a></h3><p>You can configure the provider to automatically create new users after successful SAML or OpenID Connect authentication. For this, enable the option <em>Automatically create authenticated users</em> and fill out the additional fields, which describe the group to place these new users into and the SAML attributes containing aspects of the users (such as name and email address).</p><h3 id="optional-group-synchronization" tabindex="-1">Optional: Group Synchronization <a class="header-anchor" href="#optional-group-synchronization" aria-label="Permalink to &quot;Optional: Group Synchronization&quot;">​</a></h3><p>If your SAML Identity Provider supports to expose group membership as attribute, you can configure Teamscale to synchronize this group information. Note that you can not synchronize into existing groups. Instead, all groups from the SAML response will be automatically created. You can optionally filter the groups to be synchronized, if you want to focus on a subset.</p><h3 id="optional-automatic-redirection-to-the-single-sign-on-login-page" tabindex="-1">Optional: Automatic redirection to the Single sign-on login page <a class="header-anchor" href="#optional-automatic-redirection-to-the-single-sign-on-login-page" aria-label="Permalink to &quot;Optional: Automatic redirection to the Single sign-on login page&quot;">​</a></h3><p>You can configure to skip the built-in login page and automatically redirect to the login page of your GitHub, SAML or OpenID Connect authentication when opening Teamscale. For this, enable the option <em>Single sign-on (SSO) login page redirection</em> and ensure that you have <strong>exactly one</strong> SSO connection set, including the <code>Authentication</code> and <code>GitHub Integration</code> pages in the settings. If the option is enabled, you can still access the built-in login page, when you directly open it at <code>&lt;your-teamscale-url&gt;/login</code>.</p><h2 id="single-sign-on-using-an-authentication-proxy-and-bearer-token" tabindex="-1">Single sign-on using an Authentication Proxy and Bearer Token <a class="header-anchor" href="#single-sign-on-using-an-authentication-proxy-and-bearer-token" aria-label="Permalink to &quot;Single sign-on using an Authentication Proxy and Bearer Token&quot;">​</a></h2><p>This option can be used, if you already use an authentication proxy such as <a href="https://oauth2-proxy.github.io/oauth2-proxy" target="_blank" rel="noreferrer">oauth2-proxy</a>. The authentication proxy handles the authentication, creates a JWT token for successfully authenticated users and forwards them to Teamscale. In Teamscale you have to configure the public key to check the signature of the JWT token. The public key needs to be in the following JSON format:</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;kid&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Sb0vlqczKuAswnsIbWXf9fYCyHJ6VWOaHP4Zu2uHhz8&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;kty&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;RSA&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;alg&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;RS256&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;use&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;sig&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;n&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;hzhHooVkF7soIoYFFG5-pA_vCTB4YGOYWQo_aaFZ1dgmqKa5fsow8RmZhUL-bfp_W_0FgSJp5S6b4CdAW5s2566T48ZsqyoYAMnihyskuGyHUWmI8BJtmmYr8DZjZsTzk3jX3DKIC0OxtyMPnkf1lsBTWN-_R0VpgFAlPWgXTDiV4aO9L6fCCedyt4obzSwG-AMQL3t71sFErVvBJ_W1NmJtjV9CpdACtwF_rjjn_OkKDaXwiSfKm7NJKHE_56fHWWYihq15iJ7o58oVV_k073scJdK7-HRq5FwCgdxb-Hs9iUmhAujqAV_FMMq3ZCLTCgL8jBb45lgHfB66RBAQEQ&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;e&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;AQAB&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;x5c&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:[</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;MIICmTCCAYECBgGLj12/FTANBgkqhkiG9w0BAQsFADAQMQ4wDAYDVQQDDAVteWFwcDAeFw0yMzExMDIwOTI3NDdaFw0zMzExMDIwOTI5MjdaMBAxDjAMBgNVBAMMBW15YXBwMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAhzhHooVkF7soIoYFFG5+pA/vCTB4YGOYWQo/aaFZ1dgmqKa5fsow8RmZhUL+bfp/W/0FgSJp5S6b4CdAW5s2566T48ZsqyoYAMnihyskuGyHUWmI8BJtmmYr8DZjZsTzk3jX3DKIC0OxtyMPnkf1lsBTWN+/R0VpgFAlPWgXTDiV4aO9L6fCCedyt4obzSwG+AMQL3t71sFErVvBJ/W1NmJtjV9CpdACtwF/rjjn/OkKDaXwiSfKm7NJKHE/56fHWWYihq15iJ7o58oVV/k073scJdK7+HRq5FwCgdxb+Hs9iUmhAujqAV/FMMq3ZCLTCgL8jBb45lgHfB66RBAQEQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQA+Nj3BOQ5E5qVJC3NA6aH7VgM9u8XQmsKQsZKojFfNVVxJSeWR1hFjQ5dgl86YDng7VEMUqxeahyaK/43atOtFcUnjcZTLyNJHRThW9IGoyDAlHsLkIrdrEZuJ2XUVAcdMsKAeODq8GWTpL2c/xtaOrFMj7H6cI97rFJFfe4G9R/Z7XIiVzzx7XoHHi4NlJuNXaNHwvIgBSHqKF2nwynI3vFo705KQxqOgnZPmigp+/tK4Awqg27KaEKQhkl1zWOEvOFp0xYCrN0RKGe1k/93bL6HkHdTySnFXF4Li3muym7rJIj2XTo4/aA8t7ekZ0l8++oUMkcSPBPcFOOWcg8Wy&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;x5t&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;YuQvOTSez5SwoDK4WJsKd-WN_5U&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;x5t#S256&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;IQSFkWXp0a5X4aFxKitYnGvE0h2AdLfJZRyDOQ8XxYs&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>The field <em>Claim for username</em> can be used to configure which field of the token contains the username. Usually this is <em>sub</em> or <em>username</em>. The content of this field must match the username in Teamscale for successful authentication. If the Bearer token is not part of the authorization header but in a custom header field, you can list the used custom headers via <em>Additional headers</em>.</p><p>Note that authentication via Bearer Token can only be used for authentication, which means that your groups and permissions still need to be managed in Teamscale or by connecting Teamscale to your LDAP server and importing corresponding users and groups.</p>`,12))])}const T=d(p,[["render",m]]);export{A as __pageData,T as default};
