import{_ as e,h as i,ak as t,g as a}from"./chunks/framework.B7a_7emw.js";const d=JSON.parse('{"title":"Custom Check Framework","description":"","frontmatter":{},"headers":[],"relativePath":"reference/custom-checks/index.md","filePath":"reference/custom-checks/index.md"}'),n={name:"reference/custom-checks/index.md"};function l(h,s,o,c,p,r){return a(),i("div",null,[...s[0]||(s[0]=[t(`<h1 id="custom-check-framework" tabindex="-1">Custom Check Framework <a class="header-anchor" href="#custom-check-framework" aria-label="Permalink to &quot;Custom Check Framework&quot;">​</a></h1><p>Custom checks can be used to easily define rules checked by Teamscale. The Teamscale distribution already comes with over 500 built-in checks for different languages, which are built upon the same framework. Furthermore, many best-in-class linters contribute thousands of additional checks.</p><p>The »Teamscale Custom Check API« allows users to extend Teamscale by writing custom analyses that create findings. These <em>custom checks</em> are executed within Teamscale&#39;s incremental analysis engine and, thus, provide real-time feedback to developers on every commit. Consequently, Teamscale treats the findings created by custom checks equal to all other findings, such that all finding-related features, like tolerating, marking as false positive, visualizations, filtering etc., can be used just as usual.</p><p>A custom check is a <em>local</em> analysis in Teamscale, i.e. its implementation is given a single source file as an input and the check can create findings for code locations within this file. A check can use the source code of the file as plain text, the sequence of tokens or the abstract syntax tree (AST) of the file or a combination of these for its analysis. Each Teamscale distribution already contains many built-in checks, e.g., for detecting bad practices or uncovering bugs.</p><nav class="table-of-contents"><ul><li><a href="#implementing-a-custom-check">Implementing a Custom Check</a><ul><li><a href="#setting-up-the-development-environment">Setting up the Development Environment</a></li></ul></li><li><a href="#writing-a-custom-check">Writing a custom check</a></li><li><a href="#sample-custom-check">Sample Custom Check</a><ul><li><a href="#code-artifacts-in-custom-checks">Code Artifacts in Custom Checks</a></li><li><a href="#creating-findings">Creating findings</a></li></ul></li><li><a href="#testing-your-custom-check">Testing Your Custom Check</a></li><li><a href="#deploying-your-custom-check">Deploying your Custom Check</a></li><li><a href="#custom-check-api-evolution">Custom Check API Evolution</a></li></ul></nav><h2 id="implementing-a-custom-check" tabindex="-1">Implementing a Custom Check <a class="header-anchor" href="#implementing-a-custom-check" aria-label="Permalink to &quot;Implementing a Custom Check&quot;">​</a></h2><h3 id="setting-up-the-development-environment" tabindex="-1">Setting up the Development Environment <a class="header-anchor" href="#setting-up-the-development-environment" aria-label="Permalink to &quot;Setting up the Development Environment&quot;">​</a></h3><p>It is recommended to use the Eclipse development environment to implement Custom Checks. To set up a development workspace, please perform the following steps:</p><ol><li><p>Download an up-to-date version of the Eclipse IDE and unzip it.</p></li><li><p>Launch Eclipse and create a new workspace.</p></li><li><p>Download the Custom Check Example project from the following URL, create an Eclipse project as described there and import it into your Eclipse workspace.<br><a href="https://github.com/cqse/teamscale-custom-check-sample" target="_blank" rel="noreferrer">https://github.com/cqse/teamscale-custom-check-sample</a></p></li></ol><h2 id="writing-a-custom-check" tabindex="-1">Writing a custom check <a class="header-anchor" href="#writing-a-custom-check" aria-label="Permalink to &quot;Writing a custom check&quot;">​</a></h2><p>To implement a custom check, create a new Java class deriving from <code>CheckImplementationBase</code> that is annotated with <code>@Check</code> . The class CheckImplementationBase contains the analysis context (ICheckContext) which you can use to get information about the analyzed source code file. This includes the textual representation of the code, the stream of tokens in the file (the output of the scanner/lexer), as well as the abstract syntax tree (AST, output of the parser). The only method your Custom Check needs to implement (overwrite) is <code>execute()</code>.</p><p>If your check should be based on tokens, you can use methods from <code>TokenStreamUtils</code> to focus on specific tokens.</p><p>If your check requires the more structured AST, you can use methods from <code>ShallowEntityTraversalUtils</code> to filter specific AST entities.</p><p>In the <code>@Check</code> annotation you must specify meta-data about your check. This meta-data is used by Teamscale mainly for configuration of the analyses (quality profile) and the presentation of the findings your check will produce. The meta-data includes the following information:</p><ul><li><p><code>name</code>: Name of the check</p></li><li><p><code>description</code>: A description of the check that explains developers why the findings of the check are a problem and how they should fix them. You can omit this meta-data in the annotation, and provide a <code>check name.md</code> file in the /check-descriptions folder on the class path instead. This is particularly useful if the check description is long. In case the check name contains characters that are not valid in Windows file names, they have to be substituted with dashes.</p></li><li><p><code>groupName</code>: The analysis group the check should be contained in (e.g. General Checks)</p></li><li><p><code>languages</code>: The programming language(s) for which the check can be used.</p></li></ul><p>Furthermore, a Custom Check must specify on which representation of the code it performs the analyses (using the parameters-argument of Check). E.g., the check may only access the AST if the option <code>ECheckParameter.ABSTRACT_SYNTAX_TREE</code> is specified or type information will only be present if type resolution is explicitly switched on by using <code>ECheckParameter.TYPE_RESOLUTION</code>. Teamscale needs this information to cluster the checks, so that representations that are not needed are not calculated at all.</p><h2 id="sample-custom-check" tabindex="-1">Sample Custom Check <a class="header-anchor" href="#sample-custom-check" aria-label="Permalink to &quot;Sample Custom Check&quot;">​</a></h2><p>The following code listing shows a simple Custom Check:</p><div class="language-java vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">java</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">@</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Check</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">name</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> =</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;Abstract types should not have constructors (CA1012)&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    groupName</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> =</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;Language misuse&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    languages</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> =</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> { ELanguage.CS }, </span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    parameters</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> =</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> { ECheckParameter.ABSTRACT_SYNTAX_TREE })</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">public</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> class</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> AbstractTypesShouldNotHaveConstructorsCheck</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> extends</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> CheckImplementationBase</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> {</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	@</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Override</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">	public</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> void</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> execute</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">throws</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> CheckException {</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		List&lt;</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">ShallowEntity</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt; rootEntities </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> context.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">getAbstractSyntaxTree</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">getCodeViewOption</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">());</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		List&lt;</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">ShallowEntity</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt; types </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> ShallowEntityTraversalUtils.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">listEntitiesOfType</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(rootEntities,</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">				EShallowEntityType.TYPE);</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">		for</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> (ShallowEntity type </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">:</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> types) {</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">			if</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> (TokenStreamUtils.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">contains</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(type.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">ownStartTokens</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(), ETokenType.PUBLIC)</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">					&amp;&amp;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> TokenStreamUtils.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">contains</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(type.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">ownStartTokens</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(), ETokenType.ABSTRACT)) {</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">				analyzeMethodsInType</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(type);</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			}</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		}</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	}</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">	/**</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">	 * Analyzes the top-level methods that are public constructors in the given</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">	 * type. Since constructors can&#39;t be nested in other methods, we don&#39;t need to</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">	 * look inside other methods.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">	 */</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">	private</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> void</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> analyzeMethodsInType</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(ShallowEntity </span><span style="--shiki-light:#E36209;--shiki-dark:#FFAB70;">type</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">) {</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		List&lt;</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">ShallowEntity</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt; topLevelMethods </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> ShallowEntityTraversalUtils</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">				.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">listMethodsNonRecursive</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(Collections.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">singletonList</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(type));</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">		for</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> (ShallowEntity topLevelMethod </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">:</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> topLevelMethods) {</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">			if</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> (topLevelMethod.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">getSubtype</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">().</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">equals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(SubTypeNames.CONSTRUCTOR)</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">					&amp;&amp;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> TokenStreamUtils.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">contains</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(type.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">ownStartTokens</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(), ETokenType.PUBLIC)) {</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">				buildFinding</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;An \`abstract\` type should not have a \`public\` constructor&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">						buildLocation</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">().</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">forEntity</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(topLevelMethod)).</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">createAndStore</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">();</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			}</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		}</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	}</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>The description can be provided adding the file <code>check-descriptions/Abstract types should not have constructors (CA1012).md</code> to the classpath:</p><div class="language-markdown vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">markdown</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">Constructors on abstract types can be called only by derived types.</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">Because public constructors create instances of a type, and you cannot create instances of an abstract type, an abstract type that has a public constructor is incorrectly designed.</span></span></code></pre></div><h3 id="code-artifacts-in-custom-checks" tabindex="-1">Code Artifacts in Custom Checks <a class="header-anchor" href="#code-artifacts-in-custom-checks" aria-label="Permalink to &quot;Code Artifacts in Custom Checks&quot;">​</a></h3><h4 id="text" tabindex="-1">Text <a class="header-anchor" href="#text" aria-label="Permalink to &quot;Text&quot;">​</a></h4><p>Some custom checks are do not require deep information on the code but can be based simply on the file text. For example a &quot;code does not contain emojis&quot; check would just take the file text and check whether any char in the text is an emoji unicode char. In your <code>execute()</code> method, you can obtain the text with <code>context.getTextContent(ETextViewOption.FILTERED_CONTENT)</code>.</p><h4 id="tokens" tabindex="-1">Tokens <a class="header-anchor" href="#tokens" aria-label="Permalink to &quot;Tokens&quot;">​</a></h4><p>The next level of structuring is tokens. Teamscale scans the code and generates tokens (e.g., for keywords and identifiers in the code). For languages like <code>C++</code>, we also run a C preprocessor. You can obtain the tokens with <code>context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED)</code>.</p><p>The most important information in tokens is their type (<code>getType()</code>, for example <code>IDENTIFIER</code>), their text (<code>getText()</code>), and their position in the code (line number, char offset). Common methods for handling tokens are implemented in <code>TokenStreamUtils</code> and <code>TokenStreamTextUtils</code>.</p><h4 id="abstract-syntax-tree-shallow-entities" tabindex="-1">Abstract Syntax Tree (&quot;Shallow Entities&quot;) <a class="header-anchor" href="#abstract-syntax-tree-shallow-entities" aria-label="Permalink to &quot;Abstract Syntax Tree (&quot;Shallow Entities&quot;)&quot;">​</a></h4><p>The AST consists of so-called shallow entities. These entities are the nodes of the AST (e.g., types or methods). They are called shallow because the AST is only shallow in the sense that it is constructed down to the statement level but does not have detailed information on expressions within statements. You can obtain the shallow entities with <code>context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED)</code>.</p><p>The most important information in a shallow entity are</p><ul><li>its type (<code>getType()</code>, for example <code>METHOD</code>)</li><li>its subtype (<code>getSubtype</code>, for example <code>&quot;CONSTRUCTOR&quot;</code>)</li><li>its children entities (<code>getChildren()</code>)</li><li>and tokens (e.g., <code>ownStartTokens()</code>).</li></ul><p>Common methods for selecting specific shallow entities to be analyzed are implemented in <code>ShallowEntityTraversalUtils</code>.</p><h3 id="creating-findings" tabindex="-1">Creating findings <a class="header-anchor" href="#creating-findings" aria-label="Permalink to &quot;Creating findings&quot;">​</a></h3><p>If your custom check found a code pattern that should be marked in the UI, you have to create a finding. A finding needs at least a message and a location (file path and char offset). The <code>buildFinding()</code> method in <code>CheckImplementationBase</code> implements a builder pattern that makes sure all required information is given. For example, if your check identifies that a token <code>myToken</code> needs to get a finding, then you could call it like this:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>buildFinding(&quot;Token is bad&quot;, buildLocation().forToken(myToken)).createAndStore();</span></span></code></pre></div><h2 id="testing-your-custom-check" tabindex="-1">Testing Your Custom Check <a class="header-anchor" href="#testing-your-custom-check" aria-label="Permalink to &quot;Testing Your Custom Check&quot;">​</a></h2><p>The Teamscale Custom Check Framework provides a Unit-Testing framework you should use to write tests for your checks. The easiest way to test your check is using data-driven tests. This way you do not have to write any test code but only provide test data in terms of code listings that contain the findings your check should identify and a file describing the expected results. To define a data-driven test you need to perform the following steps:</p><ol><li><p>Create a new subfolder within the <code>src/test/resources</code> folder using the class name of your custom check class as the folder name (e.g., <code>MyCheck</code>)</p></li><li><p>Place a test code file (e.g., <code>MyTestClass.java</code>) to test your check against in the newly created folder.</p></li><li><p>Create a second file in the same folder and use the same name followed by <code>.expected</code>, e.g., <code>MyTestClass.java.expected</code>. This file will be used to compare the findings detected by your check with the expected findings. For every finding your check should emit, put a line into this file using the following format: Offsets <code>&lt;fromOffset&gt;-&lt;toOffset&gt;</code> (lines <code>&lt;fromLine&gt;-&lt;toLine&gt;</code>): <code>&lt;findingMessage&gt;</code> The offsets here are character offsets in the source code. Please specify the following information corresponding to your src/test/resources file: fromOffset/toOffset: Offsets to the tokens the finding should be annotated. fromLine/toLine: The line number that should be marked with a finding of your check. findingMessage: The message that should be displayed for your finding.</p></li><li><p>To be able to execute the tests, you need to create a single test class deriving from <code>CheckTestBase</code> that will automatically create a test suite from the test data (this class is already available in the <code>src/test/java</code> folder of Custom Check Example project):</p><div class="language-java vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">java</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">/** Main class for testing checks */</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">@</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">RunWith</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(Parameterized.class)</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">public</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> class</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> CheckTest</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> extends</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> CheckTestBase</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> {</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">  /** Constructor. */</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">  public</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> CheckTest</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(File </span><span style="--shiki-light:#E36209;--shiki-dark:#FFAB70;">referenceFile</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, Map&lt;</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">String</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">CheckInfo</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt; </span><span style="--shiki-light:#E36209;--shiki-dark:#FFAB70;">checkInfoBySimpleClassName</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">) {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    super</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(referenceFile, checkInfoBySimpleClassName);</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  }</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">  /** Generate Test Parameters. */</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  @</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Parameters</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">name</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> =</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;{0}&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">)</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">  public</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> static</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> Collection&lt;</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Object</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">[]&gt; </span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">generateParameters</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">throws</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> IOException {</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    return</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> CheckTestBase.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">generateParameters</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">new</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> CheckTest</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">null</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">null</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">));</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div></li><li><p>To run the tests, launch the test class as a JUnit-Test in Eclipse and inspect the results (information about the actual results of your check are written to the directory <code>test-tmp</code>).</p></li></ol><h2 id="deploying-your-custom-check" tabindex="-1">Deploying your Custom Check <a class="header-anchor" href="#deploying-your-custom-check" aria-label="Permalink to &quot;Deploying your Custom Check&quot;">​</a></h2><ol><li>Package your custom check into a JAR file using the JAR Export Wizard of Eclipse. You do not need to re-package any of the included libraries. The check classes are sufficient.</li><li>Add Your Custom Check to Teamscale <ul><li>On-Premise Installations: Place the JAR file in the <code>custom-checks</code> subfolder of your Teamscale installation. The location of this folder can be customized in <a href="./../../reference/administration-ts-installation/#primary-settings-teamscale-properties">teamscale.properties</a>.</li><li>Cloud Installations: To add a custom check to a cloud instance, please contact our support team at <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a>. They will handle the process of uploading and configuring it for you.</li></ul></li></ol><div class="warning custom-block"><p class="custom-block-title">Custom Phases</p><p>If a check uses a custom phase (see <code>eu.cqse.check.framework.core.Check::phases</code>) with a custom data class, the class/package must be registered so that Teamscale can (de)serialize it for later usage by the check. For this, set the system property <code>com.teamscale.io.allowed-packages</code> to a comma-separated list of allowed packages. Note that some classes will never be (de)serialized by Teamscale due to <a href="https://github.com/frohoff/ysoserial" target="_blank" rel="noreferrer">security concerns</a>.</p></div><ol start="3"><li>Restart Teamscale. The checks become available when configuring analysis profiles.</li></ol><h2 id="custom-check-api-evolution" tabindex="-1">Custom Check API Evolution <a class="header-anchor" href="#custom-check-api-evolution" aria-label="Permalink to &quot;Custom Check API Evolution&quot;">​</a></h2><p>The custom check API and thus any custom check binaries are compatible between patch releases (e.g., 5.6.0 and 5.6.1). However, when updating to a new feature release (e.g., 5.6.x to 5.7.x) a rebuild of your custom checks against the latest customer check API is recommended.</p>`,44)])])}const u=e(n,[["render",l]]);export{d as __pageData,u as default};
