This check detects code snippets that are very similar on a syntactic level. 
Such snippets are called 'code clones' and are typically created using copy & paste (and possibly modify).
The other instances of a clone are called 'siblings'.

This analysis ignores empty lines, whitespace or comments.
It also normalizes variables or types that have been renamed.
In the default configuration a clone is detected when it is at least 10 statements long ("minimal clone length").
<ADDITIONAL_INFO>
# Why is This a Problem?

Code clones are a problem for two related but distinct reasons:

1. **Increased Maintenance Effort**:
Clones unnecessarily increase the amount of program code and thus raise the efforts needed for program comprehension and quality assurance activities.
Any changes, including bug fixes, that affect a clone usually have to be propagated to all of its copies.
Localizing and modifying these copies creates significant overhead.

2. **Inconsistent Clones**:
If changes to a clone are *not* propagated to all of its siblings, the resulting inconsistencies can lead to non-uniform behavior or errors.
Often, developers do not even know that a piece of code has been copied elsewhere.
This makes duplicated code more error-prone.
Studies show that nearly every second unintentionally inconsistent change to a clone leads to a fault.

# How Can I Resolve This?

The best strategy for removing a given clone depends on the context.
Most programming languages provide abstraction mechanisms that allow developers to reuse existing functionality.
Typical solutions are 
* the extraction of utility methods, 
* introduction of common base classes, or
* application of code generators. 
 
For some clones, removal is too complex or needs too much effort.
A typical example is very hardware near code where it is difficult to introduce suitable abstractions.
In those cases, the clone information should be preserved to ease propagation of changes to all instances of the clone.

# Where Can I Learn More?

## References

* [Teamscale Documentation: What Makes Maintainable Code? - Redundancy](https://docs.teamscale.com/introduction/understanding-the-maintainability-of-your-code-base/#redundancy)
* [CQSE Software Quality Blog: Practical Guide to Code Clones](https://www.cqse.eu/de/news/blog/practical-guide-to-code-clones-part1/)
* [Fanta, Richard, and Václav Rajlich. "Removing clones from the code." Journal of Software Maintenance: Research and Practice 11.4 (1999): 223-243.](https://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.65.6604&rep=rep1&type=pdf)
* [Juergens, Elmar, et al. "Do code clones matter?." 2009 IEEE 31st International Conference on Software Engineering. IEEE, 2009.](https://www.cqse.eu/fileadmin/content/news/publications/2009-do-code-clones-matter.pdf)
* [Juergens, Elmar, and Florian Deissenboeck. "How much is a clone." Proceedings of the 4th International Workshop on Software Quality and Maintainability. 2010.](https://www.cqse.eu/fileadmin/content/news/publications/2010-how-much-is-a-clone.pdf)
