<h2>Why is this an issue?</h2>
<p>After an <code>await</code>ed <code>Task</code> has executed, you can continue execution in the original, calling thread or any arbitrary thread.
Unless the rest of the code needs the context from which the <code>Task</code> was spawned, <code>Task.ConfigureAwait(false)</code> should be used to
keep execution in the <code>Task</code> thread to avoid the need for context switching and the possibility of deadlocks.</p>
<p>This rule raises an issue when code in a class library targeting .Net Framework <code>await</code>s a <code>Task</code> and continues execution in
the original calling thread.</p>
<p>The rule does not raise for .Net Core libraries as there is no <code>SynchronizationContext</code> in .Net Core.</p>
<h3>Noncompliant code example</h3>
<pre>
var response = await httpClient.GetAsync(url);  // Noncompliant
</pre>
<h3>Compliant solution</h3>
<pre>
var response = await httpClient.GetAsync(url).ConfigureAwait(false);
</pre>

