<h2>Why is this an issue?</h2>
<p>In C#, the <a
href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/language-specification/statements#13106-the-throw-statement">throw</a>
statement can be used in two different ways:</p>
<ul>
  <li> by specifying an expression </li>
  <li> without specifying an expression </li>
</ul>
<h3>By specifying an expression</h3>
<p>In the software development context, an expression is a value or anything that executes and ends up being a value. The expression shall be
implicitly convertible to <code>System.Exception</code>, and the result of evaluating the expression is converted to <code>System.Exception</code>
before being thrown.</p>
<pre>
try
{
}
catch(Exception exception)
{
  // code that uses the exception
  throw exception; // The exception stack trace is cleared up to this point.
}
</pre>
<p>In this case, the <a href="https://en.wikipedia.org/wiki/Stack_trace">stack trace</a>, will be cleared, losing the list of method calls between the
original method that threw the exception and the current method.</p>
<h3>Without specifying an expression</h3>
<p>This syntax is supported only in a <code>catch</code> block, in which case, that statement re-throws the exception currently being handled by that
<code>catch</code> block, preserving the stack trace.</p>
<pre>
try
{
}
catch(Exception exception)
{
  // code that uses the exception
  throw; // The stack trace of the initial exception is preserved.
}
</pre>
<h3>Exceptions</h3>
<p>It is allowed using the thrown <code>exception</code> as an argument and wrapping it in another <code>exception</code>.</p>
<pre>
try
{
}
catch(Exception exception)
{
  throw new Exception("Additional information", exception);
}
</pre>
<h2>How to fix it</h2>
<p>The recommended way to re-throw an exception is to use the throw statement without including an expression. This ensures that all call stack
information is preserved when the exception is propagated to the caller, making debugging easier.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
try
{
}
catch(Exception exception)
{
  throw exception;
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
try
{
}
catch(Exception)
{
  throw;
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.exception#re-throwing-an-exception">Re-throwing an exception</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/language-specification/statements#13106-the-throw-statement">The
  throw statement</a> </li>
  <li> <a href="https://en.wikipedia.org/wiki/Stack_trace">stack trace</a> </li>
</ul>

