<h2>Why is this an issue?</h2>
<p>In most logging frameworks, it’s good practice to set the logger name to match its enclosing type, as enforced by {rule:csharpsquid:S3416}.</p>
<p>Logging frameworks can define or use <a href="https://learn.microsoft.com/en-us/dotnet/standard/generics/interfaces">Generic interfaces</a> for the
logger, such as <a
href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.extensions.logging.ilogger-1"><code>ILogger&lt;TCategoryName&gt;</code></a>.</p>
<p>The use of a logger of a generic type parameter <code>A</code> (e.g. <code>ILogger&lt;A&gt;</code>) in a type different than <code>A</code>, say
<code>B</code>, goes against the convention.</p>
<p>Because the instance of type <code>A</code> would log with a logger named after <code>B</code>, log items would appear as if they were logged by
<code>B</code> instead, resulting in confusion and logging misconfiguration:</p>
<ul>
  <li> overriding defaults for the logger named after <code>A</code> would not take effect for entries logged in the type <code>A</code> </li>
  <li> fine-graned logging configuration would not be possible, since there would be no way to distinguish entries logged in the type <code>A</code>
  from entries logged in the type <code>B</code> </li>
</ul>
<p>Further details and examples are provided in {rule:csharpsquid:S3416}.</p>
<p>This rule specifically targets the generic logging interface <a
href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.extensions.logging.ilogger-1"><code>ILogger&lt;TCategoryName&gt;</code> Interface</a>
defined by <a href="https://learn.microsoft.com/en-us/dotnet/core/extensions/logging">Microsoft Extensions Logging</a>.</p>
<h2>How to fix it</h2>
<p>Change the generic type parameter of the <code>ILogger</code> interface to match the enclosing type.</p>
<h3>Noncompliant code example</h3>
<pre data-diff-id="1" data-diff-type="noncompliant">
class EnclosingType
{
    public EnclosingType(ILogger&lt;AnotherType&gt; logger) // Noncompliant
    {
        // ...
    }
}
</pre>
<h3>Compliant solution</h3>
<pre data-diff-id="1" data-diff-type="compliant">
class EnclosingType
{
    public EnclosingType(ILogger&lt;EnclosingType&gt; logger) // Compliant
    {
        // ...
    }
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/core/diagnostics/logging-tracing">.NET logging and tracing</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/standard/generics/interfaces">Generic interface</a> </li>
  <li> Microsoft Learn - <a
  href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.extensions.logging.ilogger-1"><code>ILogger&lt;TCategoryName&gt;</code> Interface</a>
  </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/core/extensions/logging?tabs=command-line#log-category">Logging in C# and
  .NET - Log category</a> </li>
</ul>

