﻿## SA1025

<table>
<tr>
  <td>TypeName</td>
  <td>SA1025CodeMustNotContainMultipleWhitespaceInARow</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1025</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

The code contains multiple whitespace characters in a row.

## Rule description

A violation of this rule occurs whenever the code contains multiple whitespace characters in a row, unless the
characters come at the beginning or end of a line of code, following a comma or semicolon or preceding a symbol.

## How to fix violations

To fix a violation of this rule, remove the extra whitespace characters are leave only a single space.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1025:CodeMustNotContainMultipleWhitespaceInARow", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1025 // CodeMustNotContainMultipleWhitespaceInARow
#pragma warning restore SA1025 // CodeMustNotContainMultipleWhitespaceInARow
```
