﻿## SA1213

<table>
<tr>
  <td>TypeName</td>
  <td>SA1213EventAccessorsMustFollowOrder</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1213</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

An add accessor appears after a remove accessor within an event.

## Rule description

A violation of this rule occurs when an add accessor is placed after a remove accessor within an event. To comply with this rule, the add accessor should appear before the remove accessor.

For example, the following code would raise an instance of this violation:

```csharp
public event EventHandler NameChanged
{ 
    remove { this.nameChanged -= value; }
    add { this.nameChanged += value; }
}
```

The code below would not raise this violation:

```csharp
public event EventHandler NameChanged
{ 
    add { this.nameChanged += value; }
    remove { this.nameChanged -= value; }
}
```

## How to fix violations

To fix an instance of this violation, place the add accessor before the remove accessor.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1213:EventAccessorsMustFollowOrder", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1213 // EventAccessorsMustFollowOrder
#pragma warning restore SA1213 // EventAccessorsMustFollowOrder
```
