<h2>Why is this an issue?</h2>
<p>An empty method is generally considered bad practice and can lead to confusion, readability, and maintenance issues. Empty methods bring no
functionality and are misleading to others as they might think the method implementation fulfills a specific and identified requirement.</p>
<p>There are several reasons for a method not to have a body:</p>
<ul>
  <li> It is an unintentional omission, and should be fixed to prevent an unexpected behavior in production. </li>
  <li> It is not yet, or never will be, supported. In this case an exception should be thrown. </li>
  <li> The method is an intentionally-blank override. In this case a nested comment should explain the reason for the blank override. </li>
</ul>
<h3>Exceptions</h3>
<p>This does not raise an issue in the following cases:</p>
<ul>
  <li> Non-public default (no-argument) constructors </li>
  <li> Public default (no-argument) constructors when there are other constructors in the class </li>
  <li> Empty methods in abstract classes </li>
  <li> Methods annotated with <code>@org.aspectj.lang.annotation.Pointcut()</code> </li>
</ul>

```java
public abstract class Animal {
  void speak() {  // default implementation ignored
  }
}
```
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public void shouldNotBeEmpty() {  // Noncompliant - method is empty
}

public void notImplemented() {  // Noncompliant - method is empty
}

@Override
public void emptyOnPurpose() {  // Noncompliant - method is empty
}
```
<h4>Compliant solution</h4>

```java
public void doSomething() {
  doSomething();
}

public void notImplemented() {
  throw new UnsupportedOperationException("notImplemented() cannot be performed because ...");
}

@Override
public void emptyOnPurpose() {
  // comment explaining why the method is empty
}
```