<h2>Why is this an issue?</h2>
<p>A <code>for</code> loop termination condition should test the loop counter against an invariant value that does not change during the execution of
the loop. Invariant termination conditions make the program logic easier to understand and maintain.</p>
<p>This rule tracks three types of non-invariant termination conditions:</p>
<ul>
  <li> When the loop counters are updated in the body of the <code>for</code> loop </li>
  <li> When the termination condition depends on a method call </li>
  <li> When the termination condition depends on an object property since such properties could change during the execution of the loop. </li>
</ul>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>Make the termination condition invariant by using a constant or a local variable instead of an expression that could change during the execution of
the loop.</p>

```java
for (int i = 0; i < foo(); i++) { // Noncompliant, "foo()" is not an invariant
  // ...
}
```
<h4>Compliant solution</h4>

```java
int end = foo();
for (int i = 0; i < end; i++) { // Compliant, "end" does not change during loop execution
  // ...
}
```
<h4>Noncompliant code example</h4>
<p>If this is impossible and the counter variable must be updated in the loop’s body, use a <code>while</code> or <code>do</code> <code>while</code>
loop instead of a <code>for</code> loop.</p>

```java
for (int i = 0; i < 10; i++) {
  // ...
  if (condition) i++; // Noncompliant, i is updated from within body
  // ...
}
```
<h4>Compliant solution</h4>

```java
int i = 0;
while (i++ < 10) { // Compliant
  // ...
  if (condition) sum++;
  // ...
}
```