<h2>Why is this an issue?</h2>
<p>Comparisons of dissimilar types will always return false. The comparison and all its dependent code can simply be removed. This includes:</p>
<ul>
  <li> comparing an object with null </li>
  <li> comparing an object with an unrelated primitive (E.G. a string with an int) </li>
  <li> comparing unrelated classes </li>
  <li> comparing an unrelated <code>class</code> and <code>interface</code> </li>
  <li> comparing unrelated <code>interface</code> types </li>
  <li> comparing an array to a non-array </li>
  <li> comparing two arrays </li>
</ul>
<p>Specifically in the case of arrays, since arrays don’t override <code>Object.equals()</code>, calling <code>equals</code> on two arrays is the same
as comparing their addresses. This means that <code>array1.equals(array2)</code> is equivalent to <code>array1==array2</code>.</p>
<p>However, some developers might expect <code>Array.equals(Object obj)</code> to do more than a simple memory address comparison, comparing for
instance the size and content of the two arrays. Instead, the <code>==</code> operator or <code>Arrays.equals(array1, array2)</code> should always be
used with arrays.</p>
<h3>Noncompliant code example</h3>

```java
interface KitchenTool { ... };
interface Plant {...}

public class Spatula implements KitchenTool { ... }
public class Tree implements Plant { ...}
//...

Spatula spatula = new Spatula();
KitchenTool tool = spatula;
KitchenTool [] tools = {tool};

Tree tree = new Tree();
Plant plant = tree;
Tree [] trees = {tree};


if (spatula.equals(tree)) { // Noncompliant; unrelated classes
  // ...
}
else if (spatula.equals(plant)) { // Noncompliant; unrelated class and interface
  // ...
}
else if (tool.equals(plant)) { // Noncompliant; unrelated interfaces
  // ...
}
else if (tool.equals(tools)) { // Noncompliant; array & non-array
  // ...
}
else if (trees.equals(tools)) { // Noncompliant; incompatible arrays
  // ...
}
else if (tree.equals(null)) { // Noncompliant
  // ...
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/5zdGBQ">CERT, EXP02-J.</a> - Do not use the Object.equals() method to compare two arrays </li>
</ul>