<h2>Why is this an issue?</h2>
<p><code>HttpSession</code> s are managed by web servers and can be serialized and stored on disk as the server manages its memory use in a process
called "passivation" (and later restored during "activation").</p>
<p>Even though <code>HttpSession</code> does not extend <code>Serializable</code>, you must nonetheless assume that it will be serialized. If
non-serializable objects are stored in the session, serialization might fail.</p>
<h3>Noncompliant code example</h3>

```java
public class Address {
  //...
}

HttpSession session = request.getSession();
session.setAttribute("address", new Address());  // Noncompliant; Address isn't serializable
```
<h3>Compliant solution</h3>

```java
public class Address implements Serializable {
  //...
}

HttpSession session = request.getSession();
session.setAttribute("address", new Address());
```
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A04_2021-Insecure_Design/">Top 10 2021 Category A4 - Insecure Design</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/579">CWE-579 - J2EE Bad Practices: Non-serializable Object Stored in Session</a> </li>
</ul>