<h2>Why is this an issue?</h2>
<p>There’s no reason to use literal boolean values or nulls in assertions. Instead of using them with <em>assertEquals</em>, <em>assertNotEquals</em>
and similar methods, you should be using <em>assertTrue</em>, <em>assertFalse</em>, <em>assertNull</em> or <em>assertNotNull</em> instead (or
<em>isNull</em> etc. when using Fest). Using them with assertions unrelated to equality (such as <em>assertNull</em>) is most likely a bug.</p>
<p>Supported frameworks:</p>
<ul>
  <li> JUnit3 </li>
  <li> JUnit4 </li>
  <li> JUnit5 </li>
  <li> Fest assert </li>
</ul>
<h3>Noncompliant code example</h3>

```java
Assert.assertTrue(true);  // Noncompliant
assertThat(null).isNull(); // Noncompliant

assertEquals(true, something()); // Noncompliant
assertNotEquals(null, something()); // Noncompliant
```
<h3>Compliant solution</h3>

```java
assertTrue(something());
assertNotNull(something());
```