<h2>Why is this an issue?</h2>
<p>According to the Java documentation, any implementation of the <code>InputSteam.read()</code> method is supposed to read the next byte of data from
the input stream. The value byte must be an <code>int</code> in the range 0 to 255. If no byte is available because the end of the stream has been
reached, the value -1 is returned.</p>
<p>But in Java, the <code>byte</code> primitive data type is an 8-bit signed two’s complement integer. It has a minimum value of -128 and a maximum
value of 127. So by contract, the implementation of an <code>InputSteam.read()</code> method should never directly return a <code>byte</code>
primitive data type. A conversion into an unsigned byte must be done before by applying a bitmask.</p>
<h3>Noncompliant code example</h3>

```java
@Override
public int read() throws IOException {
  if (pos == buffer.length()) {
    return -1;
  }
  return buffer.getByte(pos++); // Noncompliant, a signed byte value is returned
}
```
<h3>Compliant solution</h3>

```java
@Override
public int read() throws IOException {
  if (pos == buffer.length()) {
    return -1;
  }
  return buffer.getByte(pos++) & 0xFF; // The 0xFF bitmask is applied
}
```