<h2>Why is this an issue?</h2>
<p>As mentioned in JUnit5 documentation, it is possible to integrate JUnit4 with JUnit5:</p>
<blockquote>
  <p>JUnit provides a gentle migration path via a JUnit Vintage test engine which allows existing tests based on JUnit 3 and JUnit 4 to be executed
  using the JUnit Platform infrastructure. Since all classes and annotations specific to JUnit Jupiter reside under a new org.junit.jupiter base
  package, having both JUnit 4 and JUnit Jupiter in the classpath does not lead to any conflicts.</p>
</blockquote>
<p>However, maintaining both systems is a temporary solution. This rule flags all the annotations from JUnit4 which would need to be migrated to
JUnit5, hence helping migration of a project.</p>
<p>Here is the list of JUnit4 annotations tracked by the rule, with their corresponding annotations in JUnit5:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>JUnit4</th>
      <th>JUnit5</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p><code>org.junit.Test</code></p></td>
      <td><p><code>org.junit.jupiter.api.Test</code></p></td>
    </tr>
    <tr>
      <td><p><code>org.junit.Before</code></p></td>
      <td><p><code>org.junit.jupiter.api.BeforeEach</code></p></td>
    </tr>
    <tr>
      <td><p><code>org.junit.After</code></p></td>
      <td><p><code>org.junit.jupiter.api.AfterEach</code></p></td>
    </tr>
    <tr>
      <td><p><code>org.junit.BeforeClass</code></p></td>
      <td><p><code>org.junit.jupiter.api.BeforeAll</code></p></td>
    </tr>
    <tr>
      <td><p><code>org.junit.AfterClass</code></p></td>
      <td><p><code>org.junit.jupiter.api.AfterAll</code></p></td>
    </tr>
    <tr>
      <td><p><code>org.junit.Ignore</code></p></td>
      <td><p><code>org.junit.jupiter.api.Disabled</code></p></td>
    </tr>
  </tbody>
</table>
<p>Note that the following annotations might requires some rework of the tests to have JUnit5 equivalent behavior. A simple replacement of the
annotation won’t work immediately:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>JUnit4</th>
      <th>JUnit5</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p><code>org.junit.experimental.categories.Category</code></p></td>
      <td><p><code>org.junit.jupiter.api.Tag</code></p></td>
    </tr>
    <tr>
      <td><p><code>org.junit.Rule</code></p></td>
      <td><p><code>org.junit.jupiter.api.extension.ExtendWith</code></p></td>
    </tr>
    <tr>
      <td><p><code>org.junit.ClassRule</code></p></td>
      <td><p><code>org.junit.jupiter.api.extension.RegisterExtension</code></p></td>
    </tr>
    <tr>
      <td><p><code>org.junit.runner.RunWith</code></p></td>
      <td><p><code>org.junit.jupiter.api.extension.ExtendWith</code></p></td>
    </tr>
  </tbody>
</table>
<h3>Noncompliant code example</h3>

```java
package org.foo;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(MyJUnit4Runner.class)
public class MyJUnit4Test {

  @BeforeClass
  public static void beforeAll() {
    System.out.println("beforeAll");
  }

  @AfterClass
  public static void afterAll() {
    System.out.println("AfterAll");
  }

  @Before
  public void beforeEach() {
    System.out.println("beforeEach");
  }

  @After
  public void afterEach() {
    System.out.println("afterEach");
  }

  @Test
  public void test1() throws Exception {
    System.out.println("test1");
  }

  public interface SomeTests { /* category marker */ }

  @Test
  @Category(SomeTests.class)
  public void test2() throws Exception {
    System.out.println("test2");
  }

  @Test
  @Ignore("Requires fix of #42")
  public void ignored() throws Exception {
    System.out.println("ignored");
  }
}
```
<h3>Compliant solution</h3>

```java
package org.foo;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(MyJUnit5Extension.class)
class MyJUnit5Test {

  @BeforeAll
  static void beforeAll() {
    System.out.println("beforeAll");
  }

  @AfterAll
  static void afterAll() {
    System.out.println("afterAll");
  }

  @BeforeEach
  void beforeEach() {
    System.out.println("beforeEach");
  }

  @AfterEach
  void afterEach() {
    System.out.println("afterEach");
  }

  @Test
  void test1() {
    System.out.println("test1");
  }

  @Test
  @Tag("SomeTests")
  void test2() {
    System.out.println("test2");
  }

  @Test
  @Disabled("Requires fix of #42")
  void disabled() {
    System.out.println("ignored");
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://junit.org/junit5/docs/current/user-guide/#migrating-from-junit4">JUnit 5: Migrating from JUnit4</a> </li>
</ul>