<h2>Why is this an issue?</h2>
<p>Consistent naming of beans is important for the readability and maintainability of the code. More precisely, according to the Spring
documentation:</p>

```java
Naming beans consistently makes your configuration easier to read and understand. Also, if you use Spring AOP, it helps a lot when applying advice to a set of beans related by name.
```
<p>Not following accepted conventions can introduce inconsistent naming, especially when multiple developers work on the same project, leading to
technical debt.</p>
<p>The spring documentation establishes a naming convention that consists of camel-cased names with a leading lowercase letter.</p>
<p>This rule raises an issue when a bean name defined in one of the following annotations does not adhere to the naming convention:</p>
<ul>
  <li> <code>@Bean</code> </li>
  <li> <code>@Configuration</code> </li>
  <li> <code>@Controller</code> </li>
  <li> <code>@Component</code> </li>
  <li> <code>@Qualifier</code> </li>
  <li> <code>@Repository</code> </li>
  <li> <code>@Service</code> </li>
</ul>
<h2>How to fix it</h2>
<p>Change the bean’s name to adhere to the naming conventions. Names should be camel-cased and start with a lowercase letter, for example,
<code>myBean</code>.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
@Bean(name = "MyBean") // Noncompliant, the first letter of the name should be lowercase
public MyBean myBean() {
    ...
```
<h4>Compliant solution</h4>

```java
@Bean(name = "myBean") // Compliant
public MyBean myBean() {
    ...
```
<h4>Noncompliant code example</h4>

```java
@Service("my_service") // Noncompliant, the name should be camel-cased
public class MyService {
    ...
```
<h4>Compliant solution</h4>

```java
@Service("myService") // Compliant
public class MyService {
    ...
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Spring Framework Documentation - <a href="https://docs.spring.io/spring-framework/reference/core/beans/definition.html#beans-beanname">3.3 Bean
  overview</a> </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> Java Guides - <a href="https://www.javaguides.net/2019/03/spring-boot-best-practices.html">Spring Boot Best Practices</a> </li>
</ul>