<h2>Why is this an issue?</h2>
<p>Nested code - blocks of code inside blocks of code - is eventually necessary, but increases complexity. This is why keeping the code as flat as
possible, by avoiding unnecessary nesting, is considered a good practice.</p>
<p>Merging <code>if</code> statements when possible will decrease the nesting of the code and improve its readability.</p>
<p>Code like</p>

```js
if (x != undefined) {
  if (y === 2) {
    // ...
  }
}
```
<p>Will be more readable as</p>

```js
if (x != undefined && y === 2) {
  // ...
}
```
<h2>How to fix it</h2>
<p>If merging the conditions seems to result in a more complex code, extracting the condition or part of it in a named function or variable is a
better approach to fix readability.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
if (file != undefined) {
  if (file.isFile() || file.isDirectory()) {        // Noncompliant
    /* ... */
  }
}
```
<h4>Compliant solution</h4>

```js
function isFileOrDirectory(File file) {
  return file.isFile() || file.isDirectory();
}

/* ... */

if (file. != undefined && isFileOrDirectory(file)) { // Compliant
  /* ... */
}
```