<h2>Why is this an issue?</h2>
<p>HTML &lt;table&gt; elements should not be used for layout purposes as it can confuse screen readers. It is recommended to use CSS instead.</p>
<p>This rule raises an issue on every <code>&lt;table&gt;</code> element containing a <code>role</code> attribute set to <code>"presentation"</code>
or <code>"none"</code>, which is how <a href="https://www.w3.org/WAI/tutorials/tables/tips/">W3C recommends</a> marks layout tables.</p>
<h3>Noncompliant code example</h3>

```js
<table role="presentation"><!-- Noncompliant -->
<!-- ... -->
</table>
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Learn/HTML/Introduction_to_HTML/Document_and_website_structure">Document and website
  structure</a> </li>
</ul>