<h2>Why is this an issue?</h2>
<p><code>switch</code> statements are useful when there are many different cases depending on the value of the same expression.</p>
<p>For just one or two cases, however, the code will be more readable with <code>if</code> statements.</p>
<h3>Noncompliant code example</h3>

```php
switch ($variable) {
  case 0:
    do_something();
    break;
  default:
    do_something_else();
    break;
}
```
<h3>Compliant solution</h3>

```php
if ($variable == 0) {
  do_something();
} else {
  do_something_else();
}
```