<p>Interactive elements being focusable is vital for website accessibility. It enables users, including those using assistive technologies, to
interact effectively with the website. Without this, some users may be unable to access certain features, leading to a poor user experience and
potential non-compliance with accessibility standards.</p>
<h2>Why is this an issue?</h2>
<p>Lack of focusability can hinder navigation and interaction with the website, resulting in an exclusionary user experience and possible violation of
accessibility guidelines.</p>
<h2>How to fix it</h2>
<p>Ensure that all interactive elements on your website can receive focus. This can be achieved by using standard HTML interactive elements, or by
assigning a <code>tabindex</code> attribute of "0" to custom interactive components.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
<!-- Element with mouse/keyboard handler has no tabindex -->
<span onclick="submitForm();" role="button">Submit</span>

<!-- Anchor element without href is not focusable -->
<a onclick="showNextPage();" role="button">Next page</a>
```
<h4>Compliant solution</h4>

```ts
<!-- Element with mouse handler has tabIndex -->
<span onClick="doSomething();" tabIndex="0" role="button">Submit</span>

<!-- Focusable anchor with mouse handler -->
<a href="javascript:void(0);" onClick="doSomething();"> Next page </a>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/WCAG20-TECHS/H4.html">Creating a logical tab order through links, form controls, and objects</a> </li>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-practices-1.1/#kbd_generalnav">Fundamental Keyboard Navigation Conventions</a> </li>
  <li> MDN - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/button_role#accessibility_concerns">ARIA: button role -
  Accessibility concerns</a> </li>
</ul>