<h2>Why is this an issue?</h2>
<p>The use of increment and decrement operators in method calls or in combination with other arithmetic operators is not recommended, because:</p>
<ul>
  <li> It can significantly impair the readability of the code. </li>
  <li> It introduces additional side effects into a statement, with the potential for undefined behavior. </li>
  <li> It is safer to use these operators in isolation from any other arithmetic operators. </li>
</ul>
<h3>Noncompliant code example</h3>

```ts
u8a = ++u8b + u8c--;
foo = bar++ / 4;
```
<h3>Compliant solution</h3>
<p>The following sequence is clearer and therefore safer:</p>

```ts
++u8b;
u8a = u8b + u8c;
u8c--;
foo = bar / 4;
bar++;
```