/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.simulink.builder.MDLSection;
import org.conqat.lib.simulink.builder.MDLSectionBase;

class MutableMDLSection
extends MDLSectionBase {
    private MutableMDLSection parentSection;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final ListMap<String, MutableMDLSection> subSections = new ListMap();
    private String currentParameter = null;

    public MutableMDLSection(String name, int lineNumber) {
        super(name, lineNumber);
    }

    public String getCurrentParameter() {
        return this.currentParameter;
    }

    public void setCurrentParameter(String currentParameter) {
        this.currentParameter = currentParameter;
    }

    public void resetCurrentParameter() {
        this.currentParameter = null;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void appendParameter(String name, String value) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, value);
        } else {
            String currentValue = this.parameters.get(name);
            this.parameters.put(name, currentValue + value);
        }
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public MutableMDLSection getFirstSubSection(String name) {
        List collection = (List)this.subSections.getCollection((Object)name);
        if (collection != null) {
            return (MutableMDLSection)collection.get(0);
        }
        return null;
    }

    public ListMap<String, MutableMDLSection> getSubSections() {
        return this.subSections;
    }

    public List<MutableMDLSection> getSubSections(String name) {
        return (List)this.subSections.getCollection((Object)name);
    }

    public void addSubSection(MutableMDLSection subSection) {
        subSection.parentSection = this;
        this.subSections.add((Object)subSection.getName(), (Object)subSection);
    }

    public void addSubSections(List<MutableMDLSection> subSections) {
        for (MutableMDLSection subSection : subSections) {
            this.addSubSection(subSection);
        }
    }

    public MutableMDLSection getParentSection() {
        return this.parentSection;
    }

    public void removeSection(MutableMDLSection subSection) {
        this.subSections.remove((Object)subSection.getName(), (Object)subSection);
    }

    @Override
    public String toString() {
        return "MDLSectionContainer [name=" + this.getName() + ", lineNumber=" + this.getLineNumber() + ", parameters=" + String.valueOf(this.parameters) + "]";
    }

    public MDLSection asImmutable() {
        ArrayList<MDLSection> subSections = new ArrayList<MDLSection>();
        for (MutableMDLSection containerSubSection : (List)this.subSections.getValues()) {
            subSections.add(containerSubSection.asImmutable());
        }
        return new MDLSection(this.getName(), subSections, (PairList<String, String>)new PairList(this.parameters), this.getLineNumber());
    }
}

