/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public class ParameterizedElement {
    private final Map<String, String> parameters = new HashMap<String, String>();

    protected ParameterizedElement() {
    }

    protected ParameterizedElement(ParameterizedElement other) {
        this.copyFrom(other);
    }

    public String getDeclaredParameter(String name) {
        return this.parameters.get(name);
    }

    public UnmodifiableSet<String> getDeclaredParameterNames() {
        return CollectionUtils.asUnmodifiable(this.parameters.keySet());
    }

    public @Nullable String getParameter(String parameter, String subParameter) {
        return this.getParameter(parameter + "." + subParameter);
    }

    public @Nullable String getParameter(String name) {
        String value = this.parameters.get(name);
        if (value != null) {
            return value;
        }
        return this.getDefaultParameter(name);
    }

    public String getParameterIgnoreCase(String name) {
        CaseInsensitiveStringSet parameters = new CaseInsensitiveStringSet(this.getParameterNames());
        if (parameters.contains((Object)name)) {
            return this.getParameter(parameters.get(name));
        }
        return null;
    }

    public String getParameterUnescapeNewLineChars(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            return StringUtils.unescapeChars((String)value, (Map)StringUtils.ESCAPE_NEWLINE);
        }
        return null;
    }

    public UnmodifiableSet<String> getParameterNames() {
        if (this.getDefaultParameterNames().isEmpty()) {
            return CollectionUtils.asUnmodifiable(this.parameters.keySet());
        }
        HashSet<String> parametersNames = new HashSet<String>(this.getDefaultParameterNames());
        parametersNames.addAll(this.parameters.keySet());
        return CollectionUtils.asUnmodifiable(parametersNames);
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    String getDefaultParameter(String name) {
        return null;
    }

    Set<String> getDefaultParameterNames() {
        return CollectionUtils.emptySet();
    }

    private void copyFrom(ParameterizedElement other) {
        this.parameters.putAll(other.parameters);
    }
}

