/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.model.ReferencedBlockInfo;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkFunctionConnector;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.datahandler.BlockLayoutData;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkBlockNameUtils;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.SimulinkBusUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkBlock
extends SimulinkElementBase {
    private final Map<String, SimulinkBlock> subBlocks = new LinkedHashMap<String, SimulinkBlock>();
    private final Map<String, SimulinkInPort> inPorts = new HashMap<String, SimulinkInPort>();
    private final Map<String, SimulinkOutPort> outPorts = new HashMap<String, SimulinkOutPort>();
    private final Set<SimulinkAnnotation> annotations = new IdentityHashSet();
    private final Set<SimulinkLine> containedLines = new IdentityHashSet();
    private final Set<SimulinkFunctionConnector> functionConnectors = new IdentityHashSet();
    private static final Set<String> PARAMETER_NAMES_WHICH_MUST_NOT_BE_LOADED_FROM_REFERENCED_BLOCK = Set.of("Name", "Position", "Parameter", "SourceBlock", "LibraryVersion", "SourceProductBaseCode");
    private static final SimulinkBlock UNRESOLVABLE_REFERENCE_MARKER = new SimulinkBlock();
    private SimulinkBlock resolvedReferencedBlock = null;

    public SimulinkBlock() {
    }

    public SimulinkBlock(SimulinkBlock other) {
        super(other);
        this.subBlocks.putAll(other.subBlocks);
        this.inPorts.putAll(other.inPorts);
        this.outPorts.putAll(other.outPorts);
        this.annotations.addAll(other.annotations);
        this.containedLines.addAll(other.containedLines);
        this.functionConnectors.addAll(other.functionConnectors);
        this.resolvedReferencedBlock = null;
    }

    public void addAnnotation(SimulinkAnnotation annotation) {
        this.annotations.add(annotation);
        annotation.setParent(this);
    }

    public void addFunctionConnector(SimulinkFunctionConnector functionConnector) {
        this.functionConnectors.add(functionConnector);
        functionConnector.setParent(this);
    }

    public void addSubBlock(SimulinkBlock subBlock) {
        CCSMAssert.isTrue((subBlock.getParent() == null ? 1 : 0) != 0, (String)"May not add block which already has a parent!");
        subBlock.setParent(this);
        CCSMAssert.isFalse((boolean)this.subBlocks.containsKey(subBlock.getName()), (String)("Block already has a sub block called: " + subBlock.getName()));
        this.subBlocks.put(subBlock.getName(), subBlock);
    }

    public UnmodifiableSet<SimulinkAnnotation> getAnnotations() {
        return CollectionUtils.asUnmodifiable(this.annotations);
    }

    public UnmodifiableSet<SimulinkFunctionConnector> getFunctionConnectors() {
        return CollectionUtils.asUnmodifiable(this.functionConnectors);
    }

    public List<SimulinkLine> getInLines() {
        ArrayList<SimulinkLine> inLines = new ArrayList<SimulinkLine>();
        for (SimulinkInPort inPort : this.getInPorts()) {
            if (inPort.getLine() == null) continue;
            inLines.add(inPort.getLine());
        }
        return inLines;
    }

    public SimulinkInPort getInPort(String portIndex) {
        return this.inPorts.get(portIndex);
    }

    public UnmodifiableCollection<SimulinkInPort> getInPorts() {
        return CollectionUtils.asUnmodifiable(this.inPorts.values());
    }

    public Collection<SimulinkLine> getOutLines() {
        ArrayList<SimulinkLine> outLines = new ArrayList<SimulinkLine>();
        for (SimulinkOutPort outPort : this.outPorts.values()) {
            outLines.addAll((Collection<SimulinkLine>)outPort.getLines());
        }
        return outLines;
    }

    public SimulinkOutPort getOutPort(String portIndex) {
        return this.outPorts.get(portIndex);
    }

    public UnmodifiableCollection<SimulinkOutPort> getOutPorts() {
        return CollectionUtils.asUnmodifiable(this.outPorts.values());
    }

    public UnmodifiableCollection<SimulinkLine> getContainedLines() {
        return CollectionUtils.asUnmodifiable(this.containedLines);
    }

    public Collection<SimulinkLine> getContainedLinesRecursively(boolean includeInvisible, boolean includeInCommentedBlock) {
        ArrayList<SimulinkLine> lines = new ArrayList<SimulinkLine>(this.containedLines);
        for (SimulinkBlock subBlock : this.subBlocks.values()) {
            if (!includeInCommentedBlock && SimulinkUtils.isCommentedBlock(subBlock)) continue;
            lines.addAll(subBlock.getContainedLinesRecursively(includeInvisible, includeInCommentedBlock));
        }
        if (!includeInvisible) {
            return CollectionUtils.filter(lines, SimulinkUtils::isUserVisible);
        }
        return lines;
    }

    public String getResolvedType() {
        String sourceType;
        String type = this.getType();
        if ("Reference".equals(type) && !StringUtils.isEmpty((String)(sourceType = this.getSourceType()))) {
            return "Reference." + sourceType;
        }
        return type;
    }

    public String getContainingModelId() {
        SimulinkBlock parent = this.getParent();
        if (parent == null) {
            return this.getId();
        }
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent.getId();
    }

    @SimulinkTestExclude
    public ReferencedBlockInfo getReferencedBlockInfo() {
        if (this.isOfType("ModelReference")) {
            return this.getReferencedInfoForModelReferenceBlock();
        }
        Object sourceBlock = null;
        if (this.isOfType("Reference")) {
            sourceBlock = this.getSourceBlockName();
        } else if (this.isOfType("SubSystem")) {
            String referencedSubsystem = this.getParameter("ReferencedSubsystem");
            if (referencedSubsystem != null && !referencedSubsystem.isEmpty()) {
                return new ReferencedBlockInfo(referencedSubsystem, "", this.getModel().getModelDataHandler(), true);
            }
            sourceBlock = this.getParameter("AncestorBlock");
        }
        if (sourceBlock != null && !((String)sourceBlock).isEmpty()) {
            String rootId = this.getContainingModelId();
            String fileName = ((String)sourceBlock).split("/")[0];
            if ("$bdroot".equals(fileName) && !fileName.equals(rootId)) {
                sourceBlock = rootId + StringUtils.stripPrefix((String)sourceBlock, (String)fileName);
                fileName = rootId;
            }
            return new ReferencedBlockInfo(fileName, (String)sourceBlock, this.getModel().getModelDataHandler());
        }
        return null;
    }

    private ReferencedBlockInfo getReferencedInfoForModelReferenceBlock() {
        String modelName = this.getParameter("ModelNameDialog");
        if (modelName == null) {
            modelName = this.getParameter("ModelName");
        }
        if (modelName != null) {
            String blockName = StringUtils.removeLastPart((String)modelName, (char)'.');
            return new ReferencedBlockInfo(modelName, blockName, this.getModel().getModelDataHandler());
        }
        return null;
    }

    public SimulinkBlock getSubBlock(String name) {
        return this.subBlocks.get(name);
    }

    public SimulinkBlock getSubBlockWithWhitespaceNormalization(String name) {
        SimulinkBlock block = this.subBlocks.get(name);
        if (block != null) {
            return block;
        }
        name = SimulinkBlock.normalizeWhitespace(name);
        for (SimulinkBlock subBlock : this.getSubBlocks()) {
            if (!name.equals(SimulinkBlock.normalizeWhitespace(subBlock.getName()))) continue;
            return subBlock;
        }
        return null;
    }

    private static String normalizeWhitespace(String name) {
        return StringUtils.removeWhitespace((String)SimulinkBlock.replaceNewlines(name));
    }

    public SimulinkBlock getSubBlockBySID(String sid) {
        CCSMAssert.isNotNull((Object)sid);
        for (Map.Entry<String, SimulinkBlock> entry : this.subBlocks.entrySet()) {
            SimulinkBlock subBlock = entry.getValue();
            String subBlockSID = subBlock.getParameter("SID");
            if (!sid.equals(subBlockSID)) continue;
            return subBlock;
        }
        return null;
    }

    public UnmodifiableCollection<SimulinkBlock> getSubBlocks() {
        return CollectionUtils.asUnmodifiable(this.subBlocks.values());
    }

    public String getType() {
        return this.getDeclaredParameter("BlockType");
    }

    public boolean isOfType(String type) {
        if (type == null) {
            return false;
        }
        return type.equals(this.getType());
    }

    public boolean isOfTypeOrReferenceToBlockOfType(@Nullable String type) {
        if (type == null) {
            return false;
        }
        if (!type.equals("Reference") && this.getType().equals("Reference")) {
            Optional<SimulinkBlock> referencedBlock = this.resolveReferencedBlock();
            if (referencedBlock.isEmpty()) {
                return false;
            }
            return type.equals(referencedBlock.get().getType());
        }
        return type.equals(this.getType());
    }

    public String getSourceType() {
        return this.getDeclaredParameter("SourceType");
    }

    public String getStateflowBlockType() {
        return this.getDeclaredParameter("SFBlockType");
    }

    public boolean isOfSourceType(String type) {
        if (type == null) {
            return false;
        }
        return type.equals(this.getSourceType());
    }

    public String getSourceBlockName() {
        return this.getDeclaredParameter("SourceBlock");
    }

    public boolean hasSubBlocks() {
        return !this.subBlocks.isEmpty();
    }

    public SimulinkBlock hasSubBlockOfType(String type) {
        for (SimulinkBlock block : this.subBlocks.values()) {
            if (!block.getType().equals(type)) continue;
            return block;
        }
        return null;
    }

    public boolean hasSubBlockOfSourceType(String sourceType) {
        for (SimulinkBlock block : this.subBlocks.values()) {
            if (!block.getSourceType().equals(sourceType)) continue;
            return true;
        }
        return false;
    }

    public boolean isStateflowChartBlock() {
        return this instanceof StateflowBlock && "Chart".equals(this.getParameter("SFBlockType"));
    }

    @Override
    public void remove() {
        for (SimulinkBlock subBlock : new ArrayList<SimulinkBlock>(this.subBlocks.values())) {
            subBlock.remove();
        }
        for (SimulinkOutPort outPort : new ArrayList<SimulinkOutPort>((Collection<SimulinkOutPort>)this.getOutPorts())) {
            outPort.remove();
        }
        for (SimulinkInPort inPort : new ArrayList<SimulinkInPort>((Collection<SimulinkInPort>)this.getInPorts())) {
            inPort.remove();
        }
        for (SimulinkAnnotation annotation : new ArrayList<SimulinkAnnotation>(this.annotations)) {
            annotation.remove();
        }
        super.remove();
    }

    public void detach() {
        super.remove();
    }

    @Override
    public String toString() {
        return this.getId() + " [" + this.getType() + ", " + this.inPorts.size() + ":" + this.outPorts.size() + "]";
    }

    void addInPort(SimulinkInPort inPort) throws AssertionError {
        CCSMAssert.isTrue((inPort.getBlock() == this ? 1 : 0) != 0, (String)"Port does not belong to block.");
        CCSMAssert.isFalse((boolean)this.inPorts.containsKey(inPort.getIndex()), (String)("Port with index " + inPort.getIndex() + " already defined."));
        this.inPorts.put(inPort.getIndex(), inPort);
    }

    void addOutPort(SimulinkOutPort outPort) throws AssertionError {
        CCSMAssert.isTrue((outPort.getBlock() == this ? 1 : 0) != 0, (String)"Port does not belong to block.");
        CCSMAssert.isFalse((boolean)this.outPorts.containsKey(outPort.getIndex()), (String)("Port with index " + outPort.getIndex() + " already defined."));
        this.outPorts.put(outPort.getIndex(), outPort);
    }

    @Override
    public String getDefaultParameter(String name) {
        return this.getModel().getTypeBlockDefaultParameter(this.getType(), name);
    }

    @Override
    Set<String> getDefaultParameterNames() {
        return this.getModel().getBlockDefaultParameterNames(this.getType());
    }

    public Optional<SimulinkObject> getFunctionPort() {
        return this.getObjects().stream().filter(object -> "FunctionPort".equals(object.getParameter("Name"))).findFirst();
    }

    @Override
    protected void removeElement(SimulinkElementBase element) {
        if (element instanceof SimulinkAnnotation) {
            this.annotations.remove(element);
        } else if (element instanceof SimulinkBlock) {
            this.subBlocks.remove(element.getName());
        } else {
            super.removeElement(element);
        }
    }

    void removeInPort(SimulinkInPort inPort) {
        CCSMAssert.isTrue((boolean)this.inPorts.containsValue(inPort), (String)"Port does not belong to this block!");
        this.inPorts.remove(inPort.getIndex());
    }

    void removeOutPort(SimulinkOutPort outPort) {
        CCSMAssert.isTrue((boolean)this.outPorts.containsValue(outPort), (String)"Port does not belong to this block!");
        this.outPorts.remove(outPort.getIndex());
    }

    @Override
    public void setParent(SimulinkElementBase parent) {
        CCSMAssert.isTrue((boolean)(parent instanceof SimulinkBlock), (String)"Blocks may only be attached to other blocks!");
        super.setParent(parent);
    }

    @Override
    public SimulinkBlock getParent() {
        return (SimulinkBlock)super.getParent();
    }

    void addLine(SimulinkLine line) {
        CCSMAssert.isFalse((boolean)this.containedLines.contains(line), (String)"Line is already contained in this block.");
        CCSMAssert.isTrue((line.getContainer() == this ? 1 : 0) != 0, (String)"Line's container does not match.");
        this.containedLines.add(line);
    }

    void removeLine(SimulinkLine line) {
        CCSMAssert.isTrue((boolean)this.containedLines.contains(line), (String)"Line is not contained in this block.");
        this.containedLines.remove(line);
    }

    @SimulinkTestExclude
    public BlockLayoutData obtainBlockLayoutData() {
        return this.getModel().getModelDataHandler().getSimulinkLayoutHandler().obtainBlockLayoutData(this);
    }

    @SimulinkTestExclude
    public LabelLayoutData obtainLabelLayoutData() {
        return SimulinkLayoutHandler.obtainBlockLabelData(this);
    }

    @SimulinkTestExclude
    public LabelLayoutData obtainSubLabelData() {
        return SimulinkLayoutHandler.obtainBlockSubLabelData(this);
    }

    @SimulinkTestExclude
    public LabelLayoutData obtainInnerLabelData() {
        return SimulinkLayoutHandler.obtainBlockInnerLabelData(this);
    }

    @SimulinkTestExclude
    public String formatSignalName(String signalName) {
        return this.getModel().getModelDataHandler().getSimulinkLayoutHandler().formatSignalName(signalName);
    }

    public static String replaceNewlines(String blockName) {
        return blockName.replace("\\n", " ");
    }

    public boolean hasDefaultName() {
        return SimulinkBlockNameUtils.hasDefaultName(this);
    }

    boolean hasVisibleName(boolean isHideAutomaticNamesByDefault) {
        String parameterShowName = this.getParameter("ShowName");
        if ("off".equals(parameterShowName)) {
            return false;
        }
        String parameterHideAutomaticName = this.getParameter("HideAutomaticName");
        if ("off".equals(parameterHideAutomaticName)) {
            return true;
        }
        return !isHideAutomaticNamesByDefault || !this.hasDefaultName();
    }

    public boolean hasVisibleName() {
        String hideAutomaticNames = this.getModel().getParameter("HideAutomaticNames");
        return this.hasVisibleName("on".equals(hideAutomaticNames));
    }

    public String buildQualifiedName() {
        Optional<StateflowState> linkedStateflowState = this.findLinkedStateflowState();
        if (linkedStateflowState.isPresent()) {
            return linkedStateflowState.get().buildQualifiedName();
        }
        SimulinkBlock parent = this.getParent();
        String localName = this.getName();
        if (parent != null) {
            return parent.getId() + "/" + SimulinkUtils.escapeSlashes(localName);
        }
        return SimulinkUtils.escapeSlashes(localName);
    }

    private Optional<StateflowState> findLinkedStateflowState() {
        if (this.getParent() != null && this.getParent().isStateflowChartBlock()) {
            StateflowState associatedStateflowState = ((StateflowBlock)this.getParent()).getChart().findChildStateAssociatedToSimulinkName(this.getName());
            return Optional.ofNullable(associatedStateflowState);
        }
        return Optional.empty();
    }

    public String getSystemSectionParameter(String name) {
        return this.getParameter("System." + name);
    }

    public String getNamePretty() {
        return SimulinkBlock.replaceNewlines(this.getName());
    }

    public String getNameForLabel() {
        if (SimulinkBusUtils.isBusElementPort(this)) {
            String portName = this.getParameterUnescapeNewLineChars("InterfaceData.PortName");
            String blockName = this.getParameterUnescapeNewLineChars("InterfaceData.Element");
            return portName + "." + blockName;
        }
        return this.getNameUnescapeNewLineChars();
    }

    @Override
    public @Nullable String getParameter(String name) {
        if (!SimulinkUtils.isLibraryReferenceBlock(this)) {
            return super.getParameter(name);
        }
        if (PARAMETER_NAMES_WHICH_MUST_NOT_BE_LOADED_FROM_REFERENCED_BLOCK.contains(name)) {
            return super.getParameter(name);
        }
        String valueDeclaredInReferenceBlock = this.getDeclaredParameter(name);
        if (valueDeclaredInReferenceBlock != null) {
            return valueDeclaredInReferenceBlock;
        }
        Optional<SimulinkBlock> referencedBlock = this.resolveReferencedBlock();
        if (referencedBlock.isEmpty()) {
            return super.getParameter(name);
        }
        return referencedBlock.get().getParameter(name);
    }

    public Optional<SimulinkBlock> resolveReferencedBlock() {
        if (this.resolvedReferencedBlock != null) {
            if (this.resolvedReferencedBlock == UNRESOLVABLE_REFERENCE_MARKER) {
                return Optional.empty();
            }
            return Optional.of(this.resolvedReferencedBlock);
        }
        if (!SimulinkUtils.isLibraryReferenceBlock(this)) {
            this.resolvedReferencedBlock = UNRESOLVABLE_REFERENCE_MARKER;
            return Optional.empty();
        }
        String sourceBlock = this.getSourceBlockName();
        String sourceModelName = StringUtils.getFirstPart((String)sourceBlock, (char)'/');
        Optional<SimulinkModel> sourceModel = this.getModel().resolveModel(sourceModelName);
        if (sourceModel.isEmpty()) {
            this.resolvedReferencedBlock = UNRESOLVABLE_REFERENCE_MARKER;
            return Optional.empty();
        }
        SimulinkBlock referencedBlock = sourceModel.get().getBlock(sourceBlock);
        if (referencedBlock == null) {
            this.resolvedReferencedBlock = UNRESOLVABLE_REFERENCE_MARKER;
            return Optional.empty();
        }
        this.resolvedReferencedBlock = referencedBlock;
        return Optional.of(referencedBlock);
    }
}

