/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.builder.SimulinkModelWorkspace;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkVersions;
import org.conqat.lib.simulink.model.block_type_default_parameter_values.SimulinkBlockDefaultParameterValueStorage;
import org.conqat.lib.simulink.model.datahandler.FontData;
import org.conqat.lib.simulink.model.datahandler.GotoFromResolver;
import org.conqat.lib.simulink.model.datahandler.LayoutHandlerBase;
import org.conqat.lib.simulink.model.datahandler.ModelDataHandler;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkModel
extends SimulinkBlock {
    private final TwoDimHashMap<String, String, String> blockTypeDefaultParams = new TwoDimHashMap();
    private final HashMap<String, String> blockDefaultParams = new HashMap();
    private final HashMap<String, String> annotationDefaultsParams = new HashMap();
    private final HashMap<String, String> lineDefaultParams = new HashMap();
    private final HashMap<String, String> factoryDefaultParams = new HashMap();
    private final boolean library;
    private final boolean subsystem;
    public final SimulinkModelWorkspace modelWorkspace;
    private StateflowMachine stateflowMachine;
    private final Map<String, BufferedImage> imageMap = new HashMap<String, BufferedImage>();
    private final Map<String, String> textMap = new HashMap<String, String>();
    private final String originId;
    private final ModelDataHandler dataHandler;
    private GotoFromResolver gotoFromResolver;
    private final Function<String, SimulinkModel> modelResolver;
    private final String uniformPath;

    public SimulinkModel(boolean isLibrary, String originId, ModelDataHandler dataHandler) {
        this(isLibrary, originId, dataHandler, x -> null);
    }

    public SimulinkModel(boolean isLibrary, String originId, ModelDataHandler dataHandler, Function<String, SimulinkModel> modelResolver) {
        this(isLibrary, false, originId, dataHandler, null, modelResolver, SimulinkModelWorkspace.EMPTY_MODEL_WORKSPACE);
    }

    public SimulinkModel(boolean isLibrary, boolean isSubsystem, String originId, ModelDataHandler dataHandler, String uniformPath, Function<String, SimulinkModel> modelResolver, SimulinkModelWorkspace modelWorkspace) {
        this.library = isLibrary;
        this.subsystem = isSubsystem;
        this.originId = originId;
        this.dataHandler = dataHandler;
        this.modelResolver = modelResolver;
        this.uniformPath = uniformPath;
        this.modelWorkspace = modelWorkspace;
        this.insertDefaults();
    }

    public SimulinkModel(SimulinkModel other, String parentBlockId, String discardedPrefix) {
        super(other);
        this.getSubBlocks().forEach(subBlock -> subBlock.overrideParent(this));
        this.dataHandler = new ModelDataHandler(other.dataHandler, parentBlockId, discardedPrefix);
        this.library = other.library;
        this.subsystem = other.subsystem;
        this.originId = other.originId;
        this.modelResolver = other.modelResolver;
        this.uniformPath = other.uniformPath;
        this.gotoFromResolver = other.gotoFromResolver;
        this.blockTypeDefaultParams.putAll(other.blockTypeDefaultParams);
        this.blockDefaultParams.putAll(other.blockDefaultParams);
        this.annotationDefaultsParams.putAll(other.annotationDefaultsParams);
        this.lineDefaultParams.putAll(other.lineDefaultParams);
        this.factoryDefaultParams.putAll(other.factoryDefaultParams);
        this.stateflowMachine = other.stateflowMachine;
        this.imageMap.putAll(other.imageMap);
        this.textMap.putAll(other.textMap);
        this.modelWorkspace = other.modelWorkspace;
    }

    private void insertDefaults() {
        this.setBlockTypeDefaultParameter("Goto", "TagVisibility", GotoFromResolver.ETagVisibility.LOCAL.name().toLowerCase());
        this.setBlockTypeDefaultParameter("From", "TagVisibility", GotoFromResolver.ETagVisibility.LOCAL.name().toLowerCase());
        this.setBlockTypeDefaultParameter("Inport", "Port", "1");
        this.setBlockTypeDefaultParameter("Outport", "Port", "1");
        this.setBlockTypeDefaultParameter("BusCreator", "NonVirtualBus", "off");
        this.setBlockTypeDefaultParameter("Inport", "BusOutputAsStruct", "off");
        this.setBlockTypeDefaultParameter("InportShadow", "BusOutputAsStruct", "off");
        this.setBlockTypeDefaultParameter("UnitDelay", "SampleTime", "-1");
        this.setBlockTypeDefaultParameter("Gain", "SampleTime", "-1");
        this.setBlockTypeDefaultParameter("SubSystem", "ShowPortLabels", "FromPortIcon");
        this.setBlockTypeDefaultParameter("Reference", "ShowPortLabels", "FromPortIcon");
        this.setBlockTypeDefaultParameter("Constant", "Value", "1");
        this.setBlockTypeDefaultParameter("Step", "Before", "0");
        this.setBlockTypeDefaultParameter("Step", "After", "1");
    }

    public void setAnnotationDefaultParameter(String name, String value) {
        this.annotationDefaultsParams.put(name, value);
    }

    public void setBlockDefaultParameter(String name, String value) {
        this.blockDefaultParams.put(name, value);
    }

    public void setBlockTypeDefaultParameter(String type, String name, String value) {
        this.blockTypeDefaultParams.putValue((Object)type, (Object)name, (Object)value);
    }

    public void setLineDefaultParameter(String name, String value) {
        this.lineDefaultParams.put(name, value);
    }

    public void setModelFactoryDefaultParameter(String name, String value) {
        this.factoryDefaultParams.put(name, value);
    }

    public String getOriginId() {
        return this.originId;
    }

    @Override
    public String getName() {
        if (this.originId != null) {
            return this.originId;
        }
        return super.getName();
    }

    @Override
    public String getNameUnescapeNewLineChars() {
        if (this.originId != null) {
            return StringUtils.unescapeChars((String)this.originId, (Map)StringUtils.ESCAPE_NEWLINE);
        }
        return super.getNameUnescapeNewLineChars();
    }

    public String getAnnotationDefaultParameter(String name) {
        String value = this.annotationDefaultsParams.get(name);
        if (value == null) {
            return this.factoryDefaultParams.get(name);
        }
        return value;
    }

    public UnmodifiableSet<String> getAnnotationDefaultParameterNames() {
        return CollectionUtils.asUnmodifiable(this.annotationDefaultsParams.keySet());
    }

    public SimulinkBlock getBlock(String id) {
        List<String> names = SimulinkUtils.splitSimulinkId(id);
        if (names.isEmpty() || !names.get(0).equals(this.getName())) {
            return null;
        }
        SimulinkBlock block = this;
        for (int i = 1; i < names.size(); ++i) {
            if ((block = block.getSubBlock(names.get(i))) != null) continue;
            return null;
        }
        return block;
    }

    public String getBlockDefaultParameter(String name) {
        String value = this.blockDefaultParams.get(name);
        if (value == null) {
            return this.factoryDefaultParams.get(name);
        }
        return value;
    }

    public String getTypeBlockDefaultParameter(String type, String name) {
        String matlabReleaseVersion = this.getModel().getDeclaredParameter("MatlabReleaseVersion");
        if (SimulinkBlockDefaultParameterValueStorage.isDefaultParameterValuesAvailable(matlabReleaseVersion)) {
            String value = SimulinkBlockDefaultParameterValueStorage.getDefaultParameterValue(type, name, matlabReleaseVersion);
            if (value == null) {
                return this.getBlockDefaultParameter(name);
            }
            return value;
        }
        String value = (String)this.blockTypeDefaultParams.getValue((Object)type, (Object)name);
        if (value == null) {
            return this.getBlockDefaultParameter(name);
        }
        return value;
    }

    public UnmodifiableSet<String> getBlockDefaultParameterNames() {
        return CollectionUtils.asUnmodifiable(this.blockDefaultParams.keySet());
    }

    public Set<String> getBlockDefaultParameterNames(String type) {
        HashSet<String> parameterNames = new HashSet<String>();
        parameterNames.addAll(this.blockTypeDefaultParams.getSecondKeys((Object)type));
        parameterNames.addAll(this.blockDefaultParams.keySet());
        return parameterNames;
    }

    @Override
    public String getId() {
        return SimulinkUtils.escapeSlashes(this.getName());
    }

    public String getLineDefaultParameter(String name) {
        String value = this.lineDefaultParams.get(name);
        if (value != null) {
            return value;
        }
        if (name.equals("FontSize")) {
            return "9";
        }
        return this.factoryDefaultParams.get(name);
    }

    public UnmodifiableSet<String> getLineDefaultParameterNames() {
        return CollectionUtils.asUnmodifiable(this.lineDefaultParams.keySet());
    }

    @Override
    public SimulinkModel getModel() {
        return this;
    }

    public StateflowMachine getStateflowMachine() {
        return this.stateflowMachine;
    }

    @Override
    public String getType() {
        return "Model";
    }

    public boolean isLibraryModel() {
        return this.library;
    }

    public boolean isSubsystem() {
        return this.subsystem;
    }

    public void setStateflowMachine(StateflowMachine machine) {
        if (machine != null) {
            CCSMAssert.isTrue((this.stateflowMachine == null ? 1 : 0) != 0, (String)"This model already has a Stateflow machine.");
            CCSMAssert.isTrue((machine.getModel() == this ? 1 : 0) != 0, (String)"Can be called only for the machine that belongs to this model");
        }
        this.stateflowMachine = machine;
    }

    @Override
    public void setParent(SimulinkElementBase parent) {
        throw new UnsupportedOperationException("Models cannot have parents.");
    }

    ModelDataHandler getModelDataHandler() {
        return this.dataHandler;
    }

    @SimulinkTestExclude
    public FontData getDefaultFont() {
        return LayoutHandlerBase.extractFontData(this);
    }

    public void addResource(String path, BufferedImage image) {
        this.imageMap.put(path, image);
    }

    public BufferedImage getImage(String path) {
        return this.imageMap.get(path);
    }

    public void addText(String tag, String text) {
        this.textMap.put(tag, text);
    }

    public String getText(String tag) {
        return this.textMap.get(tag);
    }

    public UnmodifiableMap<String, String> getMatDataMap() {
        return CollectionUtils.asUnmodifiable(this.textMap);
    }

    public boolean hasDocBlock() {
        for (SimulinkBlock block : this.getSubBlocks()) {
            String blockType = block.getParameter("BlockType");
            if (!"Reference".equals(blockType) || !"DocBlock".equals(block.getSourceType())) continue;
            return true;
        }
        return false;
    }

    public Optional<String> getExternalConfigSetName() {
        if ("Data Dictionary".equals(this.getParameter("SourceLocation"))) {
            return Optional.ofNullable(this.getParameter("SourceName"));
        }
        return Optional.empty();
    }

    @SimulinkTestExclude
    public synchronized GotoFromResolver getGotoFromResolver() {
        if (this.gotoFromResolver == null) {
            this.gotoFromResolver = ModelDataHandler.createGotoFromResolver(this);
        }
        return this.gotoFromResolver;
    }

    public String getMatlabVersion() {
        String releaseName = this.getParameter("MatlabReleaseVersion");
        if (releaseName == null) {
            String simulinkVersion = this.getParameter("Version");
            releaseName = SimulinkVersions.SIMULINK_VERSION_TO_MATLAB_RELEASE.get(simulinkVersion);
        }
        return releaseName;
    }

    public Optional<SimulinkModel> resolveModel(String name) {
        return Optional.ofNullable(this.modelResolver.apply(name));
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public SimulinkModel overwriteParentBlockIdAndDiscardedPrefix(String parentBlockId, String discardedPrefix) {
        return new SimulinkModel(this, parentBlockId, discardedPrefix);
    }
}

