/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.simulink;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.datahandler.AnnotationLayoutData;
import org.conqat.lib.simulink.model.datahandler.BlockLayoutData;
import org.conqat.lib.simulink.model.datahandler.ChartLayoutData;
import org.conqat.lib.simulink.model.datahandler.EHorizontalAlignment;
import org.conqat.lib.simulink.model.datahandler.EOrientation;
import org.conqat.lib.simulink.model.datahandler.FontData;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.LayoutHandlerBase;
import org.conqat.lib.simulink.model.datahandler.LineLayoutData;
import org.conqat.lib.simulink.model.datahandler.PortLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkColorUtils;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkElementLayoutUtils;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLineLayoutUtils;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkPortLabelUtils;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkPortLayoutUtils;
import org.conqat.lib.simulink.model.datahandler.stateflow.StateflowLayoutHandler;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.util.SimulinkUtils;

public abstract class SimulinkLayoutHandler
extends LayoutHandlerBase {
    static final int LABEL_DISTANCE = 4;
    private static final Logger LOGGER = LogManager.getLogger();

    SimulinkLayoutHandler() {
    }

    public BlockLayoutData obtainBlockLayoutData(SimulinkBlock block) {
        Color foregroundColor = SimulinkColorUtils.extractColor(block, "ForegroundColor", Color.BLACK);
        Color backgroundColor = SimulinkColorUtils.extractColor(block, "BackgroundColor", Color.WHITE);
        double opacity = SimulinkLayoutHandler.setOpacityLevel(block);
        return new BlockLayoutData(SimulinkElementLayoutUtils.extractPosition(block), this.extractOrientation(block), foregroundColor, backgroundColor, opacity);
    }

    private static double setOpacityLevel(SimulinkBlock block) {
        String overridingVariant;
        String blockSourceType = block.getSourceType();
        if ("BACE_StaticAssertion".equals(blockSourceType)) {
            return 0.5;
        }
        SimulinkBlock parent = block.getParent();
        if (parent == null) {
            return 1.0;
        }
        if (parent.isOfType("SubSystem") && "on".equals(parent.getParameter("Variant")) && ((overridingVariant = parent.getParameter("OverrideUsingVariant")) == null || block.isOfType("SubSystem") && !block.getParameter("VariantControl").equals(overridingVariant))) {
            return 0.5;
        }
        return 1.0;
    }

    public AnnotationLayoutData obtainAnnotationLayoutData(SimulinkAnnotation annotation) {
        boolean borderVisible = "on".equals(annotation.getParameter("DropShadow"));
        EHorizontalAlignment horizontalAlignment = EHorizontalAlignment.parse(annotation.getParameter("HorizontalAlignment"));
        return new AnnotationLayoutData(SimulinkElementLayoutUtils.extractPosition(annotation, this.needsOldVersionAnnotationAdjustment()), SimulinkColorUtils.extractColor(annotation, "ForegroundColor", Color.BLACK), SimulinkColorUtils.extractColor(annotation, "BackgroundColor", Color.WHITE), borderVisible, horizontalAlignment);
    }

    protected boolean needsOldVersionAnnotationAdjustment() {
        return true;
    }

    protected abstract EOrientation extractOrientation(SimulinkElementBase var1);

    public PortLayoutData obtainPortLayoutData(SimulinkPortBase port) {
        BlockLayoutData blockLayoutData = port.getBlock().obtainBlockLayoutData();
        return new PortLayoutData(SimulinkPortLayoutUtils.getPortLocation(port, blockLayoutData), SimulinkPortLayoutUtils.determineDirection(port, blockLayoutData), blockLayoutData.getForegroundColor(), blockLayoutData.getOpacity());
    }

    public static LineLayoutData obtainLineLayoutData(SimulinkLine line) {
        return SimulinkLineLayoutUtils.extractLineLayoutData(line);
    }

    public static LabelLayoutData obtainLineLabelData(SimulinkLine line) {
        List<LabelLayoutData> layoutDatas = SimulinkLayoutHandler.obtainAllLineLabelData(line);
        if (layoutDatas.isEmpty()) {
            return null;
        }
        return layoutDatas.get(0);
    }

    public static List<LabelLayoutData> obtainAllLineLabelData(SimulinkLine line) {
        return SimulinkLineLayoutUtils.extractLineLabelLayoutData(line, SimulinkLayoutHandler.obtainLineLayoutData(line), SimulinkLayoutHandler.extractFontData(line));
    }

    public static LabelLayoutData obtainBlockLabelData(SimulinkBlock block) {
        return SimulinkElementLayoutUtils.extractBlockLabelData(block, block.obtainBlockLayoutData());
    }

    public static LabelLayoutData obtainBlockInnerLabelData(SimulinkBlock block) {
        return SimulinkElementLayoutUtils.extractBlockInnerLabelData(block, block.obtainBlockLayoutData());
    }

    public static LabelLayoutData obtainBlockSubLabelData(SimulinkBlock block) {
        String formatString = block.getParameter("AttributesFormatString");
        if (StringUtils.isEmpty((String)formatString)) {
            return null;
        }
        return SimulinkElementLayoutUtils.extractBlockSubLabelData(block, formatString, block.obtainBlockLayoutData());
    }

    public static LabelLayoutData obtainPortLabelData(SimulinkPortBase port) {
        return SimulinkPortLabelUtils.extractPortLabelData(port);
    }

    public LabelLayoutData obtainAnnotationLabelData(SimulinkAnnotation annotation) {
        String text = annotation.getParameter("Name");
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        text = SimulinkUtils.replaceSimulinkLineBreaks(text);
        text = text.replaceAll("\\\\\"", "\"");
        AnnotationLayoutData layoutData = this.obtainAnnotationLayoutData(annotation);
        Point position = new Point(layoutData.getPosition().x + 4, layoutData.getPosition().y + 2);
        return new LabelLayoutData(text, true, SimulinkLayoutHandler.extractFontData(annotation), position, layoutData.getForegroundColor(), 1.0);
    }

    public static ChartLayoutData obtainChartLayoutData(StateflowChart chart) {
        Rectangle chartDimensions = SimulinkLayoutHandler.getChartDimensions(chart);
        Color chartColor = SimulinkColorUtils.extractColor(chart, "chartColor", StateflowLayoutHandler.STATE_BACKGROUND_COLOR);
        Color junctionColor = SimulinkColorUtils.extractColor(chart, "junctionColor", StateflowLayoutHandler.JUNCTION_BORDER_COLOR);
        Color transitionColor = SimulinkColorUtils.extractColor(chart, "transitionColor", StateflowLayoutHandler.TRANSITION_COLOR);
        Color stateColor = SimulinkColorUtils.extractColor(chart, "stateColor", Color.BLACK);
        return new ChartLayoutData(chartDimensions, chartColor, junctionColor, transitionColor, stateColor);
    }

    private static Rectangle getChartDimensions(StateflowChart chart) {
        String dimensionsString = chart.getParameter("subviewS.pos");
        if (dimensionsString == null) {
            return null;
        }
        double[] doubleDimensions = SimulinkUtils.getDoubleParameterArray(dimensionsString);
        if (doubleDimensions.length != 4) {
            LOGGER.warn("Invalid dimension array for chart " + chart.getStateflowId() + ". Expected 4 entries!");
            return null;
        }
        int[] dimensions = new int[4];
        for (int i = 0; i < 4; ++i) {
            dimensions[i] = (int)Math.round(doubleDimensions[i]);
        }
        return new Rectangle(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
    }

    public static LabelLayoutData obtainChartLabelData(StateflowChart chart) {
        String labelString = chart.getParameter("labelString");
        if (labelString == null) {
            return null;
        }
        FontData font = LayoutHandlerBase.extractFontData(chart, true);
        Point position = new Point(10, 10);
        ChartLayoutData chartLayoutData = SimulinkLayoutHandler.obtainChartLayoutData(chart);
        position.translate(chartLayoutData.getDimensions().x, chartLayoutData.getDimensions().y);
        return new LabelLayoutData(SimulinkUtils.replaceSimulinkLineBreaks(labelString), true, font, position, Color.BLACK, 1.0);
    }

    public String formatSignalName(String signalName) {
        return "<" + signalName + ">";
    }
}

