/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.simulink;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.FlexiblePortPlacementParameters;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.datahandler.BlockLayoutData;
import org.conqat.lib.simulink.model.datahandler.EOrientation;
import org.conqat.lib.simulink.targetlink.TargetLinkUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

final class SimulinkPortLayoutUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ROUND_SUM_PRE_PORT_INSET = 13;
    public static final int PORT_SPACING_GRID = 5;
    private static final int OUTPORT_INSET = 5;
    private static final int INPORT_INSET = 15;
    private static final double FUNCTION_CALL_SPLIT_OUTPORT_SPACING_FACTOR = 0.08;

    public static Point getPortLocation(SimulinkPortBase port, BlockLayoutData blockLayout) {
        return SimulinkPortLayoutUtils.getPortLocation(port, blockLayout, null);
    }

    private static Point getPortLocation(SimulinkPortBase port, BlockLayoutData blockLayout, @Nullable Rectangle insetBlockRectangle) {
        Rectangle originalBlockRectangle = blockLayout.getPosition();
        if (insetBlockRectangle == null) {
            insetBlockRectangle = originalBlockRectangle;
        }
        EOrientation blockOrientation = blockLayout.getOrientation();
        Optional<FlexiblePortPlacementParameters> flexiblePortPlacementParameters = port.getFlexiblePortPlacementParameters();
        if (flexiblePortPlacementParameters.isPresent()) {
            return SimulinkPortLayoutUtils.computePortPositionForFlexiblePlacementParameters(insetBlockRectangle, blockOrientation, flexiblePortPlacementParameters.get());
        }
        int blockWidth = insetBlockRectangle.width;
        int blockHeight = insetBlockRectangle.height;
        if (blockOrientation.isRotated()) {
            int tmp = blockWidth;
            blockWidth = blockHeight;
            blockHeight = tmp;
        }
        int x = insetBlockRectangle.x;
        int y = SimulinkPortLayoutUtils.adjustLayoutYPosition(insetBlockRectangle.y, port, blockOrientation, originalBlockRectangle);
        Point offset = SimulinkPortLayoutUtils.determinePortOffset(port, blockWidth, blockHeight, originalBlockRectangle, blockOrientation);
        if ("1".equals(port.getIndex()) && offset.y + (y - insetBlockRectangle.y) - blockHeight / 2 > 5) {
            offset.y -= 5;
        }
        if (SimulinkPortLayoutUtils.isFlippedNormalBlock(port, blockOrientation)) {
            offset.x = blockWidth - offset.x;
        }
        if (blockOrientation.isRotated()) {
            return new Point(x + offset.y, y + offset.x);
        }
        if (offset.y % 5 == 0 && y % 5 != 0 && SimulinkPortLayoutUtils.hasSiblings(port)) {
            y = port instanceof SimulinkInPort && (port.getBlock().isOfType("BusCreator") || SimulinkPortLayoutUtils.isConnectedToBlockOfType((SimulinkInPort)port, "BusCreator")) ? SimulinkPortLayoutUtils.roundToGrid(y) : SimulinkPortLayoutUtils.roundDownToGrid(y);
        }
        if (port.getBlock().isOfType("FunctionCallSplit")) {
            --offset.y;
        }
        return new Point(x + offset.x, y + offset.y);
    }

    private static @NonNull Point computePortPositionForFlexiblePlacementParameters(Rectangle blockRectangle, EOrientation blockOrientation, FlexiblePortPlacementParameters portSchemaEntryForPort) {
        FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName adjustedSide = SimulinkPortLayoutUtils.adjustToBlockRotation(portSchemaEntryForPort.side, blockOrientation);
        int y = 0;
        switch (adjustedSide) {
            case TOP: {
                y = blockRectangle.y;
                break;
            }
            case BOTTOM: {
                y = blockRectangle.y + blockRectangle.height;
                break;
            }
            case RIGHT: 
            case LEFT: {
                y = blockRectangle.y + (2 * portSchemaEntryForPort.portIndexOnSide + 1) * (blockRectangle.height / (2 * portSchemaEntryForPort.totalNumberOfPortsOnSide));
                break;
            }
            default: {
                LOGGER.warn("Unknown EFlexiblePortPlacementSideName " + String.valueOf((Object)adjustedSide));
            }
        }
        int x = 0;
        switch (adjustedSide) {
            case TOP: 
            case BOTTOM: {
                x = SimulinkPortLayoutUtils.roundUpToGrid(blockRectangle.x + (2 * portSchemaEntryForPort.portIndexOnSide + 1) * (blockRectangle.width / (2 * portSchemaEntryForPort.totalNumberOfPortsOnSide)));
                break;
            }
            case RIGHT: {
                x = blockRectangle.x + blockRectangle.width;
                break;
            }
            case LEFT: {
                x = blockRectangle.x;
                break;
            }
            default: {
                LOGGER.warn("Unknown EFlexiblePortPlacementSideName " + String.valueOf((Object)adjustedSide));
            }
        }
        return new Point(x, y);
    }

    static FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName adjustToBlockRotation(FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName sideBeforeBlockRotation, EOrientation blockOrientation) {
        int originalSideDirection = sideBeforeBlockRotation.degreesCounterClockwiseFromLeft;
        int sideDirectionAfterBlockRotation = originalSideDirection + blockOrientation.getDirection();
        Optional<FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName> sideAfterRotation = FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName.getSideForAngle(sideDirectionAfterBlockRotation %= 360);
        if (!sideAfterRotation.isPresent()) {
            LOGGER.error("Got " + String.valueOf((Object)sideBeforeBlockRotation) + " as direction after adjusting side to block rotation.");
            return sideBeforeBlockRotation;
        }
        return sideAfterRotation.get();
    }

    private static boolean isConnectedToBlockOfType(SimulinkInPort inPort, String type) {
        SimulinkLine line = inPort.getLine();
        if (line == null) {
            return false;
        }
        SimulinkOutPort srcPort = line.getSrcPort();
        if (srcPort == null) {
            return false;
        }
        return type.contentEquals(srcPort.getBlock().getType());
    }

    private static boolean isFlippedNormalBlock(SimulinkPortBase port, EOrientation orientation) {
        return orientation.isLeftOrUp() && !port.isSpecialPort();
    }

    private static boolean hasSiblings(SimulinkPortBase port) {
        if (port.isSpecialPort() || SimulinkUtils.isRoundFunctionCallSplitBlock(port.getBlock())) {
            return false;
        }
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLayoutUtils.countNormalPorts(port.getBlock().getInPorts()) > 1;
        }
        return SimulinkPortLayoutUtils.countNormalPorts(port.getBlock().getOutPorts()) > 1;
    }

    private static int adjustLayoutYPosition(int y, SimulinkPortBase port, EOrientation orientation, Rectangle originalSize) {
        if (port.isSpecialPort()) {
            if (orientation.isRotated()) {
                return SimulinkPortLayoutUtils.roundUpToGrid(y);
            }
            if (y % 5 <= 1) {
                return y - 1 - y % 5;
            }
            return y;
        }
        int normalInPorts = SimulinkPortLayoutUtils.countNormalPorts(port.getBlock().getInPorts());
        if (port instanceof SimulinkInPort && port.getBlock().isOfType("SubSystem") && normalInPorts > 10 && originalSize.height > 300 && normalInPorts <= 25 && !port.getBlock().getOutPorts().isEmpty() && port.getBlock().getOutPorts().size() > 8) {
            return SimulinkPortLayoutUtils.roundUpToGrid(y);
        }
        if (port.getBlock().isOfType("Reference") && port.getBlock().getParameter("LibraryVersion") != null && normalInPorts == 1 && port.getBlock().getOutPorts().size() > 1) {
            return SimulinkPortLayoutUtils.roundUpToGrid(y) + 1;
        }
        if (!(port instanceof SimulinkOutPort) || SimulinkPortLayoutUtils.isNonadjustedBlockType(originalSize, port.getBlock(), false)) {
            return y;
        }
        if (orientation.isRotated()) {
            return y;
        }
        if (port.getBlock().isOfType("Sum") && port.getBlock().getParameter("LibraryVersion") != null) {
            return SimulinkPortLayoutUtils.roundUpToGrid(y) + 2;
        }
        if (normalInPorts > 1 && normalInPorts % 2 == 0 && port.getBlock().getOutPorts().size() == 1) {
            return SimulinkPortLayoutUtils.roundUpToGrid(y);
        }
        return y;
    }

    private static boolean isNonadjustedBlockType(Rectangle size, SimulinkBlock block, boolean isInput) {
        if (block.getType() == null) {
            return false;
        }
        if (isInput) {
            return false;
        }
        if (TargetLinkUtils.isTargetlinkBlock(block)) {
            switch (block.getType()) {
                case "MinMax": {
                    return true;
                }
                case "Logic": {
                    return size.height == 56;
                }
            }
            return false;
        }
        switch (block.getType()) {
            case "RelationalOperator": {
                return size.width * 2 < size.height + 5 || size.width == 30 && size.height == 36;
            }
            case "Logic": {
                if ("distinctive".equals(block.getParameter("IconShape"))) {
                    return true;
                }
                return size.width * 2 < size.height + 5 || size.width == 30 && size.height == 36;
            }
            case "Reference": 
            case "ManualSwitch": 
            case "Goto": 
            case "From": 
            case "Inport": 
            case "InportShadow": 
            case "Selector": 
            case "FunctionCallSplit": {
                return true;
            }
            case "Product": {
                return "Matrix(*)".equals(block.getParameter("Multiplication"));
            }
            case "Sum": {
                return size.width < 30;
            }
            case "SubSystem": {
                return SimulinkPortLayoutUtils.isNonAdjustedSubsystem(size, block.getInPorts().size(), block.getOutPorts().size());
            }
        }
        return size.width < 20;
    }

    private static boolean isNonAdjustedSubsystem(Rectangle size, int numInPorts, int numOutPorts) {
        if (Math.abs(2 * size.width - size.height) < 5) {
            return false;
        }
        if (numInPorts == 4 && numOutPorts == 1) {
            return true;
        }
        if (numInPorts == 2 && numOutPorts == 1 && size.width >= 2 * size.height) {
            return true;
        }
        if (Math.abs(size.width - size.height) <= 2) {
            return true;
        }
        if (Math.abs(0.85 - (double)size.height / (double)size.width) <= 0.01) {
            return true;
        }
        if (size.width == 50 && numOutPorts > 1) {
            return false;
        }
        return size.width <= size.height;
    }

    private static int roundToGrid(int value) {
        return Math.round((float)value / 5.0f) * 5;
    }

    private static int roundUpToGrid(int value) {
        if (value < 0) {
            return -SimulinkPortLayoutUtils.roundDownToGrid(-value);
        }
        return (value + 5 - 1) / 5 * 5;
    }

    private static int roundDownToGrid(int value) {
        if (value < 0) {
            return -SimulinkPortLayoutUtils.roundUpToGrid(-value);
        }
        return value / 5 * 5;
    }

    private static Point determinePortOffset(SimulinkPortBase port, int width, int height, Rectangle originalSize, EOrientation orientation) {
        String indexParam = port.getIndex();
        if (indexParam == null || !indexParam.matches("\\d+")) {
            return SimulinkPortLayoutUtils.determineSpecialPortOffset(port, width, height, orientation);
        }
        return SimulinkPortLayoutUtils.determinePortOffset(port, indexParam, width, height, originalSize);
    }

    private static Point determinePortOffset(SimulinkPortBase port, String indexParam, int width, int height, Rectangle originalSize) {
        boolean mayAdjust;
        int numPorts;
        boolean isInput = port instanceof SimulinkInPort;
        SimulinkBlock block = port.getBlock();
        int xOffset = 0;
        if (!isInput) {
            xOffset = width;
        }
        int index = Integer.parseInt(indexParam);
        if (isInput && SimulinkUtils.isRoundSum(block)) {
            return SimulinkPortLayoutUtils.roundSumGetNthPortPos(block, index, width, height);
        }
        if (!isInput && block.isOfType("FunctionCallSplit")) {
            if (SimulinkUtils.isFunctionCallSplitBlockWithReverseOutputLayout(block)) {
                index = block.getOutPorts().size() + 1 - index;
            }
            if (SimulinkUtils.isRoundFunctionCallSplitBlock(port.getBlock())) {
                return SimulinkPortLayoutUtils.determineOutPortOffsetForRoundFunctionCallSplitBlock(port, index, width, height);
            }
        }
        if (isInput && block.isOfTypeOrReferenceToBlockOfType("Sum")) {
            String portsDescription = SimulinkPortLayoutUtils.getSumInputPortsDescription(block);
            numPorts = portsDescription.length();
            index = SimulinkPortLayoutUtils.computeLogicalIndexForSumBlockPort(portsDescription, index) + 1;
        } else {
            numPorts = isInput ? SimulinkPortLayoutUtils.countNormalPorts(block.getInPorts()) : SimulinkPortLayoutUtils.countNormalPorts(block.getOutPorts());
        }
        int otherPortCount = SimulinkPortLayoutUtils.otherPortCount(port);
        boolean bl = mayAdjust = (!isInput && !port.getBlock().isOfTypeOrReferenceToBlockOfType("Sum") && (numPorts > 1 || otherPortCount % 2 == 0 && otherPortCount > 0) || isInput && numPorts > 1) && !SimulinkPortLayoutUtils.isNonadjustedBlockType(originalSize, port.getBlock(), isInput);
        if (SimulinkPortLayoutUtils.determineMustReversePortOrder(block)) {
            index = numPorts - index + 1;
        }
        return new Point(xOffset, SimulinkPortLayoutUtils.getPortYOffset(numPorts, index, height, mayAdjust, originalSize.y % 5));
    }

    private static boolean determineMustReversePortOrder(SimulinkBlock block) {
        String rotation = block.getParameter("BlockRotation");
        if ("90".equals(rotation)) {
            return true;
        }
        boolean blockHasMaskWithPhysicalRotation = "physical".equals(block.getParameter("Mask.Display.PortRotate"));
        return blockHasMaskWithPhysicalRotation && "180".equals(rotation);
    }

    private static Point determineOutPortOffsetForRoundFunctionCallSplitBlock(SimulinkPortBase port, int portIndex, int width, int height) {
        SimulinkBlock block = port.getBlock();
        if (SimulinkPortLayoutUtils.isBottomFunctionCallSplitPort(port)) {
            return new Point(width / 2, height + 5);
        }
        return new Point(width, SimulinkPortLayoutUtils.calculateFunctionCallSplitOutPortHeight(block, portIndex, height));
    }

    private static int calculateFunctionCallSplitOutPortHeight(SimulinkBlock block, int portIndex, int blockHeight) {
        boolean oddNumberOfPorts;
        int blockSideOutPorts = block.getOutPorts().size() - 1;
        double portSpacing = (double)blockHeight * 0.08;
        boolean bl = oddNumberOfPorts = blockSideOutPorts % 2 != 0;
        if (oddNumberOfPorts) {
            int middleIndex = blockSideOutPorts / 2 + 1;
            int offsetFactor = portIndex - middleIndex;
            if (offsetFactor == 0) {
                return blockHeight / 2;
            }
            return blockHeight / 2 + (int)Math.round((double)offsetFactor * portSpacing);
        }
        int middleIndex = blockSideOutPorts / 2;
        if (portIndex > middleIndex) {
            ++portIndex;
        }
        int offsetFactor = portIndex - (middleIndex + 1);
        return blockHeight / 2 + (int)Math.round((double)offsetFactor * portSpacing);
    }

    private static int otherPortCount(SimulinkPortBase port) {
        if (port instanceof SimulinkInPort) {
            return SimulinkPortLayoutUtils.countNormalPorts(port.getBlock().getOutPorts());
        }
        return SimulinkPortLayoutUtils.countNormalPorts(port.getBlock().getInPorts());
    }

    public static String getSumInputPortsDescription(SimulinkBlock block) {
        String inputs = block.getParameter("Inputs");
        if (inputs == null) {
            return "++";
        }
        try {
            int number = Integer.parseInt(inputs);
            return StringUtils.fillString((int)number, (char)'+');
        }
        catch (NumberFormatException e) {
            return inputs;
        }
    }

    private static Point determineSpecialPortOffset(SimulinkPortBase port, int width, int height, EOrientation orientation) {
        boolean first;
        int specialPortCount = 0;
        for (SimulinkInPort inPort : port.getBlock().getInPorts()) {
            if (!inPort.isSpecialPort()) continue;
            ++specialPortCount;
        }
        int y = 0;
        if (SimulinkPortLayoutUtils.isSpecialPortOnBottom(port)) {
            y = height;
        }
        if (specialPortCount <= 1) {
            return new Point((width + 1) / 2, y);
        }
        boolean bl = first = port instanceof SimulinkInPort && ((SimulinkInPort)port).isEnablePort();
        if (orientation == EOrientation.DOWN) {
            first = !first;
        }
        int distance = (int)(Math.round((double)(width - 1) / 2.0 / 5.0) * 5L);
        int offset = (width - distance + 1) / 2;
        if (orientation.isRotated() && specialPortCount > 1) {
            offset = SimulinkPortLayoutUtils.roundUpToGrid(offset);
        }
        if (first) {
            return new Point(offset, y);
        }
        return new Point(offset + distance, y);
    }

    public static boolean isSpecialPortOnBottom(SimulinkPortBase port) {
        return "alternate".equals(port.getBlock().getParameter("NamePlacement"));
    }

    private static int getPortYOffset(int numPorts, int portIndex, int height, boolean mayAdjust, int negativeShift) {
        int remainder;
        int adjustedOffset;
        CCSMAssert.isTrue((portIndex >= 1 && portIndex <= numPorts ? 1 : 0) != 0, (String)("Port index out of range: " + portIndex));
        int portSpacing = (int)(Math.round(((double)height - (double)numPorts / 2.0) / 5.0 / (double)numPorts) * 5L);
        portSpacing = Math.max(5, portSpacing);
        if (portSpacing * (numPorts - 1) > height + 2) {
            portSpacing -= 5;
        }
        int offset = (height - (numPorts - 1) * portSpacing) / 2;
        if (portSpacing > 5 && numPorts > 8 && (offset - negativeShift + 1 < 0 && offset == 0 || offset < -10)) {
            offset = (height - (numPorts - 1) * (portSpacing -= 5)) / 2;
        }
        if (offset > 10 && mayAdjust) {
            offset = SimulinkPortLayoutUtils.roundUpToGrid(offset);
        }
        if (SimulinkPortLayoutUtils.needsExtraOffset(numPorts, offset, adjustedOffset = offset - negativeShift, remainder = height - adjustedOffset - (numPorts - 1) * portSpacing)) {
            offset += 5;
        }
        return offset + (portIndex - 1) * portSpacing;
    }

    private static boolean needsExtraOffset(int numPorts, int offset, int adjustedOffset, int remainder) {
        if (remainder <= 10 || remainder - adjustedOffset < 5) {
            return false;
        }
        if (numPorts >= 8) {
            return offset <= 20;
        }
        if (numPorts >= 6) {
            return offset <= 30;
        }
        return false;
    }

    private static Point roundSumGetNthPortPos(SimulinkBlock block, int n, int width, int height) {
        double angle = SimulinkPortLayoutUtils.determineRoundSumAngle(block, n);
        return new Point((int)Math.round((1.0 - Math.sin(angle)) * (double)width / 2.0), (int)Math.round((1.0 - Math.cos(angle)) * (double)height / 2.0));
    }

    public static double determineRoundSumAngle(SimulinkBlock block, int n) {
        String ports = SimulinkPortLayoutUtils.getSumInputPortsDescription(block);
        double angle = Math.PI * (double)SimulinkPortLayoutUtils.computeLogicalIndexForSumBlockPort(ports, n) / (double)(ports.length() - 1);
        if (ports.length() <= 1) {
            angle = 1.5707963267948966;
        }
        return angle;
    }

    public static Point getPrePortPoint(SimulinkPortBase port, BlockLayoutData blockLayout) {
        int inset = 5;
        SimulinkBlock block = port.getBlock();
        if (port instanceof SimulinkInPort) {
            inset = SimulinkUtils.isRoundSum(block) ? 13 : 15;
        }
        return SimulinkPortLayoutUtils.getInsetPortPoint(port, blockLayout, inset);
    }

    public static Point getInsetPortPoint(SimulinkPortBase port, BlockLayoutData blockLayoutData, int inset) {
        int insetX = inset;
        int insetY = inset;
        SimulinkBlock block = port.getBlock();
        if (!(SimulinkUtils.isRoundSum(block) || SimulinkUtils.isRoundFunctionCallSplitBlock(block) || port.getFlexiblePortPlacementParameters().isPresent())) {
            if (blockLayoutData.getOrientation().isRotated() ^ port.isSpecialPort()) {
                insetX = 0;
            } else {
                insetY = 0;
            }
        }
        Rectangle insetAdjustedRectangle = new Rectangle(blockLayoutData.getPosition());
        insetAdjustedRectangle.grow(insetX, insetY);
        return SimulinkPortLayoutUtils.getPortLocation(port, blockLayoutData, insetAdjustedRectangle);
    }

    public static int computeLogicalIndexForSumBlockPort(String inputsParameterValue, int index) {
        int remainingPortCharsUntilTarget = index;
        for (int i = 0; i < inputsParameterValue.length(); ++i) {
            if (inputsParameterValue.charAt(i) == '|' || --remainingPortCharsUntilTarget != 0) continue;
            return i;
        }
        return inputsParameterValue.length() - 1;
    }

    private static int countNormalPorts(Collection<? extends SimulinkPortBase> ports) {
        int result = 0;
        for (SimulinkPortBase simulinkPortBase : ports) {
            if (simulinkPortBase.isSpecialPort()) continue;
            try {
                result = Math.max(result, Integer.parseInt(simulinkPortBase.getIndex()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public static int determineDirection(SimulinkPortBase port, BlockLayoutData blockLayoutData) {
        double direction = blockLayoutData.getOrientation().getDirection();
        Optional<FlexiblePortPlacementParameters> flexiblePortPlacementParameters = port.getFlexiblePortPlacementParameters();
        if (flexiblePortPlacementParameters.isPresent()) {
            FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName sideAfterBlockRotation = SimulinkPortLayoutUtils.adjustToBlockRotation(flexiblePortPlacementParameters.get().side, blockLayoutData.getOrientation());
            direction += (double)sideAfterBlockRotation.degreesCounterClockwiseFromLeft;
        }
        if (SimulinkUtils.isRoundSum(port.getBlock()) && port instanceof SimulinkInPort) {
            double directionOffset = SimulinkPortLayoutUtils.determineRoundSumAngle(port.getBlock(), Integer.parseInt(port.getIndex())) - 1.5707963267948966;
            direction += directionOffset * 180.0 / Math.PI;
        } else if (SimulinkPortLayoutUtils.isBottomFunctionCallSplitPort(port)) {
            direction += 270.0;
            if (blockLayoutData.getOrientation().isLeftOrDown()) {
                direction += 180.0;
            }
        } else if (port.isSpecialPort()) {
            direction += 270.0;
            if (SimulinkPortLayoutUtils.isSpecialPortOnBottom(port) && !blockLayoutData.getOrientation().isLeftOrDown()) {
                direction += 180.0;
            }
        }
        return (int)direction % 360;
    }

    private static boolean isBottomFunctionCallSplitPort(SimulinkPortBase port) {
        boolean hasReversedLayout = SimulinkUtils.isFunctionCallSplitBlockWithReverseOutputLayout(port.getBlock());
        String lastIndex = Integer.toString(port.getBlock().getOutPorts().size());
        boolean isBottomPort = hasReversedLayout ? "1".equals(port.getIndex()) : lastIndex.equals(port.getIndex());
        return SimulinkUtils.isRoundFunctionCallSplitBlock(port.getBlock()) && port instanceof SimulinkOutPort && isBottomPort;
    }

    private SimulinkPortLayoutUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

