/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeWithMe.ClientId;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusOwner;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageHandler;
import org.jetbrains.kotlin.com.intellij.util.messages.SimpleMessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.CompositeMessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.Message;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusConnectionImpl;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageDeliveryListener;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageQueue;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MethodHandleCache;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;

@ApiStatus.Internal
public class MessageBusImpl
implements MessageBus {
    static final Logger LOG = Logger.getInstance(MessageBusImpl.class);
    private static final Object NA = new Object();
    final ThreadLocal<MessageQueue> messageQueue;
    final ConcurrentMap<Topic<?>, Object> publisherCache;
    final Collection<MessageHandlerHolder> subscribers;
    final Map<Topic<?>, Object[]> subscriberCache;
    @Nullable
    final CompositeMessageBus parentBus;
    final RootBus rootBus;
    final MessageBusOwner owner;
    private int disposeState;
    private Disposable connectionDisposable;
    MessageDeliveryListener messageDeliveryListener;

    MessageBusImpl(@NotNull MessageBusOwner owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        this.messageQueue = ThreadLocal.withInitial(MessageQueue::new);
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue<MessageHandlerHolder>();
        this.subscriberCache = new ConcurrentHashMap();
        this.connectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        this.rootBus = (RootBus)this;
        this.parentBus = null;
    }

    public final String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + this.disposeState + ")";
    }

    @Override
    @NotNull
    public final MessageBusConnection connect() {
        return this.connect(this.connectionDisposable);
    }

    @Override
    @NotNull
    public final MessageBusConnectionImpl connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(4);
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public final SimpleMessageBusConnection simpleConnect() {
        this.checkNotDisposed();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        SimpleMessageBusConnectionImpl simpleMessageBusConnectionImpl = connection;
        if (simpleMessageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        return simpleMessageBusConnectionImpl;
    }

    @Override
    @NotNull
    public final <L> L syncPublisher(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        if (this.isDisposed()) {
            PluginException.logPluginError(LOG, "Already disposed: " + this, null, topic.getClass());
        }
        Object object = this.publisherCache.computeIfAbsent(topic, topic1 -> {
            Class listenerClass = topic1.getListenerClass();
            return Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createPublisher((Topic)topic1, topic1.getBroadcastDirection()));
        });
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        return (L)object;
    }

    @NotNull
    <L> MessagePublisher<L> createPublisher(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        if (direction == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT) {
            return new ToParentMessagePublisher<L>(topic, this);
        }
        if (direction == Topic.BroadcastDirection.TO_DIRECT_CHILDREN) {
            throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
        }
        LOG.error("Topic " + topic.getListenerClass().getName() + " broadcast direction TO_CHILDREN is not allowed for module level message bus. Please change to NONE or TO_PARENT");
        return new MessagePublisher<L>(topic, this);
    }

    @Override
    public void dispose() {
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        this.disposeState = 2;
        this.disposeChildren();
        if (this.connectionDisposable != null) {
            Disposer.dispose(this.connectionDisposable);
        }
        MessageQueue jobs = this.messageQueue.get();
        this.messageQueue.remove();
        if (!jobs.queue.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs.queue);
        }
        if (this.parentBus == null) {
            this.rootBus.waitingBuses.remove();
        } else {
            this.parentBus.onChildBusDisposed(this);
        }
    }

    void disposeChildren() {
    }

    public final boolean isDisposed() {
        return this.disposeState == 2 || this.owner.isDisposed();
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            LOG.error("Already disposed: " + this);
        }
    }

    void doComputeSubscribers(@NotNull Topic<?> topic, @NotNull List<Object> result2, boolean subscribeLazyListeners) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            MessageBusImpl.$$$reportNull$$$0(12);
        }
        for (MessageHandlerHolder subscriber : this.subscribers) {
            if (subscriber.isDisposed()) continue;
            subscriber.collectHandlers(topic, result2);
        }
    }

    @Nullable Object @NotNull [] computeSubscribers(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(13);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        this.doComputeSubscribers(topic, result2, true);
        Object[] objectArray = result2.isEmpty() ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : result2.toArray();
        if (objectArray == null) {
            MessageBusImpl.$$$reportNull$$$0(14);
        }
        return objectArray;
    }

    private void messageRemoved(@NotNull MessageQueue messageQueue) {
        if (messageQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(15);
        }
        if (messageQueue.current == null && messageQueue.queue.isEmpty()) {
            this.rootBus.waitingBuses.get().remove(this);
        }
    }

    private static void pumpMessages(@NotNull Set<? extends MessageBusImpl> waitingBuses) {
        if (waitingBuses == null) {
            MessageBusImpl.$$$reportNull$$$0(16);
        }
        ArrayList<MessageBusImpl> liveBuses = new ArrayList<MessageBusImpl>(waitingBuses.size());
        Iterator<? extends MessageBusImpl> iterator2 = waitingBuses.iterator();
        while (iterator2.hasNext()) {
            MessageBusImpl bus = iterator2.next();
            if (bus.isDisposed()) {
                iterator2.remove();
                LOG.error("Accessing disposed message bus " + bus);
                continue;
            }
            liveBuses.add(bus);
        }
        if (!liveBuses.isEmpty()) {
            MessageBusImpl.pumpWaitingBuses(liveBuses);
        }
    }

    private static void pumpWaitingBuses(@NotNull List<? extends MessageBusImpl> buses) {
        if (buses == null) {
            MessageBusImpl.$$$reportNull$$$0(17);
        }
        List<Throwable> exceptions = null;
        for (MessageBusImpl messageBusImpl : buses) {
            if (messageBusImpl.isDisposed()) continue;
            MessageQueue jobQueue = messageBusImpl.messageQueue.get();
            Message job = jobQueue.current;
            if (job != null) {
                exceptions = messageBusImpl.deliverMessage(job, jobQueue, messageBusImpl.messageDeliveryListener, exceptions);
            }
            while ((job = jobQueue.queue.pollFirst()) != null) {
                exceptions = messageBusImpl.deliverMessage(job, jobQueue, messageBusImpl.messageDeliveryListener, exceptions);
            }
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<Throwable> deliverMessage(@NotNull Message job, @NotNull MessageQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (job == null) {
            MessageBusImpl.$$$reportNull$$$0(18);
        }
        if (jobQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(19);
        }
        ClientId oldClientId = ClientId.getCurrentOrNull();
        try {
            ClientId.trySetCurrentClientId(job.clientId);
            jobQueue.current = job;
            Object[] handlers = job.handlers;
            int index2 = job.currentHandlerIndex;
            int size = handlers.length;
            int lastIndex = size - 1;
            while (index2 < size) {
                if (index2 == lastIndex) {
                    jobQueue.current = null;
                    this.messageRemoved(jobQueue);
                }
                ++job.currentHandlerIndex;
                Object handler2 = handlers[index2];
                if (handler2 != null) {
                    exceptions = MessageBusImpl.invokeListener(job.method, job.methodName, job.args, job.topic, handler2, messageDeliveryListener, exceptions);
                }
                if (++index2 == job.currentHandlerIndex) continue;
                List<Throwable> list2 = exceptions;
                return list2;
            }
            List<Throwable> list3 = exceptions;
            return list3;
        }
        finally {
            ClientId.trySetCurrentClientId(oldClientId);
        }
    }

    boolean hasChildren() {
        return false;
    }

    final void notifyOnSubscription(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(20);
        }
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while ((parentBus = parentBus.parentBus) != null) {
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren()) {
            this.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(21);
        }
    }

    void removeEmptyConnectionsRecursively() {
        this.subscribers.removeIf(MessageHandlerHolder::isDisposed);
    }

    boolean notifyConnectionTerminated(Object @NotNull [] topicAndHandlerPairs) {
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(22);
        }
        if (this.disposeState != 0) {
            return false;
        }
        this.rootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImpl.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    private static boolean clearSubscriberCacheOnConnectionTerminated(Object @NotNull [] topicAndHandlerPairs, @NotNull MessageBusImpl bus) {
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(23);
        }
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(24);
        }
        boolean isChildClearingNeeded = false;
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Topic topic = (Topic)topicAndHandlerPairs[i];
            MessageBusImpl.removeDisposedHandlers(topicAndHandlerPairs, i, topic, bus);
            Topic.BroadcastDirection direction = topic.getBroadcastDirection();
            if (direction != Topic.BroadcastDirection.TO_CHILDREN) continue;
            MessageBusImpl parentBus = bus;
            while ((parentBus = parentBus.parentBus) != null) {
                MessageBusImpl.removeDisposedHandlers(topicAndHandlerPairs, i, topic, parentBus);
            }
            if (!bus.hasChildren()) continue;
            isChildClearingNeeded = true;
        }
        return isChildClearingNeeded;
    }

    private static void removeDisposedHandlers(@NotNull @NotNull Object @NotNull [] topicAndHandlerPairs, int index2, Topic<?> topic, @NotNull MessageBusImpl bus) {
        Object[] cachedHandlers;
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(25);
        }
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(26);
        }
        if ((cachedHandlers = bus.subscriberCache.remove(topic)) == null) {
            return;
        }
        Object handler2 = topicAndHandlerPairs[index2 + 1];
        if (topic.isImmediateDelivery()) {
            int length = cachedHandlers.length;
            for (int i = 0; i < length; ++i) {
                if (cachedHandlers[i] != handler2) continue;
                cachedHandlers[i] = null;
            }
        }
        bus.removeDisposedHandlers(topic, handler2);
    }

    void clearSubscriberCache(Object @NotNull [] topicAndHandlerPairs) {
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(27);
        }
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            this.subscriberCache.remove(topicAndHandlerPairs[i]);
        }
    }

    final void deliverImmediately(@NotNull MessageBusConnectionImpl connection) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(28);
        }
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        if (this.owner.isDisposed()) {
            return;
        }
        MessageQueue jobQueue = this.messageQueue.get();
        Deque<Message> jobs = jobQueue.queue;
        if (jobs.isEmpty()) {
            return;
        }
        List<Message> newJobs = MessageBusImpl.deliverImmediately(connection, jobs);
        if (newJobs == null) {
            return;
        }
        for (int i = newJobs.size() - 1; i >= 0; --i) {
            jobs.addFirst(newJobs.get(i));
        }
        List<Throwable> exceptions = null;
        for (Message job : newJobs) {
            jobs.removeFirstOccurrence(job);
            exceptions = this.deliverMessage(job, jobQueue, this.messageDeliveryListener, exceptions);
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    @Nullable
    private static List<Message> deliverImmediately(@NotNull MessageBusConnectionImpl connection, @NotNull Deque<Message> jobs) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(29);
        }
        if (jobs == null) {
            MessageBusImpl.$$$reportNull$$$0(30);
        }
        SmartList<Message> newJobs = null;
        Iterator<Message> jobIterator = jobs.iterator();
        while (jobIterator.hasNext()) {
            Message job = jobIterator.next();
            SmartList<Object> connectionHandlers = null;
            Object[] allHandlers = job.handlers;
            int length = allHandlers.length;
            for (int i = 0; i < length; ++i) {
                Object handler2 = allHandlers[i];
                if (handler2 == null || !connection.isMyHandler(job.topic, handler2)) continue;
                allHandlers[i] = null;
                if (connectionHandlers == null) {
                    connectionHandlers = new SmartList<Object>();
                }
                connectionHandlers.add(handler2);
            }
            if (connectionHandlers == null) continue;
            if (allHandlers.length == connectionHandlers.size()) {
                jobIterator.remove();
            }
            Message filteredJob = new Message(job.topic, job.method, job.methodName, job.args, connectionHandlers.toArray());
            if (newJobs == null) {
                newJobs = new SmartList<Message>();
            }
            newJobs.add(filteredJob);
        }
        return newJobs;
    }

    @Nullable
    private static List<Throwable> invokeListener(@NotNull MethodHandle methodHandle, @NotNull String methodName, Object @Nullable [] args2, @NotNull Topic<?> topic, @NotNull Object handler2, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (methodHandle == null) {
            MessageBusImpl.$$$reportNull$$$0(31);
        }
        if (methodName == null) {
            MessageBusImpl.$$$reportNull$$$0(32);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(33);
        }
        if (handler2 == null) {
            MessageBusImpl.$$$reportNull$$$0(34);
        }
        try {
            if (handler2 instanceof MessageHandler) {
                ((MessageHandler)handler2).handle(methodHandle, args2);
            } else if (messageDeliveryListener == null) {
                MessageBusImpl.invokeMethod(handler2, args2, methodHandle);
            } else {
                long startTime = System.nanoTime();
                MessageBusImpl.invokeMethod(handler2, args2, methodHandle);
                messageDeliveryListener.messageDelivered(topic, methodName, handler2, System.nanoTime() - startTime);
            }
        }
        catch (AbstractMethodError startTime) {
        }
        catch (Throwable e) {
            if (exceptions == null) {
                exceptions = new ArrayList<Throwable>();
            }
            exceptions.add(e);
        }
        return exceptions;
    }

    private static void invokeMethod(@NotNull Object handler2, Object[] args2, MethodHandle methodHandle) throws Throwable {
        if (handler2 == null) {
            MessageBusImpl.$$$reportNull$$$0(35);
        }
        if (args2 == null) {
            methodHandle.invoke(handler2);
        } else {
            methodHandle.bindTo(handler2).invokeExact(args2);
        }
    }

    private void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler2) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(37);
        }
        if (handler2 == null) {
            MessageBusImpl.$$$reportNull$$$0(38);
        }
        MessageQueue messageQueue = this.messageQueue.get();
        if (!messageQueue.queue.isEmpty() && messageQueue.queue.removeIf(message2 -> {
            for (int messageIndex = 0; messageIndex < message2.handlers.length; ++messageIndex) {
                Object messageHandler = message2.handlers[messageIndex];
                if (messageHandler == null) {
                    return false;
                }
                if (message2.topic != topic || messageHandler != handler2) continue;
                message2.handlers[messageIndex] = null;
                return message2.handlers.length == 1;
            }
            return false;
        })) {
            this.messageRemoved(messageQueue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 20: 
            case 21: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageQueue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitingBuses";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buses";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobQueue";
                break;
            }
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topicAndHandlerPairs";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobs";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodHandle";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 34: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleConnect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSubscribers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPublisher";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doComputeSubscribers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeSubscribers";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "messageRemoved";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "pumpMessages";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "pumpWaitingBuses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deliverMessage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscriptionToTopicToChildren";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "notifyConnectionTerminated";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCacheOnConnectionTerminated";
                break;
            }
            case 25: 
            case 26: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeDisposedHandlers";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCache";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "deliverImmediately";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "invokeListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "disconnectPluginConnections";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RootBus
    extends CompositeMessageBus {
        private final AtomicReference<CompletableFuture<?>> compactionFutureRef;
        private final AtomicInteger emptyConnectionCounter;
        final ThreadLocal<Set<MessageBusImpl>> waitingBuses;

        RootBus(@NotNull MessageBusOwner owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            super(owner);
            this.compactionFutureRef = new AtomicReference();
            this.emptyConnectionCounter = new AtomicInteger();
            this.waitingBuses = ThreadLocal.withInitial(() -> new LinkedHashSet());
        }

        void scheduleEmptyConnectionRemoving() {
            CompletableFuture<Void> future;
            int counter = this.emptyConnectionCounter.incrementAndGet();
            if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
                return;
            }
            CompletableFuture<?> oldFuture = this.compactionFutureRef.get();
            if (oldFuture == null && !this.compactionFutureRef.compareAndSet(null, future = CompletableFuture.runAsync(() -> {
                this.removeEmptyConnectionsRecursively();
                this.compactionFutureRef.set(null);
            }, AppExecutorUtil.getAppExecutorService()))) {
                future.cancel(false);
            }
        }

        @Override
        public void dispose() {
            CompletableFuture compactionFuture = this.compactionFutureRef.getAndSet(null);
            if (compactionFuture != null) {
                compactionFuture.cancel(false);
            }
            super.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
        }
    }

    static final class ToParentMessagePublisher<L>
    extends MessagePublisher<L>
    implements InvocationHandler {
        ToParentMessagePublisher(@NotNull Topic<L> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(1);
            }
            super(topic, bus);
        }

        @Override
        boolean publish(@NotNull Method method, Object[] args2, @Nullable MessageQueue jobQueue) {
            if (method == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(2);
            }
            List<Throwable> exceptions = null;
            MessageBusImpl parentBus = this.bus;
            boolean hasHandlers = false;
            do {
                Object[] existing;
                Object[] handlers;
                if ((handlers = parentBus.subscriberCache.get(this.topic)) == null && (existing = parentBus.subscriberCache.putIfAbsent(this.topic, handlers = parentBus.computeSubscribers(this.topic))) != null) {
                    handlers = existing;
                }
                if (handlers.length == 0) continue;
                hasHandlers = true;
                exceptions = ToParentMessagePublisher.executeOrAddToQueue(this.topic, method, args2, handlers, jobQueue, this.bus.messageDeliveryListener, exceptions);
            } while ((parentBus = parentBus.parentBus) != null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return hasHandlers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$ToParentMessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MessagePublisher<L>
    implements InvocationHandler {
        @NotNull
        protected final Topic<L> topic;
        @NotNull
        protected final MessageBusImpl bus;

        MessagePublisher(@NotNull Topic<L> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                MessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                MessagePublisher.$$$reportNull$$$0(1);
            }
            this.topic = topic;
            this.bus = bus;
        }

        @Override
        public final Object invoke(Object proxy, Method method, Object[] args2) {
            if (method.getDeclaringClass() == Object.class) {
                return EventDispatcher.handleObjectMethod(proxy, args2, method.getName());
            }
            this.bus.checkNotDisposed();
            if (this.topic.isImmediateDelivery()) {
                this.publish(method, args2, null);
                return NA;
            }
            Set<MessageBusImpl> busQueue = this.bus.rootBus.waitingBuses.get();
            if (!busQueue.isEmpty()) {
                MessageBusImpl.pumpMessages(busQueue);
            }
            if (this.publish(method, args2, this.bus.messageQueue.get())) {
                busQueue.add(this.bus);
                MessageBusImpl.pumpMessages(busQueue);
            }
            return NA;
        }

        boolean publish(@NotNull Method method, Object[] args2, @Nullable MessageQueue jobQueue) {
            Object[] handlers;
            if (method == null) {
                MessagePublisher.$$$reportNull$$$0(2);
            }
            if ((handlers = this.bus.subscriberCache.computeIfAbsent(this.topic, topic1 -> this.bus.computeSubscribers((Topic<?>)topic1))).length == 0) {
                return false;
            }
            List<Throwable> exceptions = MessagePublisher.executeOrAddToQueue(this.topic, method, args2, handlers, jobQueue, this.bus.messageDeliveryListener, null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return true;
        }

        static List<Throwable> executeOrAddToQueue(@NotNull Topic<?> topic, @NotNull Method method, Object @Nullable [] args2, @Nullable Object @NotNull [] handlers, @Nullable MessageQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
            if (topic == null) {
                MessagePublisher.$$$reportNull$$$0(3);
            }
            if (method == null) {
                MessagePublisher.$$$reportNull$$$0(4);
            }
            if (handlers == null) {
                MessagePublisher.$$$reportNull$$$0(5);
            }
            MethodHandle methodHandle = MethodHandleCache.compute(method, args2);
            if (jobQueue == null) {
                for (Object handler2 : handlers) {
                    if (handler2 == null) continue;
                    exceptions = MessageBusImpl.invokeListener(methodHandle, method.getName(), args2, topic, handler2, messageDeliveryListener, exceptions);
                }
            } else {
                jobQueue.queue.offerLast(new Message(topic, methodHandle, method.getName(), args2, handlers));
            }
            return exceptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handlers";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$MessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeOrAddToQueue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface MessageHandlerHolder {
        public <L> void collectHandlers(@NotNull Topic<L> var1, @NotNull List<? super L> var2);

        public boolean isDisposed();
    }
}

